/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf.lmp;

import cerent.cms.model.AdminState;
import cerent.cms.model.LmpConstants;
import cerent.cms.model.LmpException;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.Pane;
import cerent.cms.ui.shelf.lmp.CtrlChannelDataSource;
import cerent.cms.ui.shelf.lmp.NodeTypeWrapper;
import cerent.cms.ui.shelf.lmp.PortWrapper;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.gui.TextAreaDialog;
import cerent.util.gui.UDialog;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class CtrlChannelCreationDialog
extends UDialog
implements ActionListener,
LmpConstants {
    public static final String TITLE = "Create LMP Control Channel";
    private JButton okButton;
    private JButton cancelButton;
    private Pane parent;
    protected CtrlChannelDataSource dsc;
    protected CtrlChannelDataSource.Info value;
    protected JComboBox adminState;
    protected JComboBox localPort;
    protected JTextField localPortId;
    protected JLabel localCtrlChannelIdLabel;
    protected JTextField localCtrlChannelId;
    protected JComboBox remoteNodeType;
    protected JTextField remoteNodeIpAddress;
    protected JTextField remoteNodeId;
    protected JTextField hello;
    protected JTextField helloMin;
    protected JTextField helloMax;
    protected JTextField helloDead;
    protected JTextField helloDeadMin;
    protected JTextField helloDeadMax;
    private boolean ok = false;
    private static final NodeTypeWrapper[] nodeTypeItems = new NodeTypeWrapper[]{NodeTypeWrapper.NT_15454, NodeTypeWrapper.NT_CRS1};

    public static CtrlChannelCreationDialog getCreationDialog(Pane pane, CtrlChannelDataSource ctrlChannelDataSource) {
        return new CtrlChannelCreationDialog(JOptionPane.getFrameForComponent((Component)pane), TITLE, new Object[]{pane, ctrlChannelDataSource});
    }

    protected CtrlChannelCreationDialog(Frame frame, String string, Object object) {
        super(frame, string, true, object);
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        this.ok = false;
        Object[] objectArray = (Object[])object;
        this.parent = (Pane)objectArray[0];
        this.dsc = (CtrlChannelDataSource)objectArray[1];
        if (this.value == null) {
            this.value = new CtrlChannelDataSource.Info(this.dsc);
        } else {
            CtrlChannelDataSource ctrlChannelDataSource = this.dsc;
            ctrlChannelDataSource.getClass();
            this.value = new CtrlChannelDataSource.Info(ctrlChannelDataSource, this.value);
        }
        jPanel.add((Component)this.getCenterPanel(), "Center");
        jPanel.add((Component)this.getButtonPanel(), "South");
    }

    public void dispose() {
        this.parent = null;
        this.dsc = null;
        super.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            if (this.valuesOk()) {
                this.ok = true;
                this.dispose();
            }
        } else if (object == this.cancelButton) {
            this.ok = false;
            this.dispose();
        } else {
            throw new IllegalArgumentException("actionPerformed: unexpected source " + object);
        }
    }

    public boolean ok() {
        return this.ok;
    }

    public CtrlChannelDataSource.Info getValues() {
        return this.value;
    }

    private void displayStatusMessage(final String string, final String string2) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new TextAreaDialog(JOptionPane.getFrameForComponent((Component)((Object)CtrlChannelCreationDialog.this)), string, string2, 650, 200);
            }
        });
    }

    private String toString(Exception exception) {
        int n;
        if (exception instanceof NumberFormatException) {
            return "invalid number format: " + exception.getMessage();
        }
        String string = exception.getMessage();
        if ((string == null || string.length() == 0) && (n = (string = exception.toString()).lastIndexOf(46)) >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    private boolean valuesOk() {
        CharSequence charSequence;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        CtrlChannelDataSource.Column column = this.dsc.getColumn("Admin State");
        try {
            column.setColumnValue(this.value, this.adminState.getSelectedItem());
        }
        catch (Exception exception) {
            arrayList.add(column.getName());
            arrayList.add(exception);
        }
        column = this.dsc.getColumn("Local Port");
        try {
            column.setColumnValue(this.value, this.localPort.getSelectedItem());
        }
        catch (Exception exception) {
            arrayList.add(column.getName());
            arrayList.add(exception);
        }
        column = this.dsc.getColumn("Remote Node Address");
        try {
            charSequence = this.remoteNodeIpAddress.getText().trim();
            if (InetAddress.getByName((String)charSequence).getAddress().length > 4) {
                arrayList.add(column.getName());
                arrayList.add(new Exception("IPv6 Address cannot be specified."));
            }
            column.setColumnValue(this.value, charSequence);
        }
        catch (UnknownHostException unknownHostException) {
            arrayList.add(column.getName());
            arrayList.add(new Exception("IP address is invalid."));
        }
        catch (Exception exception) {
            arrayList.add(column.getName());
            arrayList.add(exception);
        }
        column = this.dsc.getColumn("Remote Node Id");
        try {
            charSequence = this.remoteNodeId.getText().trim();
            if (InetAddress.getByName((String)charSequence).getAddress().length > 4) {
                arrayList.add(column.getName());
                arrayList.add(new Exception("IPv6 Address cannot be specified."));
            }
            column.setColumnValue(this.value, charSequence);
        }
        catch (UnknownHostException unknownHostException) {
            arrayList.add(column.getName());
            arrayList.add(new Exception("IP address is invalid."));
        }
        catch (Exception exception) {
            arrayList.add(column.getName());
            arrayList.add(exception);
        }
        column = this.dsc.getColumn("Requested Hello Interval");
        try {
            column.setColumnValue(this.value, this.hello.getText());
        }
        catch (Exception exception) {
            arrayList.add(column.getName());
            arrayList.add(exception);
        }
        column = this.dsc.getColumn("Min Hello Interval");
        try {
            column.setColumnValue(this.value, this.helloMin.getText());
        }
        catch (Exception exception) {
            arrayList.add(column.getName());
            arrayList.add(exception);
        }
        column = this.dsc.getColumn("Max Hello Interval");
        try {
            column.setColumnValue(this.value, this.helloMax.getText());
        }
        catch (Exception exception) {
            arrayList.add(column.getName());
            arrayList.add(exception);
        }
        column = this.dsc.getColumn("Requested Hello Dead Interval");
        try {
            column.setColumnValue(this.value, this.helloDead.getText());
        }
        catch (Exception exception) {
            arrayList.add(column.getName());
            arrayList.add(exception);
        }
        column = this.dsc.getColumn("Min Hello Dead Interval");
        try {
            column.setColumnValue(this.value, this.helloDeadMin.getText());
        }
        catch (Exception exception) {
            arrayList.add(column.getName());
            arrayList.add(exception);
        }
        column = this.dsc.getColumn("Max Hello Dead Interval");
        try {
            column.setColumnValue(this.value, this.helloDeadMax.getText());
        }
        catch (Exception exception) {
            arrayList.add(column.getName());
            arrayList.add(exception);
        }
        column = this.dsc.getColumn("Min Hello Interval");
        try {
            column.checkValue(this.value);
        }
        catch (Exception exception) {
            arrayList.add(column.getName());
            arrayList.add(exception);
        }
        column = this.dsc.getColumn("Max Hello Interval");
        try {
            column.checkValue(this.value);
        }
        catch (Exception exception) {
            arrayList.add(column.getName());
            arrayList.add(exception);
        }
        column = this.dsc.getColumn("Requested Hello Interval");
        try {
            column.checkValue(this.value);
        }
        catch (Exception exception) {
            arrayList.add(column.getName());
            arrayList.add(exception);
        }
        column = this.dsc.getColumn("Min Hello Dead Interval");
        try {
            column.checkValue(this.value);
        }
        catch (Exception exception) {
            arrayList.add(column.getName());
            arrayList.add(exception);
        }
        column = this.dsc.getColumn("Max Hello Dead Interval");
        try {
            column.checkValue(this.value);
        }
        catch (Exception exception) {
            arrayList.add(column.getName());
            arrayList.add(exception);
        }
        column = this.dsc.getColumn("Requested Hello Dead Interval");
        try {
            column.checkValue(this.value);
        }
        catch (Exception exception) {
            arrayList.add(column.getName());
            arrayList.add(exception);
        }
        column = this.dsc.getColumn("Remote Node Type");
        try {
            column.setColumnValue(this.value, this.remoteNodeType.getSelectedItem());
        }
        catch (Exception exception) {
            arrayList.add(column.getName());
            arrayList.add(exception);
        }
        if (arrayList.size() > 0) {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("Failed to validate LMP control channel parameters:\n\n");
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Exception exception = (Exception)iterator.next();
                ((StringBuffer)charSequence).append(string);
                ((StringBuffer)charSequence).append(": ");
                ((StringBuffer)charSequence).append(this.toString(exception));
                ((StringBuffer)charSequence).append("\n");
            }
            this.displayStatusMessage("LMP Control Channel Validation Errors", ((StringBuffer)charSequence).toString());
        }
        return arrayList.size() <= 0;
    }

    private void helpPutDefaultAdminState(String string, JComboBox jComboBox) {
        jComboBox.setSelectedItem(this.dsc.getAdminStateChoice(this.dsc.getDefaultValue(string)));
    }

    private void helpPutDefaultInterval(String string, JTextField jTextField) {
        jTextField.setText(this.dsc.getDefaultValue(string) + "ms");
    }

    private void putDefaults() {
        this.helpPutDefaultAdminState("Admin State", this.adminState);
        this.helpPutDefaultInterval("Requested Hello Interval", this.hello);
        this.helpPutDefaultInterval("Min Hello Interval", this.helloMin);
        this.helpPutDefaultInterval("Max Hello Interval", this.helloMax);
        this.helpPutDefaultInterval("Requested Hello Dead Interval", this.helloDead);
        this.helpPutDefaultInterval("Min Hello Dead Interval", this.helloDeadMin);
        this.helpPutDefaultInterval("Max Hello Dead Interval", this.helloDeadMax);
    }

    private JPanel getCenterPanel() {
        PortWrapper[] portWrapperArray;
        JPanel jPanel = new JPanel(new GridLayout(0, 2, 5, 5));
        try {
            portWrapperArray = this.dsc.getLocalPortChoices(this.value);
        }
        catch (LmpException lmpException) {
            ErrorMsg.displayError((Component)((Object)this), (EID)lmpException.getEid());
            portWrapperArray = new PortWrapper[]{};
        }
        jPanel.add(new JLabel("Admin State:", 4));
        this.adminState = new JComboBox<AdminState>(this.dsc.getAdminStateChoices());
        jPanel.add(this.adminState);
        jPanel.add(new JLabel("Local Port:", 4));
        this.localPort = new JComboBox<PortWrapper>(portWrapperArray);
        jPanel.add(this.localPort);
        jPanel.add(new JLabel("Local Port Id:", 4));
        this.localPortId = new JTextField(20);
        jPanel.add(this.localPortId);
        this.localCtrlChannelIdLabel = new JLabel("Local Control Channel Id:", 4);
        jPanel.add(this.localCtrlChannelIdLabel);
        this.localCtrlChannelId = new JTextField(20);
        jPanel.add(this.localCtrlChannelId);
        jPanel.add(new JLabel("Remote Node Type:", 4));
        this.remoteNodeType = new JComboBox<NodeTypeWrapper>(nodeTypeItems);
        jPanel.add(this.remoteNodeType);
        jPanel.add(new JLabel("Remote Node Address:", 4));
        this.remoteNodeIpAddress = new JTextField(20);
        jPanel.add(this.remoteNodeIpAddress);
        jPanel.add(new JLabel("Remote Node Id:", 4));
        this.remoteNodeId = new JTextField(20);
        jPanel.add(this.remoteNodeId);
        jPanel.add(new JLabel("Requested Hello Interval:", 4));
        this.hello = new JTextField(20);
        jPanel.add(this.hello);
        jPanel.add(new JLabel("Min Hello Interval:", 4));
        this.helloMin = new JTextField(20);
        jPanel.add(this.helloMin);
        jPanel.add(new JLabel("Max Hello Interval:", 4));
        this.helloMax = new JTextField(20);
        jPanel.add(this.helloMax);
        jPanel.add(new JLabel("Requested Hello Dead Interval:", 4));
        this.helloDead = new JTextField(20);
        jPanel.add(this.helloDead);
        jPanel.add(new JLabel("Min Hello Dead Interval:", 4));
        this.helloDeadMin = new JTextField(20);
        jPanel.add(this.helloDeadMin);
        jPanel.add(new JLabel("Max Hello Dead Interval:", 4));
        this.helloDeadMax = new JTextField(20);
        jPanel.add(this.helloDeadMax);
        this.putDefaults();
        this.localPortId.setEnabled(false);
        this.localCtrlChannelIdLabel.setVisible(false);
        this.localCtrlChannelId.setVisible(false);
        this.localCtrlChannelId.setEnabled(false);
        if (this.value._vModel != null) {
            this.remoteNodeType.setEnabled(false);
        }
        this.updateLocalPortId();
        this.localPort.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                CtrlChannelCreationDialog.this.updateLocalPortId();
            }
        });
        this.remoteNodeIpAddress.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                CtrlChannelCreationDialog.this.updateRemoteNodeId();
            }
        });
        return jPanel;
    }

    private void updateLocalPortId() {
        PortWrapper portWrapper = (PortWrapper)this.localPort.getSelectedItem();
        this.localPortId.setText(portWrapper != null ? this.dsc.asString(portWrapper.getPortId(), '0', 8) : "");
    }

    private void updateRemoteNodeId() {
        if (this.remoteNodeId.getText().trim().length() == 0) {
            try {
                CtrlChannelDataSource.Column column = this.dsc.getColumn("Remote Node Id");
                String string = this.remoteNodeIpAddress.getText().trim();
                column.setColumnValue(this.value, string);
                this.remoteNodeId.setText((String)column.getColumnValue(this.value));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton("OK");
        jPanel.add(this.okButton);
        this.cancelButton = this.makeActionButton("Cancel");
        jPanel.add(this.cancelButton);
        jPanel.add(new CSHelpButton(this.getCsHelpId()));
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    protected CSHelpID getCsHelpId() {
        return CSHelpConst.LmpCtrlChannelCreationDialog;
    }
}

