/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf.lmp;

import cerent.cms.idl.Common.sIpAddr;
import cerent.cms.model.INodeHelper;
import cerent.cms.model.LmpCtrlChannelModels;
import cerent.cms.model.LmpException;
import cerent.cms.model.LmpTeLinkModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.AbstractDataSourceControl;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.ObserverPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.shelf.lmp.CtrlChannelCreationDialog;
import cerent.cms.ui.shelf.lmp.CtrlChannelDataSource;
import cerent.cms.ui.shelf.lmp.CtrlChannelDeletionDialog;
import cerent.cms.ui.shelf.lmp.CtrlChannelEditDialog;
import cerent.cms.ui.shelf.lmp.NodeTypeWrapper;
import cerent.cms.ui.shelf.lmp.crs.CrsControlChannelManager;
import cerent.cms.ui.shelf.lmp.crs.ICrsLmpCallback;
import cerent.util.ComparisonUtil;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.IObservableManager;
import cerent.util.ObservableManager;
import cerent.util.Pair;
import cerent.util.Preferences;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.SortableRowTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class CtrlChannelPane
extends ObserverPane
implements Observer {
    private static final String CREATE = "Create...";
    private static final String EDIT = "Edit...";
    private static final String DELETE = "Delete...";
    private JButton createButton;
    private JButton editButton;
    private JButton deleteButton;
    private JPanel buttonRow;
    private UScrollPane scrollPane;
    private NodeModelDelegate node;
    private Info dsc;
    private INodeHelper nodeHelper;

    public CtrlChannelPane(String string, LmpCtrlChannelModels lmpCtrlChannelModels, TabbedView tabbedView, INodeHelper iNodeHelper) {
        super(string, tabbedView);
        this.trace("<init>");
        this.node = (NodeModelDelegate)lmpCtrlChannelModels.getNodeModel();
        this.nodeHelper = iNodeHelper;
        this.dsc = new Info(lmpCtrlChannelModels);
        this.setDataSourceControl(this.dsc);
    }

    public void destroy() {
        this.trace("destroy");
        TablePropertyMgr.setColumnPrefs(this.getTable(), this.getClass().getName());
        super.destroy();
    }

    public void enteringPage() throws Exception {
        this.trace("enteringPage");
        super.enteringPage();
        TablePropertyMgr.getColumnPrefs(this.getTable(), this.getClass().getName());
    }

    public void leavingPage() throws Exception {
        this.trace("leavingPage");
        TablePropertyMgr.setColumnPrefs(this.getTable(), this.getClass().getName());
        super.leavingPage();
    }

    private void setTable(JTable jTable) {
        this.table = jTable;
    }

    public void update(Observable observable, Object object) {
        this.trace("update");
        this.requestRefresh(observable, null);
        this.manageButtons();
    }

    private void manageButtons() {
        boolean bl = this.isUserAuthorized();
        int n = this.dsc.getSelectedRowCount();
        this.createButton.setEnabled(bl);
        this.editButton.setEnabled(bl && n == 1);
        this.deleteButton.setEnabled(bl && n > 0);
    }

    private void trace(String string) {
        if (db.on()) {
            db.println("CtrlChannelPane." + string + "(" + this.node.getHostName() + ")");
        }
    }

    private class Info
    extends AbstractDataSourceControl {
        private LmpCtrlChannelModels _model;
        private ObservableManager _om;
        private CtrlChannelDataSource _ds;
        private SortableRowTableModel _tm;
        private Thread _updater;
        private boolean _needsUpdate;
        private CrsControlChannelManager crsCcMgr;

        Info(LmpCtrlChannelModels lmpCtrlChannelModels) {
            this._model = lmpCtrlChannelModels;
            this._om = new ObservableManager(CtrlChannelPane.this, true);
            this._ds = null;
            this._tm = null;
            this._updater = null;
            this._needsUpdate = false;
            ICrsLmpCallback iCrsLmpCallback = new ICrsLmpCallback(){

                public void operationStarted(String string) {
                    CtrlChannelPane.this.createButton.setEnabled(false);
                    CtrlChannelPane.this.editButton.setEnabled(false);
                    CtrlChannelPane.this.deleteButton.setEnabled(false);
                    CtrlChannelPane.this.uiToolkit.setSBText(string);
                }

                public void operationStopped() {
                    CtrlChannelPane.this.createButton.setEnabled(true);
                    CtrlChannelPane.this.editButton.setEnabled(true);
                    CtrlChannelPane.this.deleteButton.setEnabled(true);
                    CtrlChannelPane.this.uiToolkit.setSBText("");
                }
            };
            this.crsCcMgr = new CrsControlChannelManager(CtrlChannelPane.this, CtrlChannelPane.this.node, CtrlChannelPane.this.nodeHelper, iCrsLmpCallback, db);
        }

        private synchronized boolean needsUpdate() {
            if (this._needsUpdate) {
                this._needsUpdate = false;
                return true;
            }
            this._updater = null;
            return false;
        }

        private void doUpdate() {
            CtrlChannelPane.this.trace("doUpdate");
            try {
                this._ds.refreshFromModel();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public synchronized void refreshFromModel() throws Exception {
            CtrlChannelPane.this.trace("refreshFromModel");
            this._needsUpdate = true;
            if (this._updater == null) {
                this._updater = new Thread(new Runnable(){

                    public void run() {
                        CtrlChannelPane.this.uiToolkit.setSBText("Loading control channels...");
                        while (Info.this.needsUpdate()) {
                            Info.this.doUpdate();
                        }
                        CtrlChannelPane.this.uiToolkit.setSBText("");
                    }
                });
                this._updater.start();
            }
        }

        public void refreshFromModel(int n) throws Exception {
            CtrlChannelPane.this.trace("refreshFromModel");
            if (n == -1) {
                this.initUi();
            }
            this.refreshFromModel();
        }

        public void applyToModel() {
        }

        private void createCtrlChannel() {
            CtrlChannelCreationDialog ctrlChannelCreationDialog = CtrlChannelCreationDialog.getCreationDialog(CtrlChannelPane.this, this._ds);
            ctrlChannelCreationDialog.show();
            if (ctrlChannelCreationDialog.ok()) {
                if (ctrlChannelCreationDialog.getValues().getNodeType() == NodeTypeWrapper.NT_CRS1) {
                    if (Preferences.instance().getInt("ctc.router", "skipLmp", 0) != 0 || CerentDialog.yesNoDialog((Component)((Object)CtrlChannelPane.this), (String)ErrorMsg.getString((EID)EMC.WID_CHANGE_CRS_CONFIG), (String)"Confirm")) {
                        this.crsCcMgr.create(ctrlChannelCreationDialog.getValues().toAttrs());
                    }
                    return;
                }
                try {
                    this._model.createCtrlChannel(ctrlChannelCreationDialog.getValues().toAttrs());
                }
                catch (LmpException lmpException) {
                    ErrorMsg.displayError((Component)((Object)CtrlChannelPane.this), (EID)lmpException.getEid());
                }
            }
        }

        private void editCtrlChannel() {
            CtrlChannelDataSource.Info[] infoArray = this.getSelectedRows();
            for (int i = 0; i < infoArray.length; ++i) {
                this.editCtrlChannel(infoArray[i]);
            }
        }

        private void editCtrlChannel(CtrlChannelDataSource.Info info) {
            CtrlChannelEditDialog ctrlChannelEditDialog = CtrlChannelEditDialog.getEditDialog(CtrlChannelPane.this, this._ds, info);
            ctrlChannelEditDialog.show();
            if (ctrlChannelEditDialog.ok()) {
                try {
                    if (ctrlChannelEditDialog.getValues().getNodeType() == NodeTypeWrapper.NT_CRS1) {
                        if (!this.isCtrlChannelEditable(info._vRemoteNodeIpAddress)) {
                            ErrorMsg.displayError((Component)((Object)CtrlChannelPane.this), (EID)EMC.LMP_TLINK_USING_CHANNEL);
                            return;
                        }
                        if (Preferences.instance().getInt("ctc.router", "skipLmp", 0) != 0 || CerentDialog.yesNoDialog((Component)((Object)CtrlChannelPane.this), (String)ErrorMsg.getString((EID)EMC.WID_CHANGE_CRS_CONFIG), (String)"Confirm")) {
                            this.crsCcMgr.edit(info.getModel(), ctrlChannelEditDialog.getValues().toAttrs());
                        }
                    } else {
                        info.getModel().set(ctrlChannelEditDialog.getValues().toAttrs());
                    }
                }
                catch (LmpException lmpException) {
                    ErrorMsg.displayError((Component)((Object)CtrlChannelPane.this), (EID)lmpException.getEid());
                }
            }
        }

        private void deleteCtrlChannel() {
            CtrlChannelDataSource.Info[] infoArray = CtrlChannelPane.this.dsc.getSelectedRows();
            CtrlChannelDeletionDialog ctrlChannelDeletionDialog = CtrlChannelDeletionDialog.getDeletionDialog(CtrlChannelPane.this, this._ds, infoArray);
            ctrlChannelDeletionDialog.show();
            if (ctrlChannelDeletionDialog.ok()) {
                ArrayList<CtrlChannelDataSource.Info> arrayList = new ArrayList<CtrlChannelDataSource.Info>();
                for (CtrlChannelDataSource.Info info : infoArray) {
                    try {
                        if (info.getNodeType() == NodeTypeWrapper.NT_CRS1) {
                            if (!this.isCtrlChannelEditable(info.getRemoteNodeIpAddress())) {
                                ErrorMsg.displayError((Component)((Object)CtrlChannelPane.this), (EID)EMC.LMP_TLINK_USING_CHANNEL);
                                return;
                            }
                            arrayList.add(info);
                            continue;
                        }
                        this._model.deleteCtrlChannel(info.getLocalCtrlChannelId());
                    }
                    catch (LmpException lmpException) {
                        ErrorMsg.displayError((Component)((Object)CtrlChannelPane.this), (EID)lmpException.getEid());
                    }
                }
                if (arrayList.size() > 0 && (Preferences.instance().getInt("ctc.router", "skipLmp", 0) != 0 || CerentDialog.yesNoDialog((Component)((Object)CtrlChannelPane.this), (String)ErrorMsg.getString((EID)EMC.WID_CHANGE_CRS_CONFIG), (String)"Confirm"))) {
                    ArrayList arrayList2 = new ArrayList();
                    for (CtrlChannelDataSource.Info info : arrayList) {
                        arrayList2.add(new Pair((Object)info.getLocalCtrlChannelId(), (Object)info.toAttrs()));
                    }
                    this.crsCcMgr.delete(arrayList2);
                }
            }
        }

        private boolean isCtrlChannelEditable(sIpAddr sIpAddr2) throws LmpException {
            LmpTeLinkModel[] lmpTeLinkModelArray;
            for (LmpTeLinkModel lmpTeLinkModel : lmpTeLinkModelArray = CtrlChannelPane.this.node.getLmpTeLinkModels().getTeLinks()) {
                if (ComparisonUtil.compare((byte[])lmpTeLinkModel.getRemoteNodeId().addr, (byte[])sIpAddr2.addr) != 0) continue;
                return false;
            }
            return true;
        }

        public IObservableManager getObservableManager() {
            return this._om;
        }

        public void disposeDataSource() {
            CtrlChannelPane.this.trace("disposeDataSource");
            this._om.removeObservable((Observable)((Object)this._model));
            if (this._ds != null) {
                this._ds.dispose();
            }
        }

        int getSelectedRowCount() {
            return CtrlChannelPane.this.getTable().getSelectedRowCount();
        }

        CtrlChannelDataSource.Info[] getSelectedRows() {
            int[] nArray = CtrlChannelPane.this.getTable().getSelectedRows();
            Object[] objectArray = new CtrlChannelDataSource.Info[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                objectArray[i] = (CtrlChannelDataSource.Info)this._tm.getValueAt(nArray[i], 0);
            }
            Arrays.sort(objectArray);
            return objectArray;
        }

        UScrollPane initTable() {
            this._ds = new CtrlChannelDataSource(this._model);
            this._tm = new SortableRowTableModel((RowDataSource)this._ds, this._ds.getRenderers(), this._ds.getRowObjectClass());
            CtrlChannelPane.this.setTable((JTable)new UTable((TableModel)((Object)this._tm)));
            this._tm.initTable(CtrlChannelPane.this.getTable());
            this._ds.setTableModel(this._tm);
            ListSelectionModel listSelectionModel = CtrlChannelPane.this.getTable().getSelectionModel();
            listSelectionModel.setSelectionMode(2);
            listSelectionModel.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!listSelectionEvent.getValueIsAdjusting()) {
                        CtrlChannelPane.this.manageButtons();
                    }
                }
            });
            this._om.addObservable((Observable)((Object)this._model));
            return new UScrollPane((Component)CtrlChannelPane.this.getTable());
        }

        void initUi() {
            CtrlChannelPane.this.trace("initUi");
            CtrlChannelPane.this.setLayout(new BorderLayout());
            CtrlChannelPane.this.buttonRow = AbstractPane.createHorizontalPanel(null);
            CtrlChannelPane.this.buttonRow.setLayout(new BorderLayout());
            CtrlChannelPane.this.scrollPane = this.initTable();
            CtrlChannelPane.this.createButton = new JButton(CtrlChannelPane.CREATE);
            CtrlChannelPane.this.createButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Info.this.createCtrlChannel();
                }
            });
            CtrlChannelPane.this.editButton = new JButton(CtrlChannelPane.EDIT);
            CtrlChannelPane.this.editButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Info.this.editCtrlChannel();
                }
            });
            CtrlChannelPane.this.deleteButton = new JButton(CtrlChannelPane.DELETE);
            CtrlChannelPane.this.deleteButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Info.this.deleteCtrlChannel();
                }
            });
            CtrlChannelPane.this.manageButtons();
            JPanel jPanel = new JPanel(new FlowLayout(0, 5, 5));
            JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
            jPanel.add(CtrlChannelPane.this.createButton);
            jPanel.add(CtrlChannelPane.this.editButton);
            jPanel.add(CtrlChannelPane.this.deleteButton);
            jPanel2.add(new CSHelpButton(CSHelpConst.LmpCtrlChannelPane));
            CtrlChannelPane.this.buttonRow.add((Component)jPanel, "Center");
            CtrlChannelPane.this.buttonRow.add((Component)jPanel2, "East");
            CtrlChannelPane.this.add((Component)CtrlChannelPane.this.scrollPane, "Center");
            CtrlChannelPane.this.add(CtrlChannelPane.this.buttonRow, "South");
        }
    }
}

