/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf.lmp.crs;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.OpticsChannelModel;
import cerent.cms.model.OpticsPortModel;
import cerent.cms.ui.shelf.lmp.crs.CrsDataLinkManager;
import cerent.cms.ui.shelf.lmp.crs.DlCommand;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import java.awt.Component;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DlCheckOchPortCmd
extends DlCommand {
    private int tIndex;

    public DlCheckOchPortCmd(CrsDataLinkManager crsDataLinkManager, int n) {
        super(crsDataLinkManager);
        this.tIndex = n;
    }

    @Override
    public HashMap<DlCommand.Key, Object> execute(HashMap<DlCommand.Key, Object> hashMap) {
        this._ok = true;
        IPortModel iPortModel = null;
        try {
            IInterfaceModel iInterfaceModel;
            iPortModel = (IPortModel)this.mgr.node.getEntityTableModel().getEntityModelByIndex(this.tIndex);
            if (!(iPortModel instanceof OpticsPortModel && ((OpticsPortModel)iPortModel).isPassivePort() || (iInterfaceModel = iPortModel.getInterfaceModel()) instanceof OpticsChannelModel)) {
                ErrorMsg.displayError((Component)((Object)this.mgr.pane), (EID)EMC.EID_WRONG_INTERFACE_TYPE_PARAM_1, (Object)"CRS-1 Data Links can only end on OCH ports");
                this._ok = false;
            }
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            ErrorMsg.displayError((Component)((Object)this.mgr.pane), (EID)EMC.EID_NO_SUCH_INTERFACE_PARAM_1, (Object)("Local Port: 0x" + Integer.toHexString(this.tIndex)));
            this._ok = false;
        }
        return hashMap;
    }

    @Override
    public boolean undo() {
        return true;
    }
}

