/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf.lmp.crs;

import cerent.cms.ui.shelf.lmp.crs.CrsDataLinkManager;
import cerent.cms.ui.shelf.lmp.crs.DlCommand;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.InetUtil;
import cerent.util.KDebug;
import cerent.util.Pair;
import cerent.util.tty.CLIAction;
import cerent.util.tty.CLIShowRunAction;
import com.cisco.crs.model.PlimPortId;
import java.awt.Component;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DlCheckPlimCmd
extends DlCommand {
    private PlimPortId plim;
    private String crsIpAddr;
    private boolean forDeletion;

    public DlCheckPlimCmd(CrsDataLinkManager crsDataLinkManager, String string, int n, boolean bl) {
        super(crsDataLinkManager);
        this.crsIpAddr = string;
        this.plim = new PlimPortId(n);
        this.forDeletion = bl;
    }

    @Override
    public HashMap<DlCommand.Key, Object> execute(HashMap<DlCommand.Key, Object> hashMap) {
        Object object;
        CLIShowRunAction.Result result;
        if (hashMap.containsKey((Object)DlCommand.Key.SHOWRUN_RESULT) && this.crsIpAddr.equals(hashMap.get((Object)DlCommand.Key.SHOWRUN_ADDRESS))) {
            result = (CLIShowRunAction.Result)hashMap.get((Object)DlCommand.Key.SHOWRUN_RESULT);
        } else {
            object = new CLIShowRunAction(this.crsIpAddr, (KDebug)this.mgr.db);
            result = object.get();
            if (result == null) {
                this.showCliError((CLIAction)object);
                this._ok = false;
                return hashMap;
            }
            if (!hashMap.containsKey((Object)DlCommand.Key.SHOWRUN_RESULT)) {
                hashMap.put(DlCommand.Key.SHOWRUN_RESULT, result);
                hashMap.put(DlCommand.Key.SHOWRUN_ADDRESS, this.crsIpAddr);
            }
        }
        object = result.getConnIdForPlim(this.plim);
        if (object != null) {
            ErrorMsg.displayError((Component)((Object)this.mgr.pane), (EID)EMC.EID_PLIM_IS_PART_OF_OCHTRAIL_PARAM_1, (Object)this.plim.toString());
            this._ok = false;
            return hashMap;
        }
        Pair pair = result.getLmpNeighborAndType(this.plim);
        if (pair == null || ((String)pair.getFirst()).equals(InetUtil.makeDottedString(this.mgr.node.getIpConfig().getIpAddress()))) {
            if (pair != null && this.forDeletion) {
                hashMap.put(DlCommand.Key.DEL_PLIM_TYPE, pair.getSecond());
            }
            this._ok = true;
        } else {
            this._ok = false;
            ErrorMsg.displayError((Component)((Object)this.mgr.pane), EMC.EID_PLIM_ALREADY_IN_LMP_DL_PARAM_2, this.plim.getShortString(), pair.getFirst());
        }
        return hashMap;
    }

    @Override
    public boolean undo() {
        return true;
    }
}

