/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf.lmp.crs;

import cerent.cms.idl.Lmp.sDataLinkAttrsEx;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.LmpException;
import cerent.cms.model.LmpTeLinkModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.OpticsChannelModel;
import cerent.cms.model.OpticsPortModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.WrongPortType;
import cerent.cms.ui.Wavelength;
import cerent.cms.ui.shelf.lmp.crs.CrsDataLinkManager;
import cerent.cms.ui.shelf.lmp.crs.DlCommand;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.tty.CLIAction;
import cerent.util.tty.CLIDataLinkAction;
import cerent.util.tty.CLILmpIdAction;
import com.cisco.crs.model.PlatformNodeModel;
import com.cisco.crs.model.PlimInterfaceModel;
import com.cisco.crs.model.PlimPortId;
import com.cisco.crs.model.PlimPortModel;
import com.cisco.crs.model.core.LmpIdStore;
import java.awt.Component;
import java.io.IOException;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DlCreateCmd
extends DlCommand {
    private String crsIpAddr;
    private sDataLinkAttrsEx values;
    private boolean setLocal;
    private boolean setRemote;
    private LmpTeLinkModel tel;
    private UndoData undoData = new UndoData();

    public DlCreateCmd(CrsDataLinkManager crsDataLinkManager, String string, sDataLinkAttrsEx sDataLinkAttrsEx2, boolean bl, boolean bl2) {
        super(crsDataLinkManager);
        this.crsIpAddr = string;
        this.values = sDataLinkAttrsEx2;
        this.setLocal = bl;
        this.setRemote = bl2;
    }

    @Override
    public HashMap<DlCommand.Key, Object> execute(HashMap<DlCommand.Key, Object> hashMap) {
        Integer n = this.values.remote_id;
        this._ok = true;
        this.undoData.state = UndoState.NO_CHANGE;
        try {
            if (this.setRemote) {
                CLILmpIdAction cLILmpIdAction;
                PlimPortId plimPortId = new PlimPortId(this.values.remote_crsPort);
                IEntityTableModel iEntityTableModel = this.mgr.nodeHelper.getEntityTableModel(this.crsIpAddr);
                PlatformNodeModel platformNodeModel = (PlatformNodeModel)iEntityTableModel.getNodeModel().getDelegate();
                PlimPortModel plimPortModel = (PlimPortModel)iEntityTableModel.getEntityModelByIndex(plimPortId.getPortId());
                this.undoData.plimType = plimPortModel.getPlimType();
                CLIDataLinkAction cLIDataLinkAction = new CLIDataLinkAction(this.crsIpAddr, (KDebug)this.mgr.db);
                IPortModel iPortModel = (IPortModel)this.mgr.node.getEntityTableModel().getEntityModelByIndex(this.values.tIndex);
                int n2 = 0;
                if (!(iPortModel instanceof OpticsPortModel) || !((OpticsPortModel)iPortModel).isPassivePort()) {
                    OpticsChannelModel opticsChannelModel = (OpticsChannelModel)iPortModel.getInterfaceModel();
                    n2 = opticsChannelModel.getActualWaveLength();
                    if (n2 == 0) {
                        n2 = opticsChannelModel.getExpectedWaveLength();
                    }
                } else {
                    n2 = ((OpticsPortModel)iPortModel).getWaveLength();
                }
                this.tel = this.mgr.teModels.getTeLink(this.values.te_link_id);
                int n3 = Wavelength.getCrsLambdaIdFromLambda(n2);
                int n4 = this.values.tIndex;
                if (cLIDataLinkAction.create(plimPortModel.getPlimType(), new PlimPortId(this.values.remote_crsPort).toString(), this.mgr.node.getActualHostName(), platformNodeModel.getMgmtIfName(), this.values.te_link_id, n4, n3, true)) {
                    this.showCliError((CLIAction)cLIDataLinkAction);
                    this._ok = false;
                    return hashMap;
                }
                this.undoData.state = UndoState.REMOTE_SET;
                n = ((PlimInterfaceModel)plimPortModel.getInterfaceModel()).getLmpId();
                if (n == 0 && (n = Integer.valueOf((cLILmpIdAction = new CLILmpIdAction(this.crsIpAddr, (KDebug)this.mgr.db)).get(this.undoData.plimType, plimPortId.toString()))) == -1) {
                    this.showCliError((CLIAction)cLILmpIdAction);
                    this._ok = false;
                    return hashMap;
                }
                this.values.remote_id = n;
                hashMap.put(DlCommand.Key.LMP_REMOTE_ID, n);
            }
            if (this.setLocal) {
                if (this.setRemote) {
                    this.setRemoteId(this.tel, n);
                    this.undoData.state = UndoState.LOCAL_TEL_SET;
                }
                this.undoData.dataLinkId = this.mgr.node.getLmpDataLinkModels().createDataLink(this.values);
                LmpIdStore.getInstance().addId(this.crsIpAddr, this.values.remote_crsPort, this.values.remote_id);
                this.undoData.state = UndoState.LOCAL_DL_SET;
            }
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            ErrorMsg.displayError((Component)((Object)this.mgr.pane), (EID)EMC.EID_WRONG_INTERFACE_TYPE_PARAM_1, (Object)"LMP Create Data Link");
            this._ok = false;
        }
        catch (NoSuchInterface noSuchInterface) {
            ErrorMsg.displayError((Component)((Object)this.mgr.pane), (EID)EMC.EID_NO_SUCH_INTERFACE_PARAM_1, (Object)this.values.tIndex);
            this._ok = false;
        }
        catch (LmpException lmpException) {
            ErrorMsg.displayError((Component)((Object)this.mgr.pane), (EID)lmpException.getEid());
            this._ok = false;
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            ErrorMsg.displayError((Component)((Object)this.mgr.pane), (EID)EMC.EID_NO_SUCH_INTERFACE_PARAM_1, (Object)new PlimPortId(this.values.remote_crsPort).toString());
            this._ok = false;
        }
        catch (IOException iOException) {
            ErrorMsg.displayError((Component)((Object)this.mgr.pane), (EID)EMC.EID_CRS_IO_ERROR);
            this._ok = false;
        }
        catch (WrongPortType wrongPortType) {
            ErrorMsg.displayError((Component)((Object)this.mgr.pane), (EID)EMC.EID_WRONG_INTERFACE_TYPE_PARAM_1, (Object)"LMP Create Data Link");
            this._ok = false;
        }
        return hashMap;
    }

    @Override
    public boolean undo() {
        try {
            switch (this.undoData.state) {
                case LOCAL_DL_SET: {
                    LmpIdStore.getInstance().removeId(this.crsIpAddr, this.values.remote_crsPort);
                    this.mgr.node.getLmpDataLinkModels().deleteDataLink(this.undoData.dataLinkId);
                    if (!this.setRemote) break;
                }
                case LOCAL_TEL_SET: {
                    this.setRemoteId(this.tel, this.mgr.node.getLmpTeLinkModels().getTempIdForCrsTe());
                }
                case REMOTE_SET: {
                    CLIDataLinkAction cLIDataLinkAction = new CLIDataLinkAction(this.crsIpAddr, (KDebug)this.mgr.db);
                    if (!cLIDataLinkAction.delete(this.undoData.plimType, new PlimPortId(this.values.remote_crsPort).toString(), true)) break;
                    this.showCliError((CLIAction)cLIDataLinkAction);
                    return false;
                }
            }
        }
        catch (LmpException lmpException) {
            ErrorMsg.displayError((Component)((Object)this.mgr.pane), (EID)lmpException.getEid());
            return false;
        }
        return true;
    }

    private class UndoData {
        UndoState state;
        int dataLinkId;
        PlimPortId.PlimType plimType;

        private UndoData() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum UndoState {
        NO_CHANGE,
        REMOTE_SET,
        LOCAL_TEL_SET,
        LOCAL_DL_SET;

    }
}

