/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf.lmp.crs;

import cerent.cms.idl.Lmp.sDataLinkAttrsEx;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IpAddrFactory;
import cerent.cms.model.LmpException;
import cerent.cms.model.LmpTeLinkModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.OpticsChannelModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.Wavelength;
import cerent.cms.ui.shelf.lmp.crs.CrsDataLinkManager;
import cerent.cms.ui.shelf.lmp.crs.DlCommand;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.InetUtil;
import cerent.util.KDebug;
import cerent.util.tty.CLIAction;
import cerent.util.tty.CLIDataLinkAction;
import cerent.util.tty.CLIShowArpAction;
import com.cisco.crs.model.PlimPortId;
import com.cisco.crs.model.core.LmpIdStore;
import java.awt.Component;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DlDeleteCmd
extends DlCommand {
    private boolean setLocal;
    private boolean setRemote;
    private sDataLinkAttrsEx attrs;
    private int dlId;
    private String crsIpAddr;
    private UndoData undoData = new UndoData();

    DlDeleteCmd(CrsDataLinkManager crsDataLinkManager, int n, sDataLinkAttrsEx sDataLinkAttrsEx2, boolean bl, boolean bl2) {
        super(crsDataLinkManager);
        this.dlId = n;
        this.attrs = sDataLinkAttrsEx2;
        this.setLocal = bl;
        this.setRemote = bl2;
    }

    @Override
    public HashMap<DlCommand.Key, Object> execute(HashMap<DlCommand.Key, Object> hashMap) {
        this._ok = true;
        this.undoData.deleted_remote = false;
        this.undoData.deleted_local = false;
        this.undoData.set_te_link = false;
        try {
            LmpTeLinkModel lmpTeLinkModel = this.mgr.node.getLmpTeLinkModels().getTeLink(this.attrs.te_link_id);
            this.crsIpAddr = InetUtil.makeDottedString(IpAddrFactory.getIIpAddr(lmpTeLinkModel.getRemoteNodeId()));
            if (this.setRemote && hashMap.containsKey((Object)DlCommand.Key.DEL_PLIM_TYPE)) {
                this.undoData.plimType = (PlimPortId.PlimType)hashMap.get((Object)DlCommand.Key.DEL_PLIM_TYPE);
                CLIDataLinkAction cLIDataLinkAction = new CLIDataLinkAction(this.crsIpAddr, (KDebug)this.mgr.db);
                if (cLIDataLinkAction.delete(this.undoData.plimType, new PlimPortId(this.attrs.remote_crsPort).toString(), true)) {
                    this.showCliError((CLIAction)cLIDataLinkAction);
                    this._ok = false;
                    return hashMap;
                }
                this.undoData.deleted_remote = true;
            }
            if (this.setLocal) {
                this.mgr.node.getLmpDataLinkModels().deleteDataLink(this.dlId);
                LmpIdStore.getInstance().removeId(this.crsIpAddr, this.attrs.remote_crsPort);
                this.undoData.deleted_local = true;
                if (this.setRemote) {
                    this.undoData.remoteTeLinkId = lmpTeLinkModel.getRemoteTeLinkId();
                    this.setRemoteId(lmpTeLinkModel, this.mgr.teModels.getTempIdForCrsTe());
                    this.undoData.set_te_link = true;
                }
            }
        }
        catch (LmpException lmpException) {
            ErrorMsg.displayError((Component)((Object)this.mgr.pane), (EID)lmpException.getEid());
            this._ok = false;
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            ErrorMsg.displayError((Component)((Object)this.mgr.pane), (EID)EMC.EID_NO_SUCH_INTERFACE_PARAM_1, (Object)("CRS port: " + Integer.toString(this.attrs.remote_crsPort)));
            this._ok = false;
        }
        return hashMap;
    }

    @Override
    public boolean undo() {
        IPortModel iPortModel;
        LmpTeLinkModel lmpTeLinkModel;
        String string;
        int n;
        block18: {
            n = 0;
            string = null;
            lmpTeLinkModel = null;
            try {
                if (this.undoData.deleted_remote) {
                    iPortModel = (IPortModel)this.mgr.node.getEntityTableModel().getEntityModelByIndex(this.attrs.tIndex);
                    OpticsChannelModel opticsChannelModel = (OpticsChannelModel)iPortModel.getInterfaceModel();
                    n = Wavelength.getCrsLambdaIdFromLambda(opticsChannelModel.getActualWaveLength());
                    CLIShowArpAction cLIShowArpAction = new CLIShowArpAction(this.crsIpAddr, (KDebug)this.mgr.db);
                    List list = cLIShowArpAction.get();
                    if (list == null) {
                        this.showCliError((CLIAction)cLIShowArpAction);
                        return false;
                    }
                    for (CLIShowArpAction.ArpInfo arpInfo : list) {
                        if (!arpInfo.getIp().equals(this.crsIpAddr)) continue;
                        string = arpInfo.getMgmtInterface();
                        break;
                    }
                    if (string == null) {
                        if (this.mgr.db.on()) {
                            this.mgr.db.println("Could not find the CRS IP in the ARP table");
                        }
                        return false;
                    }
                }
                if (!this.undoData.set_te_link) break block18;
                try {
                    lmpTeLinkModel = this.mgr.teModels.getTeLink(this.attrs.te_link_id);
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    ErrorMsg.displayError((Component)((Object)this.mgr.pane), (EID)EMC.LMP_INVALID_TE_LINK_INDEX);
                    return false;
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                ErrorMsg.displayError((Component)((Object)this.mgr.pane), (EID)EMC.EID_NO_SUCH_INTERFACE_PARAM_1, (Object)this.attrs.tIndex);
                return false;
            }
            catch (NoSuchInterface noSuchInterface) {
                ErrorMsg.displayError((Component)((Object)this.mgr.pane), (EID)EMC.EID_NO_SUCH_INTERFACE_PARAM_1, (Object)this.attrs.tIndex);
                return false;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                ErrorMsg.displayError((Component)((Object)this.mgr.pane), (EID)EMC.EID_WRONG_INTERFACE_TYPE_PARAM_1, (Object)"LMP Delete Data Link");
                return false;
            }
        }
        try {
            if (this.undoData.set_te_link) {
                this.setRemoteId(lmpTeLinkModel, this.undoData.remoteTeLinkId);
            }
            if (this.undoData.deleted_local) {
                this.mgr.node.getLmpDataLinkModels().createDataLink(this.attrs);
            }
            if (this.undoData.deleted_remote && (iPortModel = new CLIDataLinkAction(this.crsIpAddr, (KDebug)this.mgr.db)).create(this.undoData.plimType, new PlimPortId(this.attrs.remote_crsPort).toString(), this.mgr.node.getActualHostName(), string, this.attrs.te_link_id, this.attrs.tIndex, n, true)) {
                this.showCliError((CLIAction)iPortModel);
                return false;
            }
        }
        catch (NoSuchInterface noSuchInterface) {
            ErrorMsg.displayError((Component)((Object)this.mgr.pane), (EID)EMC.EID_NO_SUCH_INTERFACE_PARAM_1, (Object)this.attrs.tIndex);
            return false;
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            ErrorMsg.displayError((Component)((Object)this.mgr.pane), (EID)EMC.EID_WRONG_INTERFACE_TYPE_PARAM_1, (Object)"LMP Delete Data Link");
            return false;
        }
        catch (LmpException lmpException) {
            ErrorMsg.displayError((Component)((Object)this.mgr.pane), (EID)lmpException.getEid());
            return false;
        }
        return true;
    }

    private class UndoData {
        boolean deleted_remote;
        boolean deleted_local;
        boolean set_te_link;
        int remoteTeLinkId;
        PlimPortId.PlimType plimType;

        private UndoData() {
        }
    }
}

