/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf.lmp.crs;

import cerent.cms.idl.Lmp.sDataLinkAttrsEx;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.LmpDataLinkModel;
import cerent.cms.model.LmpException;
import cerent.cms.model.LmpTeLinkModel;
import cerent.cms.ui.shelf.lmp.crs.CrsDataLinkManager;
import cerent.cms.ui.shelf.lmp.crs.DlCommand;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import com.cisco.crs.model.core.LmpIdStore;
import java.awt.Component;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DlEditCmd
extends DlCommand {
    private LmpDataLinkModel dlModel;
    private sDataLinkAttrsEx newAttrs;
    private String crsIp;
    private LmpTeLinkModel oldTelModel;
    private LmpTeLinkModel newTelModel;
    private UndoData undoData = new UndoData();

    DlEditCmd(CrsDataLinkManager crsDataLinkManager, LmpDataLinkModel lmpDataLinkModel, sDataLinkAttrsEx sDataLinkAttrsEx2, String string) {
        super(crsDataLinkManager);
        this.dlModel = lmpDataLinkModel;
        this.newAttrs = sDataLinkAttrsEx2;
        this.crsIp = string;
    }

    @Override
    public HashMap<DlCommand.Key, Object> execute(HashMap<DlCommand.Key, Object> hashMap) {
        int n;
        this._ok = true;
        this.newAttrs.remote_id = n = ((Integer)hashMap.get((Object)DlCommand.Key.LMP_REMOTE_ID)).intValue();
        this.undoData.state = UndoState.NO_CHANGE;
        try {
            this.oldTelModel = this.mgr.teModels.getTeLink(this.dlModel.getLocalTeLinkId());
            this.newTelModel = this.dlModel.getLocalTeLinkId() != this.newAttrs.te_link_id ? this.mgr.teModels.getTeLink(this.newAttrs.te_link_id) : this.oldTelModel;
            this.undoData.oldTe_remoteTeLinkId = this.oldTelModel.getRemoteTeLinkId();
            this.undoData.newTe_remoteTeLinkId = this.newTelModel.getRemoteTeLinkId();
            this.undoData.remoteCrsPortId = this.dlModel.getRemoteCrsPortId();
            LmpIdStore.getInstance().removeId(this.crsIp, this.undoData.remoteCrsPortId);
            if (this.oldTelModel != this.newTelModel) {
                this.setRemoteId(this.oldTelModel, this.mgr.teModels.getTempIdForCrsTe());
            }
            this.undoData.state = UndoState.TEL_SET;
            this.setRemoteId(this.newTelModel, n);
            this.undoData.state = UndoState.REMOTE_ID_SET;
            this.dlModel.set(this.newAttrs);
            LmpIdStore.getInstance().addId(this.crsIp, this.newAttrs.remote_crsPort, n);
        }
        catch (LmpException lmpException) {
            ErrorMsg.displayError((Component)((Object)this.mgr.pane), (EID)lmpException.getEid());
            this._ok = false;
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            ErrorMsg.displayError((Component)((Object)this.mgr.pane), (EID)EMC.LMP_INVALID_TE_LINK_INDEX);
        }
        return hashMap;
    }

    @Override
    public boolean undo() {
        try {
            switch (this.undoData.state) {
                case REMOTE_ID_SET: {
                    this.setRemoteId(this.newTelModel, this.undoData.newTe_remoteTeLinkId);
                }
                case TEL_SET: {
                    LmpIdStore.getInstance().addId(this.crsIp, this.undoData.remoteCrsPortId, this.undoData.oldTe_remoteTeLinkId);
                    if (this.oldTelModel == this.newTelModel) break;
                    this.setRemoteId(this.oldTelModel, this.undoData.oldTe_remoteTeLinkId);
                }
            }
        }
        catch (LmpException lmpException) {
            ErrorMsg.displayError((Component)((Object)this.mgr.pane), (EID)lmpException.getEid());
            return false;
        }
        return true;
    }

    private class UndoData {
        UndoState state;
        int oldTe_remoteTeLinkId;
        int newTe_remoteTeLinkId;
        int remoteCrsPortId;

        private UndoData() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum UndoState {
        NO_CHANGE,
        TEL_SET,
        REMOTE_ID_SET;

    }
}

