/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf.sdh;

import cerent.cms.idl.Synchronization.eBits;
import cerent.cms.idl.Synchronization.eBitsFacility;
import cerent.cms.model.SynchronizationModel;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractBitsProvPane;
import cerent.cms.ui.shelf.AbstractSppTimingBitsPane;
import cerent.cms.ui.shelf.sdh.SdhBitsProvPane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SdhSppTimingBitsPane
extends AbstractSppTimingBitsPane {
    private static final int BITS_E1 = 0;
    private static final int BITS_2MHZ = 1;
    private static final int BITS_64K = 2;
    private static final int BITS_DS1 = 3;
    protected static final String DS1 = "DS1";
    protected static final String MHz_64 = "64kHz+8kHz";
    protected static final String MHz_6 = "6MHz";
    protected static final String E1 = "E1";

    public SdhSppTimingBitsPane(String string, TabbedView tabbedView, SynchronizationModel synchronizationModel) {
        super(string, tabbedView, synchronizationModel);
    }

    public AbstractBitsProvPane getBitsProvPane(String string, TabbedView tabbedView, AbstractSppTimingBitsPane abstractSppTimingBitsPane, eBits eBits2) {
        return new SdhBitsProvPane(string, tabbedView, abstractSppTimingBitsPane, eBits2, this.syncModel);
    }

    public JPanel createBitsInTimingBox() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder("BITS In"));
        this.facilityIn = new JComboBox<String>(this.bits1.getBitsChoices(0));
        this.facilityIn.addActionListener(this);
        jPanel.add((Component)this.createFacilityType(this.facilityIn), "North");
        if (this.facilityIn.getItemCount() == 1) {
            this.facilityIn.setEnabled(false);
        } else {
            this.enableComponent(this.facilityIn);
        }
        JPanel jPanel2 = new JPanel(null);
        jPanel2.setLayout(new GridLayout(0, 3, 5, 5));
        jPanel2.setBorder(BorderFactory.createTitledBorder(""));
        jPanel2.add(new JLabel(""));
        jPanel2.add(new JLabel("BITS-1"));
        jPanel2.add(new JLabel("BITS-2"));
        jPanel2.add(new JLabel("BITS State: "));
        jPanel2.add(this.bits1.createBitsInState());
        jPanel2.add(this.bits2.createBitsInState());
        jPanel2.add(new JLabel("Coding: "));
        jPanel2.add(this.bits1.createBitsInCoding());
        jPanel2.add(this.bits2.createBitsInCoding());
        jPanel2.add(new JLabel("Framing: "));
        jPanel2.add(this.bits1.createBitsInFraming());
        jPanel2.add(this.bits2.createBitsInFraming());
        jPanel2.add(new JLabel("Sync. Messaging: "));
        jPanel2.add(this.bits1.createBitsInSsmToggle());
        jPanel2.add(this.bits2.createBitsInSsmToggle());
        jPanel2.add(new JLabel("Admin. SSM: "));
        jPanel2.add(this.bits1.createBitsInAdminSsm());
        jPanel2.add(this.bits2.createBitsInAdminSsm());
        jPanel2.add(new JLabel("Sa Bit: "));
        jPanel2.add(((SdhBitsProvPane)this.bits1).createBitsInSabit());
        jPanel2.add(((SdhBitsProvPane)this.bits2).createBitsInSabit());
        if (this.pci.supportsE1ImpedenceSetting()) {
            jPanel2.add(new JLabel("Cable Type: "));
            jPanel2.add(((SdhBitsProvPane)this.bits1).createBitsInCableType());
            jPanel2.add(((SdhBitsProvPane)this.bits2).createBitsInCableType());
        }
        jPanel.add(jPanel2);
        return jPanel;
    }

    public JPanel createBitsOutTimingBox() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder("BITS Out"));
        this.facilityOut = new JComboBox<String>(this.bits1.getBitsChoices(1));
        this.facilityOut.addActionListener(this);
        jPanel.add((Component)this.createFacilityType(this.facilityOut), "North");
        this.facilityOut.setEnabled(false);
        JPanel jPanel2 = new JPanel(null);
        jPanel2.setLayout(new GridLayout(0, 3, 5, 5));
        jPanel2.setBorder(BorderFactory.createTitledBorder(""));
        jPanel2.add(new JLabel(""));
        jPanel2.add(new JLabel("BITS-1"));
        jPanel2.add(new JLabel("BITS-2"));
        if (this.pci.isBitsOutStateProvisionable()) {
            jPanel2.add(new JLabel("BITS State: "));
            jPanel2.add(this.bits1.createBitsOutState());
            jPanel2.add(this.bits2.createBitsOutState());
        }
        jPanel2.add(new JLabel("Coding: "));
        jPanel2.add(this.bits1.createBitsOutCoding());
        jPanel2.add(this.bits2.createBitsOutCoding());
        jPanel2.add(new JLabel("Framing: "));
        jPanel2.add(this.bits1.createBitsOutFraming());
        jPanel2.add(this.bits2.createBitsOutFraming());
        if (this.pci.isAISThresholdProvisionable()) {
            jPanel2.add(new JLabel("AIS Threshold: "));
            jPanel2.add(this.bits1.createBitsOutAisTh());
            jPanel2.add(this.bits2.createBitsOutAisTh());
        }
        jPanel2.add(new JLabel("Sa Bit: "));
        jPanel2.add(((SdhBitsProvPane)this.bits1).createBitsOutSabit());
        jPanel2.add(((SdhBitsProvPane)this.bits2).createBitsOutSabit());
        if (this.pci.supportsE1ImpedenceSetting()) {
            jPanel2.add(new JLabel("Cable Type: "));
            jPanel2.add(((SdhBitsProvPane)this.bits1).createBitsOutCableType());
            jPanel2.add(((SdhBitsProvPane)this.bits2).createBitsOutCableType());
        }
        jPanel.add(jPanel2);
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.facilityIn) {
            if (this.isBits64K(0) && !this.supports64KTiming() && !this.isBitsT1(0)) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_CONTROLLER_CARD);
                return;
            }
            this.bits1.updateBitsInValues();
            this.bits2.updateBitsInValues();
            if (!this.selectNABitsOutForT1()) {
                this.facilityOut.removeItem("N/A");
                this.facilityOut.setSelectedIndex(this.facilityIn.getSelectedIndex());
            }
            this.bits1.updateBitsOutValues();
            this.bits2.updateBitsOutValues();
        } else if (object == this.facilityOut) {
            if (this.isBits64K(1) && !this.supports64KTiming()) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_CONTROLLER_CARD);
                return;
            }
            this.bits1.updateBitsOutValues();
            this.bits2.updateBitsOutValues();
        }
        this.setDirty();
    }

    protected void refreshBitsFacilities() throws Exception {
        super.refreshBitsFacilities();
        if (this.isLineMode()) {
            this.facilityIn.setEnabled(false);
            this.enableComponent(this.facilityOut);
        } else {
            this.enableComponent(this.facilityIn);
            this.facilityOut.setEnabled(false);
        }
    }

    public eBitsFacility getFacilityTypeSelection(int n) {
        switch (n) {
            case 0: {
                return eBitsFacility.BITS_E1;
            }
            case 1: {
                return eBitsFacility.BITS_2MHZ;
            }
            case 3: {
                return eBitsFacility.BITS_T1;
            }
        }
        if (!this.supports64KTiming()) {
            return eBitsFacility.BITS_T1;
        }
        return eBitsFacility.BITS_64K;
    }

    public int getFacilityTypeIndex(eBitsFacility eBitsFacility2) {
        switch (eBitsFacility2.value()) {
            case 1: {
                return 0;
            }
            case 3: {
                return 1;
            }
            case 0: {
                if (!this.supports64KTiming()) {
                    return 2;
                }
                return 3;
            }
        }
        return 2;
    }

    public boolean isBits64K(int n) {
        if (n == 0 && ((String)this.facilityIn.getSelectedItem()).equals(MHz_64)) {
            return true;
        }
        if (n == 1) {
            if (this.pci.is600()) {
                return ((String)this.facilityOut.getSelectedItem()).equals(MHz_64);
            }
            return ((String)this.facilityOut.getSelectedItem()).equals(MHz_6);
        }
        return false;
    }

    public boolean isBits2M(int n) {
        return n == 0 && this.getBitsInFacilityType() == 1 || n == 1 && this.getBitsOutFacilityType() == 1;
    }

    public boolean isBitsE1(int n) {
        return n == 0 && ((String)this.facilityIn.getSelectedItem()).equals(E1) || n == 1 && ((String)this.facilityOut.getSelectedItem()).equals(E1);
    }

    public void destroy() {
        super.destroy();
    }

    public boolean isBitsT1(int n) {
        return n == 0 && ((String)this.facilityIn.getSelectedItem()).equals(DS1);
    }

    public boolean selectNABitsOutForT1() {
        boolean bl = false;
        if (this.isBitsT1(0)) {
            String[] stringArray;
            int n = this.facilityOut.getItemCount();
            if (n == (stringArray = this.bits1.getBitsChoices(1)).length) {
                this.facilityOut.addItem("N/A");
            }
            this.facilityOut.setSelectedItem("N/A");
            this.facilityOut.setEnabled(false);
            bl = true;
        }
        return bl;
    }
}

