/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf.snmp;

import cerent.cms.idl.Node.sSnmpV3Access;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.SnmpModel;
import cerent.cms.ui.AbstractRoDataSourceControl;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractShelfEditTablePane;
import cerent.cms.ui.shelf.snmp.AccessCreateDialog;
import cerent.cms.ui.shelf.snmp.SnmpV3Util;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.IObservableManager;
import cerent.util.ObservableManager;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.WindowHelper;
import cerent.util.gui.row.AbstractRowDataSource;
import cerent.util.gui.row.ColumnRenderer;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.SortableRowTableModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;

public class AccessPane
extends AbstractShelfEditTablePane {
    public static final int GROUP_NAME_IDX = 0;
    public static final int SECURITY_LAVEL_IDX = 1;
    public static final int READ_VIEW_IDX = 2;
    public static final int WRITE_VIEW_IDX = 3;
    public static final int NOTIFY_VIEW_IDX = 4;
    SnmpModel snmpModel = this.getSnmpModel();

    public AccessPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
    }

    protected void localInit() {
        super.localInit();
        ListSelectionModel listSelectionModel = this.getTable().getSelectionModel();
        listSelectionModel.setSelectionMode(2);
    }

    protected void initModels() {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[]{new GroupNameColumnRenderer(), new SecurityLevelColumnRenderer(), new ReadViewColumnRenderer(), new WriteViewColumnRenderer(), new NotifyViewColumnRenderer()};
        UserTableRowSource userTableRowSource = new UserTableRowSource();
        this.model = new SortableRowTableModel((RowDataSource)userTableRowSource, columnRendererArray);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        super.actionPerformed(actionEvent);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        super.valueChanged(listSelectionEvent);
        if (this.getTable().getSelectedRowCount() > 1) {
            WindowHelper.setEnabled((JComponent)this.editButton, (boolean)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateTableData() {
        List list = this.tableData;
        synchronized (list) {
            this.tableData = new ArrayList();
            try {
                sSnmpV3Access[] sSnmpV3AccessArray = this.snmpModel.getSnmpV3Access();
                for (int i = 0; i < sSnmpV3AccessArray.length; ++i) {
                    this.tableData.add(sSnmpV3AccessArray[i]);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                db.println("Error in getting SnmpV3 Access Table: " + exception);
            }
        }
    }

    public SnmpModel getSnmpModel() {
        return (SnmpModel)this.getUiModel().getNodeModel().getSnmpModel();
    }

    public void destroy() {
        if (this.table != null) {
            this.table.removeMouseListener(this);
        }
        super.destroy();
    }

    protected void createTableEntry() {
        AccessCreateDialog accessCreateDialog = AccessCreateDialog.instance(this, this.getSnmpModel());
        accessCreateDialog.show();
        accessCreateDialog.dispose();
    }

    protected void editSelectedTableEntry(int n) {
        sSnmpV3Access sSnmpV3Access2 = (sSnmpV3Access)this.model.getValueAt(n, 0);
        AccessCreateDialog accessCreateDialog = AccessCreateDialog.instance(this, this.getSnmpModel());
        if (sSnmpV3Access2 != null) {
            accessCreateDialog.setSelectedTrap(sSnmpV3Access2);
        }
        accessCreateDialog.show();
        accessCreateDialog.dispose();
    }

    public void addTableEntry(sSnmpV3Access sSnmpV3Access2) {
        this.getSnmpModel().setSnmpV3Access(sSnmpV3Access2);
    }

    protected void deleteSelectedTableEntry(int n) {
        int n2;
        int[] nArray = this.getTable().getSelectedRows();
        if (!CerentDialog.yesNoDialog((Component)((Object)this), (String)"Do you really want to delete the selected Group Access?", (String)"Delete Group Access")) {
            return;
        }
        this.setEditDeleteEnabled(false);
        sSnmpV3Access[] sSnmpV3AccessArray = new sSnmpV3Access[nArray.length];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (nArray[n2] >= 0 && nArray[n2] < this.model.getRowCount()) {
                sSnmpV3AccessArray[n2] = (sSnmpV3Access)this.model.getValueAt(nArray[n2], 0);
                continue;
            }
            db.severe("Selected entry does not exist, index: " + nArray[n2]);
            sSnmpV3AccessArray[n2] = null;
        }
        for (n2 = 0; n2 < sSnmpV3AccessArray.length; ++n2) {
            if (sSnmpV3AccessArray[n2] == null) continue;
            try {
                this.getSnmpModel().deleteSnmpV3Access(sSnmpV3AccessArray[n2].securityLevel, sSnmpV3AccessArray[n2].groupName);
                continue;
            }
            catch (Exception exception) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_ERROR_DELETING_GROUP);
            }
        }
    }

    protected void registerWithModels() {
        if (this.snmpModel != null) {
            this.getObservableManager().addObservable((Observable)((Object)this.snmpModel));
        }
    }

    protected void setDataSourceControl() {
        this.setDataSourceControl(new InnerDsc());
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.GroupConfigurationPane;
    }

    abstract class BaseColumnRenderer
    implements ColumnRenderer {
        BaseColumnRenderer() {
        }

        public int getWidth() {
            return 130;
        }

        public boolean isResizable() {
            return true;
        }

        public int getAlignment() {
            return 2;
        }

        protected String getStringValue(sSnmpV3Access sSnmpV3Access2, int n) {
            String string = "???";
            switch (n) {
                case 0: {
                    string = sSnmpV3Access2.groupName;
                    break;
                }
                case 1: {
                    string = SnmpV3Util.getSecurityLevel(sSnmpV3Access2.securityLevel.value());
                    break;
                }
                case 2: {
                    string = sSnmpV3Access2.readView;
                    break;
                }
                case 3: {
                    string = sSnmpV3Access2.writeView;
                    break;
                }
                case 4: {
                    string = sSnmpV3Access2.notifyView;
                }
            }
            return " " + string;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            sSnmpV3Access sSnmpV3Access2 = (sSnmpV3Access)jTable.getValueAt(n, 0);
            String string = this.getStringValue(sSnmpV3Access2, n2);
            JLabel jLabel = new JLabel(string);
            jLabel.setOpaque(true);
            if (bl) {
                jLabel.setBackground(jTable.getSelectionBackground());
                jLabel.setForeground(jTable.getSelectionForeground());
            } else {
                jLabel.setBackground(jTable.getBackground());
                jLabel.setForeground(jTable.getForeground());
            }
            return jLabel;
        }

        public int compareColumn(Object object, Object object2, int n) {
            String string = this.getStringValue((sSnmpV3Access)object, n);
            String string2 = this.getStringValue((sSnmpV3Access)object2, n);
            return string.compareTo(string2);
        }
    }

    class GroupNameColumnRenderer
    extends BaseColumnRenderer {
        GroupNameColumnRenderer() {
        }

        public String getName() {
            return "Group Name";
        }
    }

    public class InnerDsc
    extends AbstractRoDataSourceControl {
        boolean initedOM = false;

        private void initObservableManager() {
            AccessPane.this.resetObservableManager();
            AccessPane.this.registerWithModels();
            AccessPane.this.setObservableManagerActive();
            this.initedOM = true;
            if (db.on()) {
                db.println("initObservabledManager() done");
            }
        }

        public void refreshFromModel() throws Exception {
            if (db.on()) {
                db.println("InnerDsc::refreshFromModel()");
            }
            if (!this.initedOM) {
                this.initObservableManager();
            } else if (db.on()) {
                db.println("did not call initObservableManager()");
            }
            AccessPane.this.repopulateTable();
        }

        public IObservableManager getObservableManager() {
            if (this.dscObservableManager == null) {
                this.dscObservableManager = new ObservableManager((Observer)((Object)AccessPane.this), true);
            }
            return this.dscObservableManager;
        }
    }

    class NotifyViewColumnRenderer
    extends BaseColumnRenderer {
        NotifyViewColumnRenderer() {
        }

        public String getName() {
            return "Notify View Access";
        }
    }

    class ReadViewColumnRenderer
    extends BaseColumnRenderer {
        ReadViewColumnRenderer() {
        }

        public String getName() {
            return "Read View Access";
        }
    }

    class SecurityLevelColumnRenderer
    extends BaseColumnRenderer {
        SecurityLevelColumnRenderer() {
        }

        public String getName() {
            return "Security Level";
        }
    }

    class UserTableRowSource
    extends AbstractRowDataSource {
        UserTableRowSource() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getObjectAtRow(int n) {
            Object var2_2 = null;
            List list = AccessPane.this.tableData;
            synchronized (list) {
                var2_2 = AccessPane.this.tableData.get(n);
            }
            return var2_2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRowCount() {
            int n = -1;
            List list = AccessPane.this.tableData;
            synchronized (list) {
                n = AccessPane.this.tableData.size();
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection getAllObjects() {
            List list = AccessPane.this.tableData;
            synchronized (list) {
                return AccessPane.this.tableData;
            }
        }

        public Class getRowObjectClass() {
            return sSnmpV3Access.class;
        }
    }

    class WriteViewColumnRenderer
    extends BaseColumnRenderer {
        WriteViewColumnRenderer() {
        }

        public String getName() {
            return "Allow SNMP Sets";
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            sSnmpV3Access sSnmpV3Access2 = (sSnmpV3Access)jTable.getValueAt(n, 0);
            JCheckBox jCheckBox = new JCheckBox();
            jCheckBox.setHorizontalAlignment(0);
            if (sSnmpV3Access2.writeView.equalsIgnoreCase("def_v3setview")) {
                jCheckBox.setSelected(true);
            } else {
                jCheckBox.setSelected(false);
            }
            if (bl) {
                jCheckBox.setBackground(jTable.getSelectionBackground());
                jCheckBox.setForeground(jTable.getSelectionForeground());
            } else {
                jCheckBox.setBackground(jTable.getBackground());
                jCheckBox.setForeground(jTable.getForeground());
            }
            return jCheckBox;
        }

        public int getWidth() {
            return 130;
        }
    }
}

