/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf.snmp;

import cerent.cms.idl.Node.sSnmpV3NotifyFilter;
import cerent.cms.model.Attribute;
import cerent.cms.ui.shelf.snmp.SnmpV3Util;
import cerent.util.gui.BinaryTextField;
import cerent.util.gui.OIDTextField;
import cerent.util.gui.SnmpV3RowTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class NotifyFilterCreatePane
extends JPanel {
    static final int MARGIN = 5;
    protected JTextField profileNameTF;
    protected OIDTextField oidTF;
    protected BinaryTextField maskTF;
    protected JComboBox filterTypeCB;
    private String exceptionMessage = null;

    public NotifyFilterCreatePane() {
        this.add((Component)this.createAttrsPanel(), "Center");
    }

    private JPanel createAttrsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(0, 2, 5, 5));
        jPanel2.add(this.createLabel("Filter Profile Name:", 70, 20));
        this.profileNameTF = new SnmpV3RowTextField(20);
        jPanel2.add(this.profileNameTF);
        jPanel2.add(this.createLabel("Sub Tree OID:", 70, 20));
        this.oidTF = new OIDTextField(20);
        jPanel2.add(this.oidTF);
        jPanel2.add(this.createLabel("Bit Mask:", 70, 20));
        this.maskTF = new BinaryTextField(20);
        jPanel2.add(this.maskTF);
        this.maskTF.setToolTipText("indicates which sub-identifiers of the associated subtree OID.");
        jPanel2.add(this.createLabel("View Type:", 70, 20));
        Attribute[] attributeArray = new Attribute[]{new Attribute("include", 1), new Attribute("exclude", 2)};
        this.filterTypeCB = new JComboBox<Attribute>(attributeArray);
        jPanel2.add(this.filterTypeCB);
        this.filterTypeCB.setSelectedIndex(0);
        jPanel2.setBorder(BorderFactory.createTitledBorder(""));
        jPanel.add(jPanel2);
        return jPanel;
    }

    public String getProfileName() {
        return this.profileNameTF.getText();
    }

    public String getMask() {
        return this.maskTF.getText();
    }

    public int getFilterType() {
        return ((Attribute)this.filterTypeCB.getSelectedItem()).getIntValue();
    }

    public String getTreeOID() {
        if (!this.oidTF.getText().endsWith(".")) {
            return this.oidTF.getText() + ".";
        }
        return this.oidTF.getText();
    }

    public void setSelectedItem(sSnmpV3NotifyFilter sSnmpV3NotifyFilter2) {
        this.profileNameTF.setText(sSnmpV3NotifyFilter2.profileName);
        this.profileNameTF.setEnabled(false);
        this.oidTF.setText(this.getOID(sSnmpV3NotifyFilter2.filterSubtree.oidarray, sSnmpV3NotifyFilter2.filterSubtree.oidlen));
        this.oidTF.setEnabled(false);
        this.maskTF.setText(sSnmpV3NotifyFilter2.mask);
        this.filterTypeCB.setSelectedItem(new Attribute(SnmpV3Util.getFilterTypeString(sSnmpV3NotifyFilter2.filterType.value()), sSnmpV3NotifyFilter2.filterType.value()));
    }

    public String getOID(int[] nArray, int n) {
        int n2;
        String string = "";
        for (n2 = 0; n2 < n - 1; ++n2) {
            string = string + nArray[n2] + ".";
        }
        string = string + nArray[n2];
        return string;
    }

    private JLabel createLabel(String string, int n, int n2) {
        JLabel jLabel = new JLabel(string);
        jLabel.setPreferredSize(new Dimension(n, n2));
        return jLabel;
    }
}

