/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf.snmp;

import cerent.cms.idl.Node.sSnmpTrapDestination;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.model.AlreadyInUse;
import cerent.cms.model.ConfigError;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.InvalidData;
import cerent.cms.model.MaxSnmpDestinations;
import cerent.cms.model.SnmpModel;
import cerent.cms.ui.shelf.snmp.SnmpAttrsPane;
import cerent.cms.ui.shelf.snmp.SnmpTrapPane;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.awt.Component;
import java.util.Arrays;

public class SnmpCreatePane
extends SnmpAttrsPane {
    private static final SDebug snmpCreateDb = new SDebug((KDebug)SnmpTrapPane.db, "SnmpCreatePane");

    public SnmpCreatePane(SnmpTrapPane snmpTrapPane) {
        super(snmpCreateDb, "CreatePane", snmpTrapPane);
        this.setComponentsEnabled(true);
    }

    public boolean hasSubTabs() {
        return true;
    }

    public void apply() throws InvalidData, AlreadyInUse, MaxSnmpDestinations, ConfigError {
        this.validateFields();
        this.applyChangesToModel();
    }

    public void applyChangesToModel() throws AlreadyInUse, MaxSnmpDestinations, ConfigError {
        SnmpModel snmpModel = this.parent.getSnmpModel();
        if (snmpModel != null) {
            for (Object object : snmpModel.getSnmpTrapDestinations()) {
                if (!Arrays.equals(this.ipAddr.addr, object.ipAddress.addr)) continue;
                throw new AlreadyInUse("IP address must not match another trap receiver's IP address");
            }
            try {
                snmpModel.setSnmpTrapDestination(new sSnmpTrapDestination(this.ipAddr, this.commName, (short)this.udpPort, this.version, this.trapRate, this.relayIpAddr, this.relayCommName));
            }
            catch (xProvisionError xProvisionError2) {
                Object object;
                object = new EMCProvisionError(xProvisionError2, this.parent.getNMD().getPlatform());
                ErrorMsg.displayError((Component)this, (EID)object.getEID());
            }
        }
    }

    protected boolean hasProxyPanel() {
        return this.parent.getNMD().getPlatform().isSnmpProxyCapable() && this.parent.getSnmpModel().allowSnmpProxy() && this.parent.canCreateRelays();
    }
}

