/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf.snmp;

import cerent.cms.model.AlreadyInUse;
import cerent.cms.model.ConfigError;
import cerent.cms.model.InvalidData;
import cerent.cms.model.MaxSnmpDestinations;
import cerent.cms.ui.shelf.snmp.SnmpCreatePane;
import cerent.cms.ui.shelf.snmp.SnmpTrapPane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.gui.UDialog;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class SnmpCreationDialog
extends UDialog
implements ActionListener {
    public static final String TITLE = "Create SNMP Trap Destination";
    private JButton okButton;
    private JButton cancelButton;
    private SnmpCreatePane createPane;

    public static SnmpCreationDialog instance(SnmpTrapPane snmpTrapPane) {
        Frame frame = JOptionPane.getFrameForComponent((Component)((Object)snmpTrapPane));
        return new SnmpCreationDialog(frame, snmpTrapPane);
    }

    private SnmpCreationDialog(Frame frame, Object object) {
        super(frame, TITLE, true, (Object)((SnmpTrapPane)object));
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        SnmpTrapPane snmpTrapPane = (SnmpTrapPane)object;
        jPanel.add((Component)this.getCreatePanel(snmpTrapPane), "Center");
        jPanel.add((Component)this.getButtonPanel(), "South");
    }

    public void dispose() {
        if (this.createPane != null) {
            this.createPane.destroy();
            this.createPane = null;
        }
        super.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            try {
                this.apply();
                this.dispose();
            }
            catch (AlreadyInUse alreadyInUse) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_SNMP_DESTINATION_ALREADY_IN_USE);
            }
            catch (InvalidData invalidData) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_SNMP_DESTINATION_PARAM_1, (Object)invalidData.getMessage());
            }
            catch (MaxSnmpDestinations maxSnmpDestinations) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_SNMP_MAX_DESTINATIONS);
            }
            catch (Exception exception) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FAIL_TRAP_DEST_CREATE);
            }
        } else if (object == this.cancelButton) {
            this.dispose();
        } else {
            throw new IllegalArgumentException("actionPerformed: unexpected source " + object);
        }
    }

    protected void apply() throws Exception, MaxSnmpDestinations, ConfigError {
        this.createPane.apply();
    }

    private JPanel getCreatePanel(SnmpTrapPane snmpTrapPane) {
        this.createPane = new SnmpCreatePane(snmpTrapPane);
        return this.createPane;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton("OK");
        jPanel.add(this.okButton);
        this.cancelButton = this.makeActionButton("Cancel");
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }
}

