/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf.snmp;

import cerent.cms.idl.Node.sSnmpV3Engine;
import cerent.cms.model.CmsCommFailException;
import cerent.cms.model.SnmpModel;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.ObserverPane;
import cerent.cms.ui.TabbedView;
import cerent.util.SDebug;
import cerent.util.SnmpUtil;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SnmpV3GeneralPane
extends ObserverPane {
    private JTextField engineIdTF;
    private boolean hasProvPrivilege = false;
    private boolean isSecure = false;

    public SnmpV3GeneralPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.SnmpGeneralPane;
    }

    private void init() {
        db.info("init: start");
        this.setLayout(new BorderLayout());
        JPanel jPanel = this.createGeneralPanel();
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 5, 5));
        jPanel2.add(jPanel);
        this.add(jPanel2, "North");
        this.add(Box.createVerticalGlue(), "Center");
        JPanel jPanel3 = new JPanel(new FlowLayout(2, 5, 5));
        jPanel3.add(new CSHelpButton(CSHelpConst.SnmpV3GeneralPane));
        this.add(jPanel3, "South");
        this.refresh();
        db.info("init: finish");
    }

    private JPanel createGeneralPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0, 5, 5));
        jPanel.setBorder(BorderFactory.createTitledBorder("General"));
        this.engineIdTF = this.addTextPanel(jPanel, "Node Engine ID:", 20, this.isUserAuthorized());
        jPanel.add(Box.createHorizontalStrut(45));
        return jPanel;
    }

    private JLabel createLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setPreferredSize(new Dimension(100, 20));
        return jLabel;
    }

    private JTextField addTextPanel(JPanel jPanel, String string, int n, boolean bl) {
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
        if (string != null) {
            jPanel.add(this.createLabel(string));
        }
        JTextField jTextField = new JTextField(n);
        jTextField.setPreferredSize(new Dimension(n, 20));
        jTextField.setMaximumSize(new Dimension(n, 20));
        jTextField.setMinimumSize(new Dimension(n, 20));
        jPanel.add(jTextField);
        jTextField.setEditable(false);
        return jTextField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enteringPage() throws Exception {
        try {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(3);
            }
            if (this.engineIdTF == null) {
                this.init();
            }
            super.enteringPage();
        }
        finally {
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(0);
            }
        }
    }

    public void leavingPage() throws Exception {
        super.leavingPage();
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void refresh() {
        db.info("refresh: start");
        try {
            SnmpModel snmpModel = (SnmpModel)this.getUiModel().getNodeModel().getSnmpModel();
            if (snmpModel == null) {
                db.severe("Snmp Model is null in SnmpGeneralPane::refresh()");
                return;
            }
            sSnmpV3Engine sSnmpV3Engine2 = snmpModel.getSnmpV3Engine();
            String string = SnmpUtil.toStringEngineID(sSnmpV3Engine2.engineid, sSnmpV3Engine2.engineidlen);
            this.engineIdTF.setText(string);
        }
        catch (CmsCommFailException cmsCommFailException) {
            db.info("refresh: commfail exception");
            SDebug.printStackTrace((Throwable)((Object)cmsCommFailException));
        }
        db.info("refresh: finish");
    }
}

