/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf.snmp;

import cerent.cms.idl.Node.SnmpV3SecurityLevel;
import cerent.cms.model.InvalidData;
import cerent.cms.model.IpAddrFactory;
import cerent.cms.model.SnmpModel;
import cerent.cms.model.SnmpV3TrapDestination;
import cerent.cms.ui.Pane;
import cerent.cms.ui.shelf.snmp.SnmpV3TargetCreatePane;
import cerent.cms.ui.shelf.snmp.SnmpV3TargetPane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.InetUtil;
import cerent.util.SDebug;
import cerent.util.SnmpUtil;
import cerent.util.gui.UDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class SnmpV3TargetCreateDialog
extends UDialog
implements ActionListener {
    protected SnmpV3TargetCreatePane panel;
    protected JButton okButton;
    protected JButton cancelButton;
    protected SnmpModel snmpModel;
    protected boolean createFlag = true;
    Pane parent = null;
    private static final String TITLE_CREATE = "Configure SnmpV3 Trap";
    private static final String TITLE_EDIT = "Configure SnmpV3 Trap";
    private SnmpV3TrapDestination snmpV3Target = null;
    protected static final SDebug db = new SDebug("SnmpV3TargetCreateDialog");

    public static SnmpV3TargetCreateDialog instance(Pane pane, Object object) {
        Frame frame = JOptionPane.getFrameForComponent((Component)pane);
        return new SnmpV3TargetCreateDialog(pane, frame, "Configure SnmpV3 Trap", object);
    }

    protected SnmpV3TargetCreateDialog(Pane pane, Frame frame, String string, Object object) {
        super(frame, string, true, object);
        this.parent = pane;
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        this.snmpModel = (SnmpModel)object;
        this.panel = new SnmpV3TargetCreatePane(this);
        jPanel.add((Component)this.panel, "Center");
        jPanel.add((Component)this.getButtonPanel(), "South");
        this.setSize(new Dimension(600, 600));
    }

    protected JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton("OK");
        jPanel2.add(this.okButton);
        this.cancelButton = this.makeActionButton("Cancel");
        jPanel2.add(this.cancelButton);
        jPanel.add(jPanel2);
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (db.on()) {
            db.fine("actionPerformed from " + object);
        }
        if (object == this.okButton) {
            try {
                if (this.apply()) {
                    this.ok();
                    this.dispose();
                }
            }
            catch (InvalidData invalidData) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_SNMP_DESTINATION_PARAM_1, (Object)invalidData.getMessage());
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_ERROR_CREATING_SNMP_TARGET);
            }
        } else if (object == this.cancelButton) {
            this.dispose();
        }
    }

    protected boolean apply() throws Exception {
        return this.validateFields();
    }

    private boolean validateFields() throws Exception {
        boolean bl = true;
        if (((SnmpV3TargetPane)this.parent).isTargetExists(this.panel.getIpAddress(), this.panel.getSecurityName(), SnmpV3SecurityLevel.from_int(this.panel.getSecurityLevel())) && this.createFlag) {
            bl = false;
            this.createFlag = true;
            throw new InvalidData("The Snmp target already exists.");
        }
        SnmpUtil.validateUdpPort(this.panel.getUDPPort());
        boolean bl2 = ((SnmpV3TargetPane)this.parent).getUiModel().getNodeModel().getIpConfig().getNodeMode();
        if (InetUtil.isIPv6Address(IpAddrFactory.getIIpAddr(this.panel.getIpAddress())) && !bl2 && this.createFlag) {
            bl = false;
            throw new InvalidData("IPv6 Address cannot be specified for Target Address when IPv6 mode is not enabled on the node.");
        }
        return bl;
    }

    public void dispose() {
        super.dispose();
    }

    protected JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    protected void ok() throws Exception {
        if (this.snmpV3Target == null) {
            this.snmpModel.setSnmpV3TrapDestination(this.panel.getSecurityName(), SnmpV3SecurityLevel.from_int(this.panel.getSecurityLevel()), this.panel.getIpAddress(), this.panel.getUDPPort(), this.panel.getTagList(), this.panel.getFilterProfile(), this.panel.isProxyTrapsOnly());
        } else {
            this.snmpModel.setSnmpV3TrapDestination(this.panel.getSecurityName(), SnmpV3SecurityLevel.from_int(this.panel.getSecurityLevel()), this.panel.getIpAddress(), this.panel.getUDPPort(), this.panel.getTagList(), this.panel.getFilterProfile(), this.panel.isProxyTrapsOnly());
        }
    }

    protected String getRowName() {
        String string = Long.toString(System.currentTimeMillis());
        return string;
    }

    public static JPanel createVerticalPanel(String string) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        if (string != null) {
            jPanel.setBorder(BorderFactory.createTitledBorder(string));
        }
        return jPanel;
    }

    protected void setSelectedTrap(SnmpV3TrapDestination snmpV3TrapDestination) {
        this.setTitle("Configure SnmpV3 Trap");
        this.createFlag = false;
        this.snmpV3Target = snmpV3TrapDestination;
        SnmpV3TargetCreatePane snmpV3TargetCreatePane = this.panel;
        snmpV3TargetCreatePane.setSelectedItem(snmpV3TrapDestination);
    }

    public SnmpModel getSnmpModel() {
        return this.snmpModel;
    }
}

