/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.sonet;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.model.BlsrModel;
import cerent.cms.model.ElementModelsDelegate;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OcnLineUpdate;
import cerent.cms.model.TdmHoModel;
import cerent.cms.model.TdmModuleModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.GeneralPmThresholdsPane;
import cerent.cms.ui.ResettablePmThresholdsTableModel;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.sonet.CxcHoPathPmThresholdsTableModel;
import cerent.cms.ui.sonet.CxcSdhHoPathPmThresholdsTableModel;
import cerent.cms.ui.sonet.CxcSonetHoPathPmThresholdsTableModel;
import cerent.util.AnnotatedException;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

public class CxcHoPathPmThresholdsPane
extends GeneralPmThresholdsPane
implements TableModelListener {
    protected CxcHoPathPmThresholdsTableModel dataModel = null;
    protected TdmHoModel[] hoModels = null;
    protected InterfaceModel[] lineModels = null;
    protected BlsrModel[] blsrModels = null;
    protected int indexOfHo;
    protected TdmModuleModel eqpmtModel = null;
    protected eIntervalType intervalType = null;
    protected boolean nearEnd = false;
    protected Observer strucChangeObserver = null;
    protected Observer blsrChangeObserver = null;
    protected int framingTypeToDisplay = 0;
    private static final SDebug db = new SDebug("CxcHoPathPmThresholdsPane");

    public CxcHoPathPmThresholdsPane(String string, TabbedView tabbedView, InterfaceModel[] interfaceModelArray, eIntervalType eIntervalType2, boolean bl, int n, int n2) {
        super(string, tabbedView);
        TableColumn tableColumn = null;
        this.intervalType = eIntervalType2;
        this.nearEnd = bl;
        this.lineModels = interfaceModelArray;
        this.indexOfHo = n;
        this.framingTypeToDisplay = n2;
        this.hoModels = this.getHo(interfaceModelArray, n);
        this.dataModel = this.getDataModel();
        this.dataModel.addTableModelListener(this);
        this.table = new JTable(this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.add((Component)uScrollPane);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(0));
        tableColumn.setPreferredWidth(225);
        this.table.setAutoCreateColumnsFromModel(false);
        this.strucChangeObserver = new Observer(){

            public void update(Observable observable, Object object) {
                Integer n;
                if (db.on()) {
                    db.println("Got an update from linemodel");
                }
                if (object instanceof Integer && (n = (Integer)object).equals(ModelUpdateType.ADDED)) {
                    CxcHoPathPmThresholdsPane.this.initializeLines();
                }
            }
        };
        this.blsrChangeObserver = new Observer(){

            public void update(Observable observable, Object object) {
                Integer n;
                if (db.on()) {
                    db.println("Got an update from BLSR model");
                }
                if (object instanceof Integer && (n = (Integer)object).equals(ModelUpdateType.ADDED)) {
                    CxcHoPathPmThresholdsPane.this.initializeLines();
                }
            }
        };
        this.registerWithModel();
    }

    protected Collection splitByFramingType(Collection collection) {
        if (this.framingTypeToDisplay == 0) {
            return collection;
        }
        ArrayList<TdmHoModel> arrayList = new ArrayList<TdmHoModel>();
        for (Object e : collection) {
            if (!(e instanceof TdmHoModel)) continue;
            TdmHoModel tdmHoModel = (TdmHoModel)e;
            if (this.framingTypeToDisplay == 1 && tdmHoModel.isSdhAu4()) {
                arrayList.add(tdmHoModel);
                continue;
            }
            if (this.framingTypeToDisplay != 2 || !tdmHoModel.isSdhAu3()) continue;
            arrayList.add(tdmHoModel);
        }
        return arrayList;
    }

    protected TdmHoModel[] getHo(InterfaceModel[] interfaceModelArray, int n) {
        Collection collection = InterfaceModel.getHigherLayerModels(interfaceModelArray, n, this.getUiModel());
        if (collection == null) {
            if (db.on()) {
                db.println("Error in getting STS lines");
            }
            return null;
        }
        collection = this.splitByFramingType(collection);
        if (db.on()) {
            db.println("Returning STSs " + collection.size());
        }
        return collection.toArray(new TdmHoModel[0]);
    }

    protected synchronized void initializeLines() {
        this.unregisterWithModel();
        this.hoModels = this.getHo(this.lineModels, this.indexOfHo);
        this.dataModel.setStsModel(this.hoModels);
        this.registerWithModel();
    }

    protected CxcHoPathPmThresholdsTableModel getDataModel() {
        if (this.getUiModel().getNodeModel().getTdmProtocolTypeObj().isSdh()) {
            return new CxcSdhHoPathPmThresholdsTableModel(this.uiModel.getNodeModel(), this.lineModels, this.hoModels, this.intervalType, this.nearEnd, this.framingTypeToDisplay);
        }
        return new CxcSonetHoPathPmThresholdsTableModel(this.uiModel.getNodeModel(), this.lineModels, this.hoModels, this.intervalType, this.nearEnd, this.framingTypeToDisplay);
    }

    protected ResettablePmThresholdsTableModel dataModel() {
        return this.dataModel;
    }

    protected void registerWithModel() {
        int n;
        super.registerWithModel();
        for (n = 0; n < this.hoModels.length; ++n) {
            this.hoModels[n].addObserver((Observer)((Object)this));
        }
        for (n = 0; n < this.lineModels.length; ++n) {
            this.lineModels[n].addObserver(this.strucChangeObserver);
        }
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.uiModel.getNodeModel();
        ElementModelsDelegate elementModelsDelegate = nodeModelDelegate.getElementModelsDelegate();
        Set set = elementModelsDelegate.getBlsrElements();
        this.blsrModels = set.toArray(new BlsrModel[set.size()]);
        for (int i = 0; i < this.blsrModels.length; ++i) {
            this.blsrModels[i].addObserver(this.blsrChangeObserver);
            if (!db.on()) continue;
            db.println("observing with blsr #" + this.blsrModels[i]);
        }
    }

    protected void unregisterWithModel() {
        int n;
        for (n = 0; n < this.hoModels.length; ++n) {
            this.hoModels[n].deleteObserver((Observer)((Object)this));
        }
        for (n = 0; n < this.lineModels.length; ++n) {
            this.lineModels[n].deleteObserver(this.strucChangeObserver);
        }
        for (n = 0; n < this.blsrModels.length; ++n) {
            this.blsrModels[n].deleteObserver(this.blsrChangeObserver);
        }
    }

    public void dispose() {
        this.unregisterWithModel();
        super.dispose();
    }

    protected void changeMessage(Observable observable, Object object) {
        this.requestRefresh(observable, this.getRefreshThread(observable));
    }

    protected void deleteMessage(Observable observable, Object object) {
        SwingUtilities.invokeLater(this.getDeleteThread());
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            public void run() {
                CxcHoPathPmThresholdsPane.this.refreshLine(observable);
            }
        };
    }

    private Runnable getDeleteThread() {
        return new Runnable(){

            public void run() {
                CxcHoPathPmThresholdsPane.this.unregisterWithModel();
                CxcHoPathPmThresholdsPane.this.initializeLines();
            }
        };
    }

    protected void refreshMyLines(Object object) {
        if (object instanceof OcnLineUpdate) {
            this.unregisterWithModel();
            this.lineModels = (InterfaceModel[])((OcnLineUpdate)object).getModels();
            this.initializeLines();
        }
    }

    protected void refreshLine(Observable observable) {
        int n = Arrays.asList(this.hoModels).indexOf(observable);
        if (n != -1) {
            if (db.on()) {
                db.println("Refreshing Line " + n);
            }
            this.dataModel.refreshLineFromModel(n);
        } else if (db.on()) {
            db.println("In CxcHoPathPmThresholdsPane changeMessage cannot find Model " + observable);
        }
    }

    public void applyChangesToModel() throws Exception {
        int n = 0;
        try {
            if (db.on()) {
                db.println("Applying changes");
            }
            for (n = 0; n < this.hoModels.length; ++n) {
                if (db.on()) {
                    db.println("setting at iteration " + n);
                }
                if (!this.dataModel.isRowDirty(n)) continue;
                this.hoModels[n].setStsPathThresholds(this.nearEnd, this.intervalType, this.dataModel.getStatsVal(n));
            }
            this.dataModel.resetDirtyBits();
        }
        catch (Exception exception) {
            throw new AnnotatedException("An error occurred while applying changes to row " + (n + 1) + ".", exception);
        }
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        for (int i = 0; i < this.hoModels.length; ++i) {
            if (!this.dataModel.isRowDirty(i)) continue;
            this.setDirty();
            return;
        }
        this.resetDirty();
    }

    public void refreshFromModel() {
        if (db.on()) {
            db.println("refreshing ");
        }
        this.dataModel.refreshFromModel();
        this.resetDirty();
    }

    public void enteringPage() throws Exception {
        super.enteringPage();
        this.initializeLines();
    }

    public void leavingPage() throws Exception {
        if (this.table.isEditing()) {
            TableCellEditor tableCellEditor = this.table.getCellEditor();
            tableCellEditor.stopCellEditing();
            this.setDirty();
        }
        this.unregisterWithModel();
        super.leavingPage();
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.HoPathPmThresholdsPane;
    }
}

