/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.sonet;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.If.sInterface;
import cerent.cms.idl.SonetMedia.sVtThresholds;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.TdmLoModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.nedefaults.NeDefaultsModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.AbstractValidatingTableModel;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.ResettablePmThresholdsTableModel;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;

public class LoPathPmThresholdsTableModel
extends AbstractValidatingTableModel
implements ResettablePmThresholdsTableModel {
    protected TDMTerminology tdmTerm;
    protected int topologyType;
    private TdmLoModel[] model;
    protected boolean[] rowDirty;
    private sVtThresholds[] thresholdsVal;
    private sInterface[] info;
    private eIntervalType intervalType;
    private int numLines;
    private boolean nearEnd;
    private EntityCellRenderer myPortRenderer;
    private static final int LINENUMBER_INDEX = 0;
    private static final int ES_INDEX = 1;
    private static final int SES_INDEX = 2;
    private static final int CV_INDEX = 3;
    protected static final int FC_INDEX = 4;
    private static final int UAS_INDEX = 5;
    private static final int BBE_INDEX = 6;
    private static final int LAST_INDEX = 6;
    private String[] columnNames;
    private static final SDebug db = new SDebug("LoPathPmThresholdsTableModel");

    public LoPathPmThresholdsTableModel(INodeModel iNodeModel, TdmLoModel[] tdmLoModelArray, eIntervalType eIntervalType2, boolean bl) {
        super((NodeModelDelegate)iNodeModel, db);
        this.tdmTerm = iNodeModel.getTDMTerminology();
        this.topologyType = iNodeModel.getTdmProtocolType();
        this.model = tdmLoModelArray;
        this.rowDirty = null;
        this.info = null;
        this.nearEnd = bl;
        this.intervalType = eIntervalType2;
        if (this.model == null) {
            if (db.on()) {
                db.println("Model null");
            }
            this.numLines = 0;
        } else {
            this.numLines = this.model.length;
        }
        this.initColumnNames();
        this.init();
    }

    private void initColumnNames() {
        if (this.topologyType == 0) {
            this.columnNames = new String[6];
            try {
                this.columnNames[0] = "Port ";
                this.columnNames[3] = this.tdmTerm.getPmStat(1);
                this.columnNames[1] = this.tdmTerm.getPmStat(2);
                this.columnNames[2] = this.tdmTerm.getPmStat(3);
                this.columnNames[4] = this.tdmTerm.getPmStat(0);
                this.columnNames[5] = this.tdmTerm.getPmStat(9);
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        } else {
            this.columnNames = new String[7];
            try {
                this.columnNames[0] = "Port ";
                this.columnNames[3] = this.tdmTerm.getPmStat(1);
                this.columnNames[1] = this.tdmTerm.getPmStat(2);
                this.columnNames[2] = this.tdmTerm.getPmStat(3);
                this.columnNames[4] = this.tdmTerm.getPmStat(0);
                this.columnNames[5] = this.tdmTerm.getPmStat(9);
                this.columnNames[6] = this.tdmTerm.getPmStat(5);
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    protected String getLineNumber(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            this.getInfo(n);
            if (this.info[n] != null) {
                IPortModel iPortModel = this.model[n].getPortModel();
                stringBuffer.append("Port " + PortHelper.getPortNumString((IPortModel)iPortModel) + ", " + this.tdmTerm.getGeneralTerms(1) + " " + this.info[n].muxIndex);
            }
        }
        catch (Exception exception) {
            db.println("Unexpected Exception caught in LoPathPmThresholdsTableModel::getLineNumber");
            SDebug.printStackTrace((Throwable)exception);
        }
        return stringBuffer.toString();
    }

    public int getNumberOfLines() {
        return this.model.length;
    }

    public void markRowDirty(int n) {
        this.rowDirty[n] = true;
    }

    protected sInterface getInfo(int n) throws NoSuchInterface {
        if (this.info[n] == null) {
            this.info[n] = this.model[n].getInfo();
        }
        return this.info[n];
    }

    private void init() {
        this.myPortRenderer = new EntityCellRenderer(true);
        this.rowDirty = new boolean[this.numLines];
        this.thresholdsVal = new sVtThresholds[this.numLines];
        this.info = new sInterface[this.numLines];
        for (int i = 0; i < this.numLines; ++i) {
            this.rowDirty[i] = false;
            this.thresholdsVal[i] = null;
        }
    }

    public Object getThresholdNeDefault(NeDefaultsModel neDefaultsModel, int n) throws Exception {
        eEqType eEqType2 = this.model[n].getModuleModel().getEqTypeEnum();
        IPortModel iPortModel = this.model[n].getPortModel();
        eEqType eEqType3 = ((EntityModel)iPortModel).getEqTypeEnum();
        return neDefaultsModel.getDefVtThr(eEqType2, eEqType3, this.nearEnd, this.intervalType);
    }

    public void setThresholdValue(int n, Object object) {
        if (object instanceof sVtThresholds) {
            this.thresholdsVal[n] = (sVtThresholds)object;
        }
    }

    public boolean resetToDefaultByLine() {
        return false;
    }

    private void refreshPmStats(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.thresholdsVal[n] == null) {
            this.thresholdsVal[n] = this.model[n].getPmThresholds(this.nearEnd, this.intervalType);
        }
    }

    private int getEs(int n) throws NoSuchInterface, WrongInterfaceType {
        this.refreshPmStats(n);
        return this.thresholdsVal[n].es;
    }

    private int getCv(int n) throws NoSuchInterface, WrongInterfaceType {
        this.refreshPmStats(n);
        return this.thresholdsVal[n].cv;
    }

    private int getSes(int n) throws NoSuchInterface, WrongInterfaceType {
        this.refreshPmStats(n);
        return this.thresholdsVal[n].ses;
    }

    private int getFc(int n) throws NoSuchInterface, WrongInterfaceType {
        this.refreshPmStats(n);
        return this.thresholdsVal[n].fc;
    }

    private int getUas(int n) throws NoSuchInterface, WrongInterfaceType {
        this.refreshPmStats(n);
        return this.thresholdsVal[n].uas;
    }

    private int getBbe(int n) throws NoSuchInterface, WrongInterfaceType {
        this.refreshPmStats(n);
        return this.thresholdsVal[n].bbe;
    }

    public Class getColumnClass(int n) {
        if (n != 0) {
            return Integer.class;
        }
        return String.class;
    }

    public void setValueAt(Object object, int n, int n2) {
        try {
            if (db.on()) {
                db.println("Change in value " + n + " " + n2);
            }
            int n3 = -1;
            if (object instanceof Integer) {
                n3 = (Integer)object;
            } else if (object instanceof String) {
                n3 = Integer.parseInt((String)object);
            }
            if (n3 < 0) {
                db.println("Invalid Value = " + n3 + " found in " + "LoPathPmThresholdsTableModel::setValueAt()");
                SDebug.printStackTrace((Throwable)new Exception());
            } else {
                switch (n2) {
                    case 3: {
                        this.validatePmThresholds(5, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, this.tdmTerm.getPmStat(1), object.toString());
                        this.thresholdsVal[n].cv = n3;
                        break;
                    }
                    case 1: {
                        this.validatePmThresholds(5, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, this.tdmTerm.getPmStat(2), object.toString());
                        this.thresholdsVal[n].es = n3;
                        break;
                    }
                    case 2: {
                        this.validatePmThresholds(5, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, this.tdmTerm.getPmStat(3), object.toString());
                        this.thresholdsVal[n].ses = n3;
                        break;
                    }
                    case 4: {
                        this.validatePmThresholds(5, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, this.tdmTerm.getPmStat(0), object.toString());
                        this.thresholdsVal[n].fc = n3;
                        break;
                    }
                    case 5: {
                        this.validatePmThresholds(5, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, this.tdmTerm.getPmStat(9), object.toString());
                        this.thresholdsVal[n].uas = n3;
                        break;
                    }
                    case 6: {
                        this.validatePmThresholds(5, (InterfaceModel)this.model[n], this.intervalType, this.nearEnd, this.tdmTerm.getPmStat(5), object.toString());
                        this.thresholdsVal[n].bbe = n3;
                        break;
                    }
                }
                this.rowDirty[n] = true;
                this.fireTableCellUpdated(n, n2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            db.println("NumberFormatException caught in LoPathPmThresholdsTableModel::setValueAt() " + numberFormatException);
            SDebug.printStackTrace((Throwable)numberFormatException);
        }
        catch (ProvisionError provisionError) {
            SDebug.printStackTrace((Throwable)provisionError);
            this.presentProvisionError(this.getColumnName(n2), provisionError);
        }
        catch (Exception exception) {
            db.println("Unexpected Exception caught in LoPathPmThresholdsTableModel::setValueAt() " + exception);
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    public int getRowCount() {
        return this.numLines;
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public sVtThresholds getThresholdsVal(int n) {
        if (n >= this.numLines) {
            return null;
        }
        return this.thresholdsVal[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVtModel(TdmLoModel[] tdmLoModelArray) {
        LoPathPmThresholdsTableModel loPathPmThresholdsTableModel = this;
        synchronized (loPathPmThresholdsTableModel) {
            this.model = tdmLoModelArray;
            this.numLines = tdmLoModelArray == null ? 0 : this.model.length;
            this.init();
        }
        this.fireTableDataChanged();
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.model != null && this.model.length > 0) {
            try {
                if (AbstractPane.isUserAuthorized(this.model[0], SecurityLevel.PROVISIONING) && !this.model[0].getModuleModel().isProtectModule()) {
                    return n2 > 0;
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                return false;
            }
        }
        return false;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    protected String getPortDescriptionFor(int n) throws AbstractCmsNoSuchEntityException {
        IPortModel iPortModel = this.model[n].getPortModel();
        return this.myPortRenderer.getPortString((IEntityModel)iPortModel, false);
    }

    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 0: {
                    return this.getLineNumber(n);
                }
                case 3: {
                    return new Integer(this.getCv(n));
                }
                case 1: {
                    return new Integer(this.getEs(n));
                }
                case 2: {
                    return new Integer(this.getSes(n));
                }
                case 4: {
                    return new Integer(this.getFc(n));
                }
                case 5: {
                    return new Integer(this.getUas(n));
                }
                case 6: {
                    return new Integer(this.getBbe(n));
                }
            }
            return null;
        }
        catch (Exception exception) {
            db.println("Error in LoPathPmThresholdsTableModel::getValueAt");
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    public void refreshLineFromModel(int n) {
        this.thresholdsVal[n] = null;
        this.rowDirty[n] = false;
        this.fireTableRowsUpdated(n, n);
    }

    public void refreshFromModel() {
        int n;
        if (db.on()) {
            db.println("refreshing in model");
        }
        for (n = 0; n < this.numLines; ++n) {
            this.thresholdsVal[n] = null;
        }
        for (n = 0; n < this.numLines; ++n) {
            this.rowDirty[n] = false;
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public boolean isRowDirty(int n) {
        return this.rowDirty[n];
    }

    public void resetDirtyBits() {
        for (int i = 0; i < this.numLines; ++i) {
            this.rowDirty[i] = false;
        }
    }
}

