/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.sonet;

import cerent.cms.model.Attribute;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.TdmLoModel;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.sonet.TdmLoProvTableModel;
import cerent.util.AnnotatedException;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class TdmLoProvPane
extends NodeProvPane
implements TableModelListener {
    TdmLoProvTableModel dataModel = null;
    TdmLoModel[] loModels = null;
    Ds123LineModel[] lineModels;
    int indexOfLos = 0;
    int numLines = 0;
    Observer strucChangeObserver = null;
    Runnable addDeleteThread = null;
    private static final SDebug db = new SDebug("TdmLoProvPane");

    public TdmLoProvPane(String string, TabbedView tabbedView, Ds123LineModel[] ds123LineModelArray, int n) {
        super(string, tabbedView);
        TableColumn tableColumn = null;
        Attribute[] attributeArray = null;
        this.lineModels = ds123LineModelArray;
        this.loModels = this.getLOs(ds123LineModelArray, n);
        this.indexOfLos = n;
        this.numLines = this.loModels == null ? 0 : this.loModels.length;
        INodeModel iNodeModel = this.getUiModel().getNodeModel();
        this.dataModel = new TdmLoProvTableModel(iNodeModel, this.loModels);
        this.dataModel.addTableModelListener(this);
        this.table = new UTable((TableModel)this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        tableColumn = this.table.getColumn(this.dataModel.columnNames[0]);
        tableColumn.setCellEditor(new DefaultCellEditor(new JTextField()));
        tableColumn.setPreferredWidth(150);
        tableColumn = this.table.getColumn(this.dataModel.columnNames[1]);
        try {
            attributeArray = this.getAttributeArray("declareSfBerLevel");
        }
        catch (NoSuchElementException noSuchElementException) {
            attributeArray = null;
            this.table.removeColumn(tableColumn);
            if (db.on()) {
                db.println("Got exception");
            }
            SDebug.printStackTrace((Throwable)noSuchElementException);
        }
        if (attributeArray != null) {
            tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(attributeArray)));
            tableColumn.sizeWidthToFit();
        }
        tableColumn = this.table.getColumn(this.dataModel.columnNames[2]);
        try {
            attributeArray = this.getAttributeArray("declareSdBerLevel");
        }
        catch (NoSuchElementException noSuchElementException) {
            attributeArray = null;
            this.table.removeColumn(tableColumn);
        }
        if (attributeArray != null) {
            tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(attributeArray)));
            tableColumn.sizeWidthToFit();
        }
        this.strucChangeObserver = new Observer(){

            public void update(Observable observable, Object object) {
                Integer n;
                if (object instanceof Integer && (n = (Integer)object).equals(ModelUpdateType.ADDED)) {
                    TdmLoProvPane.this.initializeLines();
                }
            }
        };
        this.add((Component)uScrollPane, "Center");
        this.registerWithModel();
    }

    private JComboBox getComboBoxFor(Attribute[] attributeArray) {
        JComboBox<Attribute> jComboBox = new JComboBox<Attribute>(attributeArray);
        jComboBox.setEditable(false);
        return jComboBox;
    }

    public Attribute[] getAttributeArray(String string) {
        return this.dataModel.getAttributeMap().getAttributeArray(string);
    }

    public void applyChangesToModel() throws Exception {
        int n = 0;
        try {
            for (n = 0; n < this.numLines; ++n) {
                if (this.dataModel.isDirty(n, 1)) {
                    this.loModels[n].getLoSfSdModel().setSfBerLevel(this.dataModel.getSfBerLevelIndex(n).getValue().shortValue());
                }
                if (!this.dataModel.isDirty(n, 2)) continue;
                this.loModels[n].getLoSfSdModel().setSdBerLevel(this.dataModel.getSdBerLevelIndex(n).getValue().shortValue());
            }
        }
        catch (Exception exception) {
            throw new AnnotatedException("An error occurred while applying changes to row " + (n + 1) + ".", exception);
        }
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        this.setDirty();
    }

    protected void changeMessage(Observable observable, Object object) {
        if (this.loModels == null) {
            return;
        }
        final int n = Arrays.asList(this.loModels).indexOf(observable);
        if (n != -1) {
            this.requestRefresh(observable, new Runnable(){

                public void run() {
                    TdmLoProvPane.this.dataModel.refreshLineFromModel(n);
                }
            });
        } else if (db.on()) {
            db.println("Error in finding the changed line in response to update");
        }
    }

    protected void deleteMessage(Observable observable, Object object) {
        this.initializeLines();
    }

    protected void registerWithModel() {
        int n;
        for (n = 0; n < this.numLines; ++n) {
            this.loModels[n].addObserver((Observer)((Object)this));
        }
        for (n = 0; n < this.lineModels.length; ++n) {
            this.lineModels[n].addObserver(this.strucChangeObserver);
        }
    }

    protected synchronized void initializeLines() {
        if (this.addDeleteThread == null) {
            this.addDeleteThread = new Runnable(){

                public void run() {
                    TdmLoProvPane.this.deregisterForUpdates();
                    TdmLoProvPane.this.loModels = TdmLoProvPane.this.getLOs(TdmLoProvPane.this.lineModels, TdmLoProvPane.this.indexOfLos);
                    TdmLoProvPane.this.numLines = TdmLoProvPane.this.loModels == null ? 0 : TdmLoProvPane.this.loModels.length;
                    TdmLoProvPane.this.registerWithModel();
                    TdmLoProvPane.this.dataModel.setLoModel(TdmLoProvPane.this.loModels);
                }
            };
        }
        SwingUtilities.invokeLater(this.addDeleteThread);
    }

    private TdmLoModel[] getLOs(Ds123LineModel[] ds123LineModelArray, int n) {
        Collection collection = InterfaceModel.getHigherLayerModels(ds123LineModelArray, n, this.getUiModel());
        if (collection.size() == 0) {
            return null;
        }
        try {
            return collection.toArray(new TdmLoModel[0]);
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Error in getting LOs for DS1");
            }
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    public void destroy() {
        this.deregisterForUpdates();
        super.destroy();
    }

    public void deregisterForUpdates() {
        int n;
        for (n = 0; n < this.numLines; ++n) {
            this.loModels[n].deleteObserver((Observer)((Object)this));
        }
        for (n = 0; n < this.lineModels.length; ++n) {
            this.lineModels[n].deleteObserver(this.strucChangeObserver);
        }
    }

    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshing Data Model " + this.dataModel);
        }
        this.dataModel.refreshFromModel();
    }
}

