/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.sonet;

import cerent.cms.idl.If.eIfType;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.BlsrModel;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.ElementModelsDelegate;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IPathInfo;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.LinePathHolder;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.TdmLoModel;
import cerent.cms.model.TdmPortModel;
import cerent.cms.ui.MuxIndex;
import cerent.cms.ui.PmTableModel;
import cerent.cms.ui.pm.PmLayer;
import cerent.cms.ui.pm.PmLayerSdhHoPath;
import cerent.cms.ui.pm.PmLayerSonetHoPath;
import cerent.cms.ui.pm.PmLayerSonetStsPjc;
import cerent.util.HoLoFactory;
import cerent.util.IHoNum;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.event.TableModelEvent;

public class TdmPmTableModel
extends PmTableModel {
    int curEastProtState = 0;
    int curWestProtState = 0;
    private NodeModelDelegate nmd;

    public TdmPmTableModel(TdmLineModel[] tdmLineModelArray, NodeModelDelegate nodeModelDelegate) {
        super(tdmLineModelArray, nodeModelDelegate);
        this.nmd = nodeModelDelegate;
    }

    protected PmLayer createPmLayerTdmLo(TdmLoModel tdmLoModel) {
        int n;
        block3: {
            n = -1;
            try {
                n = tdmLoModel.getModuleModel().getEqType();
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!db.on()) break block3;
                db.println("Error getting module from " + tdmLoModel.toString());
            }
        }
        if (n == 232) {
            return super.createPmLayerTdmLo(tdmLoModel);
        }
        return null;
    }

    protected int getMuxIndex(int n) {
        int n2 = 0;
        if (this.lineModels.length > 0) {
            int n3 = this.lineModels[0].getNodeModel().getTdmProtocolTypeObj().isSonet() ? 0 : 1;
            int n4 = n;
            IHoNum iHoNum = HoLoFactory.idlSts2HoNum(n3, n4);
            n2 = iHoNum.getHoNum();
        }
        return n2;
    }

    protected String getMediumStr(InterfaceModel interfaceModel) {
        try {
            if (interfaceModel instanceof TdmLineModel) {
                int n = ((TdmLineModel)interfaceModel).getLineInfoMediumType();
                if (n == 0) {
                    return ElementDefaults.getPortMediumString(0);
                }
                if (n == 1) {
                    return ElementDefaults.getPortMediumString(1);
                }
            }
        }
        catch (Exception exception) {
            db.println("Caught exception in getMediumString");
            SDebug.printStackTrace((Throwable)exception);
        }
        return "";
    }

    protected PmLayer createPmLayerTdmHo(LinePathHolder linePathHolder) {
        TdmLineModel tdmLineModel = linePathHolder.getLineModel();
        if (this.pci.is600()) {
            return new PmLayerSonetStsPjc((PmTableModel)this, (Object)linePathHolder, this.numRegisters);
        }
        if (tdmLineModel.getNodeModel().getTdmProtocolTypeObj().isSonet()) {
            return new PmLayerSonetHoPath((PmTableModel)this, (Object)linePathHolder, this.numRegisters);
        }
        return new PmLayerSdhHoPath((PmTableModel)this, (Object)linePathHolder, this.numRegisters);
    }

    protected MuxIndex createMuxIndex(Object object, int n) {
        MuxIndex muxIndex;
        if (object != null && object instanceof LinePathHolder) {
            LinePathHolder linePathHolder = (LinePathHolder)object;
            TdmLineModel tdmLineModel = linePathHolder.getLineModel();
            muxIndex = new LinePathHolderMuxIndex(tdmLineModel, linePathHolder.getHoNum());
        } else {
            muxIndex = super.createMuxIndex(object, n);
        }
        return muxIndex;
    }

    protected int getMuxIndex(Object object) throws NoSuchInterface {
        int n;
        if (object != null && object instanceof LinePathHolder) {
            LinePathHolder linePathHolder = (LinePathHolder)object;
            TdmLineModel tdmLineModel = linePathHolder.getLineModel();
            n = tdmLineModel.getInfo().muxIndex;
        } else {
            n = super.getMuxIndex(object);
        }
        return n;
    }

    protected eIfType getEIfType(Object object) throws NoSuchInterface {
        eIfType eIfType2 = object != null && object instanceof LinePathHolder ? eIfType.SONET_PATH : super.getEIfType(object);
        return eIfType2;
    }

    protected Object[] getNextLayer(InterfaceModel interfaceModel) {
        Object[] objectArray = super.getNextLayer(interfaceModel);
        if ((this.pci.is310ma() || this.pci.is310maSDH()) && !this.pci.isBlsrProtectionSupport()) {
            return objectArray;
        }
        ArrayList arrayList = new ArrayList();
        if (this.pci.isBlsrProtectionSupport()) {
            arrayList = this.getBlsrProtLinesList(interfaceModel);
        } else if (db.on()) {
            db.println("BLSR protection is NOT supported");
        }
        if (db.on()) {
            db.println("\ttry blsrlines\tsize is " + arrayList.size());
        }
        Object[] objectArray2 = new Object[objectArray.length + arrayList.size()];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        int n = 0;
        for (int i = objectArray.length; i < objectArray2.length; ++i) {
            objectArray2[i] = (LinePathHolder)arrayList.get(n++);
        }
        return objectArray2;
    }

    public synchronized void tossData() {
        super.tossData();
        InterfaceModel interfaceModel = null;
        if (this.pci.isBlsrProtectionSupport()) {
            ElementModelsDelegate elementModelsDelegate = this.nmd.getElementModelsDelegate();
            Set set = elementModelsDelegate.getBlsrElements();
            BlsrModel[] blsrModelArray = set.toArray(new BlsrModel[set.size()]);
            for (int i = 0; i < blsrModelArray.length; ++i) {
                for (int j = 0; j < this.lineModels.length; ++j) {
                    interfaceModel = this.lineModels[j];
                    if (!blsrModelArray[i].referencesEntityIndex(interfaceModel.getIndex()) || blsrModelArray[i].getEastProtState() == this.curEastProtState && blsrModelArray[i].getWestProtState() == this.curWestProtState) continue;
                    this.fireTableChanged(new TableModelEvent(this, -1, -1, -1, -100));
                    this.setChoice(this.getCurLayer(), this.getCurChoice());
                    this.curEastProtState = blsrModelArray[i].getEastProtState();
                    this.curWestProtState = blsrModelArray[i].getWestProtState();
                }
            }
        }
    }

    protected ArrayList getBlsrProtLinesList(InterfaceModel interfaceModel) {
        ArrayList<LinePathHolder> arrayList = new ArrayList<LinePathHolder>();
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.lineModels[0].getNodeModel();
        ElementModelsDelegate elementModelsDelegate = nodeModelDelegate.getElementModelsDelegate();
        Set set = elementModelsDelegate.getBlsrElements();
        BlsrModel[] blsrModelArray = set.toArray(new BlsrModel[set.size()]);
        for (int i = 0; i < blsrModelArray.length; ++i) {
            LinePathHolder linePathHolder;
            int n;
            IPathInfo[] iPathInfoArray;
            TdmLineModel tdmLineModel;
            IEntityModel iEntityModel;
            try {
                iEntityModel = blsrModelArray[i].getEastProtectEntityModel();
                if (iEntityModel != null && iEntityModel instanceof TdmPortModel && (tdmLineModel = ((TdmPortModel)iEntityModel).getTdmLineModel()) == interfaceModel) {
                    if (db.on()) {
                        db.println("This linemodel matches a BLSR's east protect: " + interfaceModel);
                    }
                    iPathInfoArray = blsrModelArray[i].getEastProtectHoPaths();
                    for (n = 0; n < iPathInfoArray.length; ++n) {
                        linePathHolder = new LinePathHolder(tdmLineModel, iPathInfoArray[n]);
                        arrayList.add(linePathHolder);
                    }
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                // empty catch block
            }
            try {
                iEntityModel = blsrModelArray[i].getWestProtectEntityModel();
                if (iEntityModel == null || !(iEntityModel instanceof TdmPortModel) || (tdmLineModel = ((TdmPortModel)iEntityModel).getTdmLineModel()) != interfaceModel) continue;
                if (db.on()) {
                    db.println("This linemodel matches a BLSR's west protect: " + interfaceModel);
                }
                iPathInfoArray = blsrModelArray[i].getWestProtectHoPaths();
                for (n = 0; n < iPathInfoArray.length; ++n) {
                    linePathHolder = new LinePathHolder(tdmLineModel, iPathInfoArray[n]);
                    arrayList.add(linePathHolder);
                }
                continue;
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                // empty catch block
            }
        }
        return arrayList;
    }

    protected PmLayer createPmLayer(eIfType eIfType2, Object object) {
        PmLayer pmLayer = object != null && object instanceof LinePathHolder ? this.createPmLayerTdmHo((LinePathHolder)object) : super.createPmLayer(eIfType2, object);
        return pmLayer;
    }

    class LinePathHolderMuxIndex
    extends MuxIndex {
        LinePathHolderMuxIndex(InterfaceModel interfaceModel, int n) {
            super(interfaceModel, n);
        }

        public String toString() {
            return super.toString() + " (switched)";
        }
    }
}

