/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.sonet;

import cerent.cms.idl.If.sInterface;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.TdmLoModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.LoInfo;
import cerent.util.HoLoFactory;
import cerent.util.HoLoHelper;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import javax.swing.table.AbstractTableModel;

public class TdmVtIppmTableModel
extends AbstractTableModel {
    private TdmLoModel[] model;
    protected final int framingType;
    private final TDMTerminology terms;
    private sInterface[] info;
    private boolean[][] isDirty;
    private Boolean[] enableIPPM;
    public String[] columnNames;
    private int numLines;
    private INodeModel node;
    private EntityCellRenderer myPortRenderer;
    public static final int VT_NUMBER_INDEX = 0;
    public static final int ENABLE_IPPM_INDEX = 1;
    private static final SDebug db = new SDebug("TdmVtIppmTableModel");

    public TdmVtIppmTableModel(INodeModel iNodeModel, TdmLoModel[] tdmLoModelArray) {
        this.model = tdmLoModelArray;
        this.node = iNodeModel;
        this.framingType = iNodeModel.getTdmProtocolTypeObj().isSonet() ? 0 : 1;
        this.terms = iNodeModel.getTDMTerminology();
        this.myPortRenderer = new EntityCellRenderer();
        this.columnNames = new String[2];
        this.columnNames[0] = this.terms.getGeneralTerms(1);
        this.columnNames[1] = "Enable IPPM";
        this.resetLocalData();
        this.resetDirty();
    }

    public int getRowCount() {
        return this.model == null ? 0 : this.model.length;
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    protected IHoNum getHoNum(int n) {
        if (this.model == null) {
            if (db.on()) {
                db.println("model is null in getHoNum for row " + n);
            }
            return null;
        }
        IHoNum iHoNum = null;
        sInterface sInterface2 = null;
        if (this.model[n] != null) {
            block7: {
                InterfaceModel interfaceModel = this.model[n].getFirstLowerLayerModels();
                if (interfaceModel != null) {
                    try {
                        sInterface2 = interfaceModel.getInfo();
                    }
                    catch (NoSuchInterface noSuchInterface) {
                        if (!db.on()) break block7;
                        db.println("Error getting STS for row " + n);
                    }
                }
            }
            if (sInterface2 != null) {
                iHoNum = HoLoFactory.idlSts2HoNum(this.framingType, sInterface2.muxIndex);
            }
        }
        return iHoNum;
    }

    protected ILoNum getLoNum(int n) {
        if (this.model == null) {
            if (db.on()) {
                db.println("model is null in getHoNum for row " + n);
            }
            return null;
        }
        ILoNum iLoNum = null;
        if (this.model[n] != null) {
            iLoNum = HoLoFactory.idlVt2LoNum(this.framingType, this.model[n].getVtTermPathWidth(), this.model[n].getVtNumber());
        }
        return iLoNum;
    }

    protected sInterface getInfo(int n) throws NoSuchInterface {
        if (this.model == null) {
            if (db.on()) {
                db.println("model is null in getInfo for row " + n);
            }
            return null;
        }
        if (this.info[n] == null) {
            this.info[n] = this.model[n].getInfo();
        }
        return this.info[n];
    }

    protected String getVtNumber(int n) throws NoSuchInterface {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.model == null) {
            if (db.on()) {
                db.println("model is null in getVtNumber for row " + n);
            }
            return stringBuffer.toString();
        }
        this.getInfo(n);
        if (this.info[n] != null) {
            stringBuffer.append("Port ");
            stringBuffer.append(this.getPortDescriptionFor(n));
            stringBuffer.append(", ");
            stringBuffer.append(HoLoHelper.getSlashSeparatedDisplay(this.getHoNum(n), this.getLoNum(n)));
        }
        return stringBuffer.toString();
    }

    public Boolean getVtIppmEnabled(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.model == null) {
            if (db.on()) {
                db.println("model is null in getVtIppmEnabled for row " + n);
            }
            return new Boolean(false);
        }
        if (this.enableIPPM[n] == null) {
            this.enableIPPM[n] = new Boolean(this.model[n].getVtIppmEnabled());
        }
        return this.enableIPPM[n];
    }

    public int getNumLines() {
        return this.numLines;
    }

    public boolean isDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }

    public boolean isCellEditable(int n, int n2) {
        boolean bl = false;
        if (this.model != null && this.numLines > 0 && AbstractPane.isUserAuthorized(this.model[0], SecurityLevel.MAINTENANCE) && !this.getLineModel(n).isProtectLine()) {
            bl = n2 == 1;
        }
        return bl;
    }

    public Class getColumnClass(int n) {
        Class clazz = null;
        switch (n) {
            case 1: {
                clazz = Boolean.class;
                break;
            }
            default: {
                clazz = Object.class;
            }
        }
        return clazz;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 0: {
                    return this.getVtNumber(n);
                }
                case 1: {
                    return this.getVtIppmEnabled(n);
                }
            }
            return null;
        }
        catch (Exception exception) {
            db.println("Caught exception in getValueAt");
            return null;
        }
    }

    public void setValueAt(Object object, int n, int n2) {
        if (db.on()) {
            db.println("Change in value " + n + " " + n2);
        }
        switch (n2) {
            case 1: {
                this.enableIPPM[n] = (Boolean)object;
                break;
            }
        }
        this.isDirty[n][n2] = true;
        this.fireTableCellUpdated(n, n2);
    }

    private String getPortDescriptionFor(int n) {
        String string;
        block3: {
            string = "";
            if (this.model == null && db.on()) {
                db.println("model is null in getPOrtDescriptionFor row " + n);
                return string;
            }
            try {
                string = this.myPortRenderer.getPortString((IEntityModel)this.model[n].getPortModel(), false);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!db.on()) break block3;
                db.println("Error while getPortModel row " + n);
            }
        }
        return string;
    }

    private void resetDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    private LoInfo getLoInfoFor(short s) {
        return new LoInfo(this.framingType, s);
    }

    protected TdmLineModel getLineModel(int n) {
        if (this.model == null && db.on()) {
            db.println("model is null in getLineModel for row " + n);
            return null;
        }
        InterfaceModel interfaceModel = this.model[n];
        InterfaceModel interfaceModel2 = interfaceModel.getFirstLowerLayerModels();
        try {
            while (interfaceModel2 != null) {
                interfaceModel = interfaceModel2;
                interfaceModel2 = interfaceModel.getFirstLowerLayerModels();
            }
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Error in getting lineModel " + exception);
            }
            return null;
        }
        return (TdmLineModel)interfaceModel;
    }

    public void refreshFromModel() {
        if (this.enableIPPM == null) {
            if (db.on()) {
                db.println("enableIPPM is null");
            }
            return;
        }
        for (int i = 0; i < this.enableIPPM.length; ++i) {
            this.enableIPPM[i] = null;
        }
        this.resetDirty();
        this.fireTableDataChanged();
    }

    public void refreshVtFromModel(int n) {
        if (n > this.numLines || n < 0) {
            return;
        }
        this.enableIPPM[n] = null;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.isDirty[n][i] = false;
        }
        this.fireTableRowsUpdated(n, n);
    }

    public synchronized void setLoModel(TdmLoModel[] tdmLoModelArray) {
        this.model = tdmLoModelArray;
        this.resetLocalData();
        this.refreshFromModel();
    }

    private void resetLocalData() {
        this.numLines = this.model == null ? 0 : this.model.length;
        this.info = new sInterface[this.numLines];
        this.enableIPPM = new Boolean[this.numLines];
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
    }
}

