/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.wbe;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.BbeSlot;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.Ds3LineUpdate;
import cerent.cms.model.E3LineUpdate;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.IPortContainer;
import cerent.cms.model.Model;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.ModuleModelUpdate;
import cerent.cms.model.PortModel;
import cerent.cms.model.WbeModuleModel;
import cerent.cms.ui.CardTabbedView;
import cerent.cms.ui.ComboCardMaintPane;
import cerent.cms.ui.ComboCardPmPane;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.Pane;
import cerent.cms.ui.PluggableCardTabbedView;
import cerent.cms.ui.event.IEventPanelController;
import cerent.cms.ui.wbe.E1E3Ds3ProvPane;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;

public class E1E3Ds3CardTabbedView
extends PluggableCardTabbedView
implements ITabName {
    private ArrayList e3LinesList;
    private ArrayList ds3LinesList;
    private BbeSlot _bbeSlot;
    private Ds123LineModel[] e1Lines;
    boolean isSdh;

    public E1E3Ds3CardTabbedView(ModuleModel moduleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        super(moduleModel, iEventPanelController, iUiToolkit);
    }

    protected void init() {
        int n;
        WbeModuleModel wbeModuleModel = (WbeModuleModel)this.getUiModel();
        Ds123LineModel[] ds123LineModelArray = wbeModuleModel.getE3Lines();
        this.e3LinesList = new ArrayList<Ds123LineModel>(Arrays.asList(ds123LineModelArray));
        this.getOM().addObservable((Observable[])ds123LineModelArray);
        int n2 = ds123LineModelArray.length;
        int n3 = 0;
        Ds123LineModel[] ds123LineModelArray2 = wbeModuleModel.getDs3Lines();
        this.ds3LinesList = new ArrayList<Ds123LineModel>(Arrays.asList(ds123LineModelArray2));
        this.getOM().addObservable((Observable[])ds123LineModelArray2);
        n3 = ds123LineModelArray2.length;
        this._interfaceContainers = Collections.synchronizedMap(new HashMap(n3 + n2));
        for (n = 0; n < n2; ++n) {
            this.addContainerMap(ds123LineModelArray[n]);
        }
        for (n = 0; n < n3; ++n) {
            this.addContainerMap(ds123LineModelArray2[n]);
        }
        try {
            this._bbeSlot = wbeModuleModel.getBbeSlot();
            this.getOM().addObservable((Observable)((Object)this._bbeSlot));
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            this._bbeSlot = null;
        }
        this.e1Lines = wbeModuleModel.getE1Lines();
        this.getOM().setActive(true);
        this.getOM().setPassing(true);
    }

    private Ds123LineModel[] getE3LinesArray() {
        return this.e3LinesList.toArray(new Ds123LineModel[this.e3LinesList.size()]);
    }

    private Ds123LineModel[] getDs3LinesArray() {
        return this.ds3LinesList.toArray(new Ds123LineModel[this.ds3LinesList.size()]);
    }

    protected List addModel(Observable observable) {
        WbeModuleModel wbeModuleModel = (WbeModuleModel)this.getUiModel();
        ArrayList<ModuleModelUpdate> arrayList = new ArrayList<ModuleModelUpdate>();
        if (observable instanceof BbeSlot) {
            Object object;
            IPortContainer iPortContainer = (IPortContainer)((Object)observable);
            Model[] modelArray = wbeModuleModel.getDs3Lines();
            if (modelArray.length > this.ds3LinesList.size()) {
                this.ds3LinesList = new ArrayList<Ds123LineModel>(Arrays.asList(modelArray));
                this.getOM().addObservable((Observable[])modelArray);
                arrayList.add(new Ds3LineUpdate(modelArray, iPortContainer));
                object = iPortContainer.getContainedPorts().iterator();
                while (object.hasNext()) {
                    this.addContainerMap(((PortModel)object.next()).getInterfaceModel(), iPortContainer);
                }
            }
            if (((Ds123LineModel[])(object = wbeModuleModel.getE3Lines())).length > this.e3LinesList.size()) {
                this.e3LinesList = new ArrayList<Ds123LineModel>(Arrays.asList(object));
                this.getOM().addObservable((Observable[])object);
                arrayList.add(new E3LineUpdate((Model[])object, iPortContainer));
                Iterator iterator = iPortContainer.getContainedPorts().iterator();
                while (iterator.hasNext()) {
                    this.addContainerMap(((PortModel)iterator.next()).getInterfaceModel(), iPortContainer);
                }
            }
        }
        return arrayList;
    }

    protected List removeModel(Observable observable) {
        ArrayList<ModuleModelUpdate> arrayList = new ArrayList<ModuleModelUpdate>();
        IPortContainer iPortContainer = (IPortContainer)this._interfaceContainers.get(observable);
        if (observable instanceof IInterfaceModel) {
            this.removeContainerMap((IInterfaceModel)observable);
        }
        this.getOM().removeObservable(observable);
        if (observable instanceof Ds123LineModel && this.ds3LinesList.remove(observable)) {
            arrayList.add(new Ds3LineUpdate(this.getDs3LinesArray(), iPortContainer));
        }
        if (observable instanceof Ds123LineModel && this.e3LinesList.remove(observable)) {
            arrayList.add(new E3LineUpdate(this.getE3LinesArray(), iPortContainer));
        }
        return arrayList;
    }

    public Pane getMaintenanceTab() {
        return new ComboCardMaintPane("Maintenance", (CardTabbedView)this, this.e1Lines, this.getE3LinesArray(), this.getDs3LinesArray());
    }

    public Pane getProvTab() {
        return new E1E3Ds3ProvPane("Provisioning", this, this.e1Lines, this.getE3LinesArray(), this.getDs3LinesArray());
    }

    public Pane getPerformanceTab() {
        return new ComboCardPmPane("Performance", (CardTabbedView)this, this.e1Lines, this.getE3LinesArray(), this.getDs3LinesArray());
    }

    public void destroy() {
        this.e3LinesList.clear();
        this.ds3LinesList.clear();
        this.e1Lines = null;
        super.destroy();
    }
}

