/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.wbe;

import cerent.cms.model.BbeSlot;
import cerent.cms.model.CmsNoSuchEntityException;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.EntityModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.WbeModuleModel;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.shelf.AbstractPortGraphic;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardView;
import cerent.cms.ui.shelf.GenericPortGraphic;
import cerent.util.SDebug;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class E1E3Ds3CardView
extends CardView
implements ITabName {
    private static final int MAX_PER_COLUMN = 10;
    protected static final SDebug db = new SDebug("E1E3Ds3CardView");
    protected BbeSlot bbeSlot;
    protected List bbePortObsList;
    protected int numBbePorts;
    protected int numWbePorts;

    public E1E3Ds3CardView(ModuleModel moduleModel) {
        block2: {
            super(moduleModel);
            try {
                this.bbeSlot = ((WbeModuleModel)moduleModel).getBbeSlot();
            }
            catch (CmsNoSuchEntityException cmsNoSuchEntityException) {
                db.println("Caught CmsNoSuchEntityException while registeringDs1Ds3Ec1CardView");
                if (!db.on()) break block2;
                SDebug.printStackTrace((Throwable)((Object)cmsNoSuchEntityException));
            }
        }
        this.bbePortObsList = new ArrayList();
        this.registerForLocalUpdates();
    }

    private JLabel formatLabel(String string) {
        return AbstractShelfLayout.formatLabel(new JLabel(string));
    }

    private int[] getBbeTypes() {
        return new int[]{32, 69};
    }

    private int[] getWbeTypes() {
        return new int[]{68};
    }

    private boolean isa(EntityModel entityModel, int[] nArray) {
        int n = entityModel.getEqType();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return true;
        }
        return false;
    }

    private void addBbePorts(int[] nArray, GridBagConstraints gridBagConstraints) {
        if (this.numBbePorts > 0) {
            int n;
            JPanel[] jPanelArray = new JPanel[this.numBbePorts];
            for (n = 0; n < this.numPorts; ++n) {
                EntityModel entityModel;
                Object e = this.portModels.get(n);
                if (!(e instanceof EntityModel) || !this.isa(entityModel = (EntityModel)e, nArray)) continue;
                this.ports[n] = new GenericPortGraphic(this, entityModel, entityModel.getPort());
                int n2 = entityModel.getPositionInParent();
                jPanelArray[n2 - 1] = this.ports[n];
            }
            n = gridBagConstraints.gridx;
            int n3 = gridBagConstraints.gridy;
            for (int i = 0; i < jPanelArray.length; ++i) {
                if (jPanelArray[i] == null) {
                    jPanelArray[i] = this.getPortSlotGraphic();
                }
                this.calcPortPosition(i + 1, n, n3, gridBagConstraints);
                this.add((Component)jPanelArray[i], gridBagConstraints);
            }
        }
    }

    private void addWbePorts(int[] nArray, GridBagConstraints gridBagConstraints) {
        int n = gridBagConstraints.gridx;
        int n2 = gridBagConstraints.gridy;
        for (int i = 0; i < this.numPorts; ++i) {
            EntityModel entityModel;
            Object e = this.portModels.get(i);
            if (!(e instanceof EntityModel) || !this.isa(entityModel = (EntityModel)e, nArray)) continue;
            this.ports[i] = new GenericPortGraphic(this, entityModel, entityModel.getPort());
            int n3 = entityModel.getPositionInParent();
            this.calcPortPosition(n3, n, n2, gridBagConstraints);
            this.add((Component)this.ports[i], gridBagConstraints);
        }
    }

    private void addLabel(String string, GridBagConstraints gridBagConstraints) {
        int n = gridBagConstraints.anchor;
        gridBagConstraints.anchor = 10;
        this.add((Component)this.formatLabel(string), gridBagConstraints);
        gridBagConstraints.anchor = n;
    }

    private void addCenteredLabel(String string, int n, GridBagConstraints gridBagConstraints) {
        int n2 = gridBagConstraints.gridwidth;
        int n3 = n / this.getPortCount();
        gridBagConstraints.gridwidth = n3 > 0 ? n3 : 1;
        this.addLabel(string, gridBagConstraints);
        gridBagConstraints.gridwidth = n2;
    }

    protected void addPorts(boolean bl) {
        this.numBbePorts = ((WbeModuleModel)this.model).getMaxBbePorts();
        this.numWbePorts = ((WbeModuleModel)this.model).getMaxWbePorts();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.addPortsVertically(gridBagConstraints);
        this.invalidate();
    }

    protected void addPortsVertically(GridBagConstraints gridBagConstraints) {
        boolean bl = this.model.getNodeModelDelegate().isSdh();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.addCenteredLabel("Wideband (E1)", this.numWbePorts, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.addWbePorts(this.getWbeTypes(), gridBagConstraints);
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(20, 0));
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridy = 0;
        this.add((Component)jPanel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridy = 0;
        this.addLabel("Broadband (E3/DS3)", gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.addBbePorts(this.getBbeTypes(), gridBagConstraints);
    }

    protected void calcPortPosition(int n, int n2, int n3, GridBagConstraints gridBagConstraints) {
        int n4;
        int n5 = this.getPortCount();
        int n6 = n4 = n > 0 ? n - 1 : 0;
        if (this.pci.positionPortsVertically()) {
            gridBagConstraints.gridx = n2 + n4 / n5;
            gridBagConstraints.gridy = n3 + n4 % n5;
        } else {
            gridBagConstraints.gridx = n2 + n4 % n5;
            gridBagConstraints.gridy = n3 + n4 / n5;
        }
    }

    protected int getPortCount() {
        return 10;
    }

    private JPanel getPortSlotGraphic() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createLineBorder(Color.gray));
        jPanel.setBackground(Color.lightGray);
        jPanel.setPreferredSize(new Dimension(16, 16));
        return jPanel;
    }

    public void update(Observable observable, Object object) {
        super.update(observable, object);
        if (observable instanceof EntityModel && this.model != null && this.model.getNodeModel().isInited() && object instanceof Integer) {
            Integer n = (Integer)object;
            if (db.on()) {
                db.println("update(): Ds1Ds3Ec1CardView, From=" + observable + ", arg=" + n);
            }
            if (n.equals(ModelUpdateType.ADDED)) {
                SwingUtilities.invokeLater(new ReplacePort());
                if (db.on()) {
                    db.println("Port ADDED");
                }
            } else if (n.equals(ModelUpdateType.DELETED)) {
                SwingUtilities.invokeLater(new ReplacePort());
                if (db.on()) {
                    db.println("Port DELETED");
                }
            } else if (n.equals(ModelUpdateType.CHANGED) && db.on()) {
                db.println("Port CHANGED");
            }
        }
    }

    protected void registerForLocalUpdates() {
        if (this.bbeSlot != null) {
            this.bbeSlot.addObserver(this);
            if (db.on()) {
                db.println("Registered BBE slot: " + this.bbeSlot);
            }
            List list = this.bbeSlot.getChildren();
            this.bbePortObsList = new ArrayList(list.size());
            PortModel portModel = null;
            for (int i = 0; i < list.size(); ++i) {
                portModel = (PortModel)list.get(i);
                if (portModel == null) continue;
                portModel.addObserver(this);
                this.bbePortObsList.add(portModel);
                if (!db.on()) continue;
                db.println("Registered BBE port: " + portModel);
            }
        }
    }

    protected void deregisterFromLocalUpdates() {
        if (this.bbeSlot != null) {
            this.bbeSlot.deleteObserver(this);
            if (db.on()) {
                db.println("Deregistered parent: " + this.bbeSlot);
            }
        }
        if (this.bbePortObsList != null) {
            PortModel portModel = null;
            ListIterator listIterator = this.bbePortObsList.listIterator();
            while (listIterator.hasNext()) {
                portModel = (PortModel)listIterator.next();
                if (portModel == null) continue;
                portModel.deleteObserver(this);
                listIterator.remove();
                if (!db.on()) continue;
                db.println("Deregistered Child: " + portModel);
            }
        }
    }

    protected void localDispose() {
        this.deregisterFromLocalUpdates();
        if (this.ports != null) {
            for (int i = 0; i < this.ports.length; ++i) {
                if (this.ports[i] == null) continue;
                this.ports[i].dispose();
                this.ports[i] = null;
            }
            this.ports = null;
        }
        this.removeAll();
    }

    static /* synthetic */ AbstractPortGraphic[] access$502(E1E3Ds3CardView e1E3Ds3CardView, AbstractPortGraphic[] abstractPortGraphicArray) {
        e1E3Ds3CardView.ports = abstractPortGraphicArray;
        return abstractPortGraphicArray;
    }

    protected class ReplacePort
    implements Runnable {
        protected ReplacePort() {
        }

        public void run() {
            block4: {
                try {
                    E1E3Ds3CardView.this.localDispose();
                    if (E1E3Ds3CardView.this.model != null) {
                        E1E3Ds3CardView.this.portModels = E1E3Ds3CardView.this.getPorts();
                        E1E3Ds3CardView.this.numPorts = E1E3Ds3CardView.this.portModels.size();
                        E1E3Ds3CardView.access$502(E1E3Ds3CardView.this, new AbstractPortGraphic[E1E3Ds3CardView.this.numPorts]);
                        E1E3Ds3CardView.this.addPorts(E1E3Ds3CardView.this.pci.positionPortsVertically());
                        E1E3Ds3CardView.this.refreshAlarmInfo();
                        E1E3Ds3CardView.this.registerForLocalUpdates();
                    }
                }
                catch (CmsObjectNotExistException cmsObjectNotExistException) {
                }
                catch (Exception exception) {
                    if (!db.on()) break block4;
                    db.println("Error replacing port: " + exception);
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            E1E3Ds3CardView.this.validate();
            E1E3Ds3CardView.this.repaint();
        }
    }
}

