/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.idl.Common.sIpAddr;
import cerent.cms.idl.EtherMedia.sEthMiTopInfo;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.IpAddrFactory;
import cerent.cms.model.IpConfigError;
import cerent.cms.model.ProvisionError;
import cerent.cms.ui.Pane;
import cerent.cms.ui.xpl2.XPL2EtherPdhProvTableModel;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.InetUtil;
import cerent.util.SDebug;
import cerent.util.gui.UDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class EthMiTopEditDialog
extends UDialog {
    private static final SDebug db = new SDebug("EthMiTopEditDialog");
    public static final String TITLE = "Edit PDH Ethernet Parameters";
    private static XPL2EtherPdhProvTableModel TBL_DATA_MODEL = null;
    private static int ROW = 0;
    private JButton okButton;
    private JButton cancelButton;
    private Pane parent;
    EthMiTopEditPane editPane;
    private boolean ok = false;

    public static EthMiTopEditDialog instance(Pane pane, XPL2EtherPdhProvTableModel xPL2EtherPdhProvTableModel, int n) {
        Frame frame = JOptionPane.getFrameForComponent((Component)pane);
        TBL_DATA_MODEL = xPL2EtherPdhProvTableModel;
        ROW = n;
        return new EthMiTopEditDialog(frame, TITLE, pane);
    }

    private EthMiTopEditDialog(Frame frame, String string, Object object) {
        super(frame, string, true, object);
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        this.ok = false;
        this.parent = (Pane)object;
        jPanel.add((Component)this.getEditPanel(TBL_DATA_MODEL, ROW), "Center");
        jPanel.add((Component)this.getButtonPanel(), "South");
    }

    public void dispose() {
        this.parent = null;
        super.dispose();
    }

    private void doOk() {
        if (this.apply()) {
            this.ok = true;
            this.dispose();
        }
    }

    private void doCancel() {
        this.dispose();
    }

    protected boolean apply() {
        return this.validateFields();
    }

    public boolean ok() {
        return this.ok;
    }

    private sIpAddr getIpAddr(String string) {
        return IpAddrFactory.getIpAddr(InetUtil.makeIpAddr(string));
    }

    private Integer getIntegerValue(String string) {
        return new Integer(string);
    }

    public sEthMiTopInfo getEthMiTopInfo() {
        int n = this.getIntegerValue(this.editPane.getMplsInLabel());
        int n2 = this.getIntegerValue(this.editPane.getMplsOutLabel());
        int n3 = this.getIntegerValue(this.editPane.getJitter());
        int n4 = this.getIntegerValue(this.editPane.getSensitivity());
        sIpAddr sIpAddr2 = this.getIpAddr(this.editPane.getSrcAddress());
        sIpAddr sIpAddr3 = this.getIpAddr(this.editPane.getPeerAddress());
        if (db.on()) {
            db.println("The Inner MPLS Label : " + n);
            db.println("The Outer MPLS Label : " + n2);
            db.println("The Jitter Value is : " + n3);
            db.println("The Sensitivity Value :" + n4);
            db.println("The Source IP Address : " + sIpAddr2.addr + sIpAddr2.toString());
            db.println("The Destination/Peer IP Address : " + sIpAddr3.addr + sIpAddr3.toString());
        }
        return new sEthMiTopInfo(n, n2, n3, n4, sIpAddr2, sIpAddr3);
    }

    private JPanel getEditPanel(XPL2EtherPdhProvTableModel xPL2EtherPdhProvTableModel, int n) {
        this.editPane = new EthMiTopEditPane(xPL2EtherPdhProvTableModel, n);
        return this.editPane;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EthMiTopEditDialog.this.doOk();
            }
        });
        jPanel.add(this.okButton);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EthMiTopEditDialog.this.doCancel();
            }
        });
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    private String exceptionMessage(NumberFormatException numberFormatException) {
        String string = numberFormatException.getMessage();
        int n = string.indexOf(58);
        if (n > 0) {
            string = string.substring(n + 1);
        }
        if (Character.isUpperCase(string.charAt(0))) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(Character.toLowerCase(string.charAt(0)));
            stringBuffer.append(string.substring(1));
            string = stringBuffer.toString();
        }
        return string;
    }

    private boolean validateFields() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = this.validateSrcPeerIp(stringBuffer);
        if (!bl) {
            return bl;
        }
        this.validateMplsLabels(stringBuffer);
        this.validateJitter(stringBuffer);
        if (stringBuffer.length() > 0) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_CANNOT_VALIDATE_DATA_PARAM_1, (Object)stringBuffer.toString());
        }
        return stringBuffer.length() == 0;
    }

    private boolean validateSrcPeerIp(StringBuffer stringBuffer) {
        String string = this.editPane.getSrcAddress();
        String string2 = this.editPane.getPeerAddress();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null) {
            arrayList.add(string);
        }
        if (string2 != null) {
            arrayList.add(string2);
        }
        try {
            for (int i = 0; i < arrayList.size(); ++i) {
                String string3 = (String)arrayList.get(i);
                if (string3 == null && string3.trim() == "") continue;
                InetAddress inetAddress = InetAddress.getByName(string3);
                if (inetAddress.equals(InetAddress.getByName("0:0:0:0:0:0:0:0"))) {
                    throw new UnknownHostException();
                }
                InetUtil.parseDottedString(string3);
                IIpAddr iIpAddr = InetUtil.makeIpAddr(string3);
                InetUtil.validateConfig(iIpAddr, null, 0, "MPLS Source/Peer IP");
                if (this.parent.getUiModel().getNodeModel().getIpConfig().getNodeMode() || inetAddress.getAddress().length <= 4) continue;
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_IPV6_ADDRESS_NOT_ALLOWED, (Object)"Source/Peer IP Address");
                return false;
            }
        }
        catch (IpConfigError ipConfigError) {
            stringBuffer.append("\n" + ipConfigError.getMessage());
        }
        catch (NumberFormatException numberFormatException) {
            stringBuffer.append("\nThe IP address specified for the source/peer is invalid.");
        }
        catch (UnknownHostException unknownHostException) {
            stringBuffer.append("\nThe IP address specified for the source/peer is invalid.");
        }
        return true;
    }

    private void validateMplsLabels(StringBuffer stringBuffer) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = "MPLS Inner Label";
        String string2 = "MPLS Outer Label";
        int n = 0;
        int n2 = 1048575;
        hashMap.put(string, this.editPane.getMplsInLabel());
        hashMap.put(string2, this.editPane.getMplsOutLabel());
        try {
            for (String string3 : hashMap.keySet()) {
                String string4 = (String)hashMap.get(string3);
                if (string3.equals(string)) {
                    n = 1;
                    n2 = 127;
                }
                if (string3.equals(string2)) {
                    n = 16;
                    n2 = 65535;
                }
                if (string4.trim() == "") {
                    throw new ProvisionError("\nThe value of " + string3 + " cannot be blank \n " + "The valid " + string3 + " ranges from " + n + " to " + n2);
                }
                int n3 = this.getIntegerValue(string4);
                if (n3 >= n && n3 <= n2) continue;
                throw new ProvisionError("\nThe value of " + string3 + " is out of range. \n" + "The valid " + string3 + " ranges from " + n + " to " + n2);
            }
        }
        catch (ProvisionError provisionError) {
            stringBuffer.append(provisionError.getMessage());
        }
        catch (Exception exception) {
            stringBuffer.append(exception.getMessage());
            stringBuffer.append("\n\nThe valid MPLS Inner Label value ranges from 1 to 127\nThe valid MPLS Outer Label value ranges from  16 to   65535");
        }
    }

    private void validateJitter(StringBuffer stringBuffer) {
        try {
            int n = this.getIntegerValue(this.editPane.getJitter());
            if (n < 1500 || n > 200000) {
                throw new ProvisionError("\nThe specified jitter buffer size is out of range. \nThe valid jitter buffer size ranges from 1500 to 200000.");
            }
        }
        catch (ProvisionError provisionError) {
            stringBuffer.append(provisionError.getMessage());
        }
        catch (Exception exception) {
            stringBuffer.append(exception.getMessage());
            stringBuffer.append("\nThe valid jitter buffer size ranges from 1500 to 200000.");
        }
    }

    private static class EthMiTopEditPane
    extends JPanel {
        private JTextField srcIpAddressTf;
        private JTextField peerIpAddressTf;
        private JTextField portNumTf;
        private JTextField portNameTf;
        private JTextField mplsInnerLabelTf;
        private JTextField mplsOuterLabelTf;
        private JTextField jitterTf;
        private JTextField sensitivityTf;
        private JComboBox sensitivityCb;
        private String portNumber;
        private String portName;
        private String srcIpAddress;
        private String peerIpAddress;
        private Integer mplsInLabel;
        private Integer mplsOutLabel;
        private Integer jitter;
        private Integer sensitivity;

        EthMiTopEditPane(XPL2EtherPdhProvTableModel xPL2EtherPdhProvTableModel, int n) {
            block2: {
                BoxLayout boxLayout = new BoxLayout(this, 1);
                this.setLayout(boxLayout);
                Dimension dimension = new Dimension(50, 15);
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new GridLayout(8, 2));
                JLabel jLabel = new JLabel("Port Number:");
                jLabel.setPreferredSize(dimension);
                jPanel.add(jLabel);
                this.portNumTf = new JTextField(35);
                jPanel.add(this.portNumTf);
                JLabel jLabel2 = new JLabel("Port Name:");
                jLabel2.setPreferredSize(dimension);
                jPanel.add(jLabel2);
                this.portNameTf = new JTextField(35);
                jPanel.add(this.portNameTf);
                JLabel jLabel3 = new JLabel("MPLS Inner Label:");
                jLabel3.setPreferredSize(dimension);
                jPanel.add(jLabel3);
                this.mplsInnerLabelTf = new JTextField(35);
                jPanel.add(this.mplsInnerLabelTf);
                JLabel jLabel4 = new JLabel("MPLS Outer Label:");
                jLabel4.setPreferredSize(dimension);
                jPanel.add(jLabel4);
                this.mplsOuterLabelTf = new JTextField(35);
                jPanel.add(this.mplsOuterLabelTf);
                JLabel jLabel5 = new JLabel("Jitter:");
                jLabel5.setPreferredSize(dimension);
                jPanel.add(jLabel5);
                this.jitterTf = new JTextField(35);
                jPanel.add(this.jitterTf);
                JLabel jLabel6 = new JLabel("RX Sensitivity:");
                jLabel6.setPreferredSize(dimension);
                jPanel.add(jLabel6);
                this.sensitivityCb = new JComboBox<String>(xPL2EtherPdhProvTableModel.getRxSensitivityValues());
                jPanel.add(this.sensitivityCb);
                JLabel jLabel7 = new JLabel("Source IP Address:");
                jLabel7.setPreferredSize(dimension);
                jPanel.add(jLabel7);
                this.srcIpAddressTf = new JTextField(35);
                jPanel.add(this.srcIpAddressTf);
                JLabel jLabel8 = new JLabel("Peer IP Address:");
                jLabel8.setPreferredSize(dimension);
                jPanel.add(jLabel8);
                this.peerIpAddressTf = new JTextField(35);
                jPanel.add(this.peerIpAddressTf);
                this.add(jPanel);
                try {
                    this.portName = xPL2EtherPdhProvTableModel.getPortName(n);
                    this.portNumber = xPL2EtherPdhProvTableModel.getLineNumberFor(n);
                    this.srcIpAddress = xPL2EtherPdhProvTableModel.getSrcIpAddr(n);
                    this.peerIpAddress = xPL2EtherPdhProvTableModel.getPeerIpAddr(n);
                    this.mplsInLabel = xPL2EtherPdhProvTableModel.getMplsInnerLabel(n);
                    this.mplsOutLabel = xPL2EtherPdhProvTableModel.getMplsOuterLabel(n);
                    this.jitter = xPL2EtherPdhProvTableModel.getJitter(n);
                    this.sensitivity = xPL2EtherPdhProvTableModel.getSensitivity(n);
                }
                catch (Exception exception) {
                    if (!db.on()) break block2;
                    db.println("Error in getValueAt in HdGePortTableModel " + exception);
                    db;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            this.portNumTf.setText(this.portNumber);
            this.portNameTf.setText(this.portName);
            this.srcIpAddressTf.setText(this.srcIpAddress.trim());
            this.peerIpAddressTf.setText(this.peerIpAddress.trim());
            this.mplsInnerLabelTf.setText(this.mplsInLabel.toString().trim());
            this.mplsOuterLabelTf.setText(this.mplsOutLabel.toString().trim());
            this.jitterTf.setText(this.jitter.toString());
            this.sensitivityCb.setSelectedItem(this.sensitivity.toString());
            this.portNumTf.setEnabled(false);
            this.portNameTf.setEnabled(false);
        }

        String getSrcAddress() {
            return this.srcIpAddressTf.getText().trim();
        }

        String getPeerAddress() {
            return this.peerIpAddressTf.getText().trim();
        }

        String getMplsInLabel() {
            return this.mplsInnerLabelTf.getText().trim();
        }

        String getMplsOutLabel() {
            return this.mplsOuterLabelTf.getText().trim();
        }

        String getJitter() {
            return this.jitterTf.getText().trim();
        }

        String getSensitivity() {
            return (String)this.sensitivityCb.getSelectedItem();
        }
    }
}

