/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.idl.EtherL2Media.sVlanCondReportInfo;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.EntityTableModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InterfaceModels;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.XPL2Layer2LineModel;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.ui.EntityCellRenderer;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.table.AbstractTableModel;

public class XPL2AffectedVlanTableModel
extends AbstractTableModel
implements Observer {
    public static final int PORT_INDEX = 0;
    static final String[] columnNames = new String[]{"Port"};
    private XPL2ModuleModel eqpmtModel = null;
    private int numLines = 0;
    private EntityTableModel etm;
    protected EntityCellRenderer myPortRenderer;
    private InterfaceModels ifs;
    private ArrayList reportInfoList = new ArrayList();
    private static final SDebug db = new SDebug("XPL2AffectedVlanTableModel");

    public XPL2AffectedVlanTableModel(XPL2ModuleModel xPL2ModuleModel) {
        this.eqpmtModel = xPL2ModuleModel;
        this.myPortRenderer = new EntityCellRenderer(false);
        this.etm = xPL2ModuleModel.getNodeModelDelegate().getEntityTableModel();
        this.ifs = xPL2ModuleModel.getNodeModelDelegate().getIfModels();
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public String getColumnName(int n) {
        if (n >= 0 && n < columnNames.length) {
            return columnNames[n];
        }
        return null;
    }

    public int getRowCount() {
        return this.numLines;
    }

    public Object getValueAt(int n, int n2) {
        String string;
        block5: {
            string = null;
            try {
                switch (n2) {
                    case 0: {
                        string = this.getPortName(n);
                    }
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block5;
                db.println("Error in getValueAt in XPL2AffectedVlanTableModel " + exception);
                KDebug.printStackTrace((Throwable)exception);
            }
        }
        return string;
    }

    public StringBuffer getAffectedVlanIds(int n) {
        AffectedVlanInfo affectedVlanInfo = (AffectedVlanInfo)this.reportInfoList.get(n);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < affectedVlanInfo.lanInfo.length; ++i) {
            stringBuffer.append(Short.toString(affectedVlanInfo.lanInfo[i].vlanId) + "\n");
        }
        return stringBuffer;
    }

    public String getPortName(int n) {
        block5: {
            AffectedVlanInfo affectedVlanInfo = (AffectedVlanInfo)this.reportInfoList.get(n);
            if (affectedVlanInfo.lanInfo.length > 0) {
                try {
                    IPortModel iPortModel = this.ifs.getInterfaceModel(affectedVlanInfo.ifIndex).getPortModel();
                    return this.myPortRenderer.getPortString((IEntityModel)iPortModel, false);
                }
                catch (NoSuchInterface noSuchInterface) {
                    if (db.on()) {
                        db.println("Error in getPortName in XPL2SecurityTableModel " + (Object)((Object)noSuchInterface));
                        KDebug.printStackTrace((Throwable)noSuchInterface);
                    }
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!db.on()) break block5;
                    db.println("Error in getPortName in XPL2SecurityTableModel " + (Object)((Object)abstractCmsNoSuchEntityException));
                    KDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
        }
        return null;
    }

    public void update(Observable observable, Object object) {
    }

    public void reload() {
        XPL2Layer2LineModel[] xPL2Layer2LineModelArray = this.eqpmtModel.getXPL2Layer2EtherLines();
        this.numLines = 0;
        this.reportInfoList.clear();
        if (xPL2Layer2LineModelArray != null) {
            for (int i = 0; i < xPL2Layer2LineModelArray.length; ++i) {
                try {
                    sVlanCondReportInfo[] sVlanCondReportInfoArray = this.eqpmtModel.getActualVlanConditions(xPL2Layer2LineModelArray[i].getIndex());
                    if (sVlanCondReportInfoArray == null || sVlanCondReportInfoArray.length <= 0) continue;
                    this.reportInfoList.add(new AffectedVlanInfo(xPL2Layer2LineModelArray[i].getIndex(), sVlanCondReportInfoArray));
                    ++this.numLines;
                    continue;
                }
                catch (NoSuchInterface noSuchInterface) {
                    if (!db.on()) continue;
                    db.println("Error in reload in XPL2AffectedVlanTableModel " + (Object)((Object)noSuchInterface));
                    KDebug.printStackTrace((Throwable)noSuchInterface);
                    continue;
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    if (!db.on()) continue;
                    db.println("Error in reload in XPL2AffectedVlanTableModel " + (Object)((Object)wrongInterfaceType));
                    KDebug.printStackTrace((Throwable)wrongInterfaceType);
                }
            }
        }
        this.fireTableDataChanged();
    }

    public void dispose() {
        this.reportInfoList.clear();
    }

    private class AffectedVlanInfo {
        int ifIndex;
        sVlanCondReportInfo[] lanInfo;

        AffectedVlanInfo(int n, sVlanCondReportInfo[] sVlanCondReportInfoArray) {
            this.ifIndex = n;
            this.lanInfo = new sVlanCondReportInfo[sVlanCondReportInfoArray.length];
            this.lanInfo = sVlanCondReportInfoArray;
        }
    }
}

