/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.model.DwdmLineUpdate;
import cerent.cms.model.EtherLineModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.XPL2LineModel;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.xpl2.EthMiTopEditDialog;
import cerent.cms.ui.xpl2.XPL2EtherPdhProvTableModel;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class XPL2EtherPdhProvPane
extends NodeProvPane
implements TableModelListener,
ListSelectionListener {
    protected XPL2EtherPdhProvTableModel dataModel = null;
    protected XPL2ModuleModel eqpmtModel = null;
    protected XPL2LineModel[] lineModels = null;
    protected XPL2LineModel[] ethLineModels = null;
    protected PortModel[] ethPortModels = null;
    private ObservableManager _obsMgr;
    protected int numLines = 0;
    private JButton editButton;
    private static final SDebug db = new SDebug("XPL2EtherPdhProvPane");

    public XPL2EtherPdhProvPane(String string, TabbedView tabbedView, XPL2ModuleModel xPL2ModuleModel) {
        super(string, tabbedView);
        this.eqpmtModel = xPL2ModuleModel;
        this.ethLineModels = xPL2ModuleModel.getXPL2EtherLines();
        this.ethPortModels = xPL2ModuleModel.getXPL2EtherPorts();
        ArrayList<XPL2LineModel> arrayList = new ArrayList<XPL2LineModel>(Arrays.asList(this.ethLineModels));
        for (int i = 0; i < this.ethLineModels.length; ++i) {
            if (this.ethLineModels[i].isMiTopLine()) continue;
            arrayList.remove(this.ethLineModels[i]);
        }
        this.lineModels = arrayList.toArray(new XPL2LineModel[arrayList.size()]);
        this.numLines = this.lineModels.length;
        this.numLines = this.lineModels == null ? 0 : this.lineModels.length;
        this.setDataModel();
        this.table = new UTable((TableModel)this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        uScrollPane.setPreferredSize(new Dimension(200, 150));
        this.add((Component)uScrollPane);
        this.customizedProvPane();
        this.registerWithModel();
    }

    public void enteringPage() throws Exception {
        this.registerWithModel();
        super.enteringPage();
        if (db.on()) {
            db.println("XPL2EtherPdhProvPane::enteringPage!");
        }
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        this.dataModel.refreshMyLines(null);
    }

    public void leavingPage() throws Exception {
        this.unRegisterWithModel();
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        if (db.on()) {
            db.println("XPL2EtherPdhProvPane::leavingPage!");
        }
        super.leavingPage();
    }

    protected void customizedProvPane() {
        Object var1_1 = null;
        this.table.getColumnModel().getColumn(0).setPreferredWidth(180);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(180);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(180);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(180);
        this.table.getColumnModel().getColumn(4).setPreferredWidth(180);
        this.table.getColumnModel().getColumn(5).setPreferredWidth(180);
        this.table.getColumnModel().getColumn(6).setPreferredWidth(180);
        this.table.getColumnModel().getColumn(7).setPreferredWidth(180);
        this.table.getSelectionModel().addListSelectionListener(this);
        JPanel jPanel = this.addButtonPanelOnSouth();
        this.add(jPanel, "South");
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        this.editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XPL2EtherPdhProvPane.this.updateMiTopEthInfo();
            }
        });
    }

    public void updateMiTopEthInfo() {
        EthMiTopEditDialog ethMiTopEditDialog = EthMiTopEditDialog.instance(this, this.dataModel, this.table.getSelectedRow());
        ethMiTopEditDialog.show();
        if (ethMiTopEditDialog.ok()) {
            int n = this.table.getSelectedRow();
            try {
                this.dataModel.setLineMiTopInfo(ethMiTopEditDialog.getEthMiTopInfo(), n);
            }
            catch (ProvisionError provisionError) {
                EID eID;
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)provisionError);
                }
                if ((eID = provisionError.getEID()) != null) {
                    if (eID == EMC.EID_WRONG_INPUT) {
                        ErrorMsg.displayDetailed((Component)((Object)this), eID, provisionError.toString());
                    } else {
                        ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_GENERIC_PROV_ERROR, provisionError.toString());
                    }
                }
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_GENERIC_PROV_ERROR, exception.toString());
            }
        }
    }

    protected JPanel addButtonPanelOnSouth() {
        JPanel jPanel = XPL2EtherPdhProvPane.createHorizontalPanel(null);
        Dimension dimension = new Dimension(90, 25);
        this.editButton = new JButton("Edit...");
        this.editButton.setMinimumSize(dimension);
        this.editButton.setMaximumSize(dimension);
        this.manageButtons();
        jPanel.add(this.editButton);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add(jPanel);
        return jPanel2;
    }

    private void manageButtons() {
        SecurityLevel securityLevel = SecurityLevel.SUPERUSER;
        this.editButton.setEnabled(this.isUserAuthorized(securityLevel) && this.isSelected());
    }

    boolean isSelected() {
        return this.table.getSelectedRowCount() > 0;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.manageButtons();
    }

    protected void setDataModel() {
        this.dataModel = new XPL2EtherPdhProvTableModel((XPL2ModuleModel)this.getUiModel(), this.lineModels);
        this.dataModel.addTableModelListener(this);
    }

    protected void registerWithModel() {
        int n;
        super.registerWithModel();
        for (n = 0; n < this.ethPortModels.length; ++n) {
            this.getObsMgr().addObservable((Observable)((Object)this.ethPortModels[n]));
        }
        for (n = 0; n < this.ethLineModels.length; ++n) {
            this.getObsMgr().addObservable((Observable)((Object)this.ethLineModels[n]));
        }
    }

    private ObservableManager getObsMgr() {
        if (this._obsMgr == null) {
            this._obsMgr = new ObservableManager((Observer)((Object)this), true);
        }
        return this._obsMgr;
    }

    protected void unRegisterWithModel() {
        int n;
        super.registerWithModel();
        for (n = 0; n < this.ethPortModels.length; ++n) {
            this.getObsMgr().removeObservable((Observable)((Object)this.ethPortModels[n]));
        }
        for (n = 0; n < this.ethLineModels.length; ++n) {
            this.getObsMgr().removeObservable((Observable)((Object)this.ethLineModels[n]));
        }
    }

    protected void deleteMessage(Observable observable, Object object) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                XPL2EtherPdhProvPane.this.unRegisterWithModel();
                XPL2EtherPdhProvPane.this.refreshMyLines(null);
            }
        });
    }

    public void refreshMyLines(Object object) {
        if (!(object instanceof DwdmLineUpdate)) {
            return;
        }
        DwdmLineUpdate dwdmLineUpdate = (DwdmLineUpdate)object;
        EtherLineModel[] etherLineModelArray = dwdmLineUpdate.getEtherLineModel();
        this.ethLineModels = new XPL2LineModel[etherLineModelArray.length];
        System.arraycopy(etherLineModelArray, 0, this.ethLineModels, 0, this.ethLineModels.length);
        this.dataModel.refreshMyLines(this.ethLineModels);
    }

    public void destroy() {
        this.unRegisterWithModel();
        if (this.dataModel != null) {
            this.dataModel.removeTableModelListener(this);
            this.dataModel.destroy();
            this.dataModel = null;
        }
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.dataModel.isDirty()) {
            this.setDirty();
        } else {
            this.resetDirty();
        }
    }

    protected boolean queryRemainDirty() {
        return true;
    }

    public boolean onValidate() {
        return true;
    }

    public void refreshFromModel() throws Exception {
        this.dataModel.refreshFromModel();
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.XPL2EtherPdhProvPane;
    }
}

