/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.model.ILearnedAddress;
import cerent.cms.model.IModel;
import cerent.cms.ui.xpl2.XPL2MacAddrDataSource;
import cerent.cms.ui.xpl2.XPL2MacAddrSourceInfo;
import cerent.util.ComparisonUtil;
import cerent.util.MacAddrFormat;
import cerent.util.gui.row.AbstractColumnRenderer;
import cerent.util.gui.row.ColumnRenderer;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;

public class XPL2MacAddrColumnRenderer
extends AbstractColumnRenderer {
    private static final int COLUMN_COUNT = 3;
    private static final int MAC_ADDRESS = 0;
    private static final int VLAN = 1;
    private static final int PORT = 2;
    private JLabel label = new JLabel();

    public XPL2MacAddrColumnRenderer(XPL2MacAddrDataSource xPL2MacAddrDataSource, String string, int n, boolean bl, int n2) {
        super(string, n, bl, n2);
        this.label.setHorizontalAlignment(n2);
        this.label.setVerticalAlignment(1);
        this.label.setOpaque(true);
        this.label.setForeground(Color.black);
        this.label.setFont(this.label.getFont().deriveFont(0));
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        String string = "";
        JLabel jLabel = this.label;
        Color color = bl ? jTable.getSelectionForeground() : jTable.getForeground();
        Color color2 = bl ? jTable.getSelectionBackground() : jTable.getBackground();
        XPL2MacAddrSourceInfo xPL2MacAddrSourceInfo = (XPL2MacAddrSourceInfo)object;
        ILearnedAddress iLearnedAddress = xPL2MacAddrSourceInfo.getLearnedAddress();
        switch (n2) {
            case 0: {
                string = this.getMacAddress(iLearnedAddress.getMacAddress());
                break;
            }
            case 1: {
                string = iLearnedAddress.getVlanId() + "";
                break;
            }
            case 2: {
                string = xPL2MacAddrSourceInfo.getPortDescription();
            }
        }
        if (!bl) {
            color = Color.black;
            color2 = Color.white;
        }
        this.label.setText(string);
        ((Component)jLabel).setForeground(color);
        ((Component)jLabel).setBackground(color2);
        return jLabel;
    }

    private String getMacAddress(byte[] byArray) {
        return MacAddrFormat.format(byArray);
    }

    public int compareColumn(Object object, Object object2, int n) {
        int n2 = 0;
        XPL2MacAddrSourceInfo xPL2MacAddrSourceInfo = (XPL2MacAddrSourceInfo)object;
        XPL2MacAddrSourceInfo xPL2MacAddrSourceInfo2 = (XPL2MacAddrSourceInfo)object2;
        ILearnedAddress iLearnedAddress = xPL2MacAddrSourceInfo.getLearnedAddress();
        ILearnedAddress iLearnedAddress2 = xPL2MacAddrSourceInfo2.getLearnedAddress();
        switch (n) {
            case 0: {
                n2 = MacAddrFormat.compareMacAddr(iLearnedAddress.getMacAddress(), iLearnedAddress2.getMacAddress());
                break;
            }
            case 1: {
                n2 = iLearnedAddress.getVlanId() - iLearnedAddress2.getVlanId();
                break;
            }
            case 2: {
                n2 = iLearnedAddress.getIfIndex() - iLearnedAddress2.getIfIndex();
            }
        }
        return n2;
    }

    public static int comparePort(XPL2MacAddrSourceInfo xPL2MacAddrSourceInfo, XPL2MacAddrSourceInfo xPL2MacAddrSourceInfo2) {
        int[] nArray = xPL2MacAddrSourceInfo.getPortModel().getPortNum();
        int[] nArray2 = xPL2MacAddrSourceInfo2.getPortModel().getPortNum();
        return ComparisonUtil.compare((int[])nArray, (int[])nArray2);
    }

    static ColumnRenderer[] createTableRenderers(XPL2MacAddrDataSource xPL2MacAddrDataSource, IModel iModel) {
        ColumnRenderer[] columnRendererArray = new ColumnRenderer[3];
        for (int i = 0; i < columnRendererArray.length; ++i) {
            columnRendererArray[i] = XPL2MacAddrColumnRenderer.createColumnRenderer(xPL2MacAddrDataSource, iModel, i);
        }
        return columnRendererArray;
    }

    public static ColumnRenderer createColumnRenderer(XPL2MacAddrDataSource xPL2MacAddrDataSource, IModel iModel, int n) {
        int n2;
        boolean bl;
        int n3;
        String string;
        switch (n) {
            case 0: {
                string = "MAC Address";
                n3 = 100;
                bl = true;
                n2 = 2;
                break;
            }
            case 1: {
                string = "VLAN";
                n3 = 35;
                bl = true;
                n2 = 2;
                break;
            }
            case 2: {
                string = "Port";
                n3 = 35;
                bl = true;
                n2 = 2;
                break;
            }
            default: {
                string = "???";
                n3 = 20;
                bl = false;
                n2 = 2;
            }
        }
        return new XPL2MacAddrColumnRenderer(xPL2MacAddrDataSource, string, n3, bl, n2);
    }
}

