/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.model.DwdmLineUpdate;
import cerent.cms.model.EtherLineModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.XPL2LineModel;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.shelf.HexTextField;
import cerent.cms.ui.xpl2.XPL2LineCellEditor;
import cerent.cms.ui.xpl2.XPL2MapEtherPortTableModel;
import cerent.util.DetailedLog;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.DetailedLogDialog;
import cerent.util.gui.NumberTextField;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

public class XPL2MapEtherPortProvPane
extends NodeProvPane
implements PropertyChangeListener,
TableModelListener {
    protected XPL2MapEtherPortTableModel dataModel = null;
    protected XPL2ModuleModel eqpmtModel = null;
    protected XPL2LineModel[] lineModels = null;
    protected PortModel[] portModels = null;
    private boolean notInited = true;
    private ObservableManager _obsMgr;
    private boolean isL2Mode = false;
    private static final SDebug db = new SDebug("XPL2MapEtherPortProvPane");

    public XPL2MapEtherPortProvPane(String string, TabbedView tabbedView, final XPL2ModuleModel xPL2ModuleModel) {
        super(string, tabbedView);
        this.eqpmtModel = xPL2ModuleModel;
        this.portModels = xPL2ModuleModel.getXPL2EtherPorts();
        this.lineModels = xPL2ModuleModel.getXPL2EtherLines();
        if (xPL2ModuleModel == null || this.portModels == null || this.lineModels == null || this.portModels.length != this.lineModels.length) {
            if (db.on()) {
                db.println("Error during initialization");
                db.println("eqpmtModel=" + xPL2ModuleModel + " portModels=" + this.portModels + " lineModels=" + this.lineModels);
            }
            return;
        }
        this.dataModel = new XPL2MapEtherPortTableModel(xPL2ModuleModel, this.portModels, this.lineModels);
        this.dataModel.addTableModelListener(this);
        final DefaultCellEditor defaultCellEditor = new DefaultCellEditor(this.getComboBoxFor(this.dataModel.getEtherModeAttrsOneVal()));
        final DefaultCellEditor defaultCellEditor2 = new DefaultCellEditor(this.getComboBoxFor(this.dataModel.getEtherModeAttrsTwoVals()));
        final DefaultCellEditor defaultCellEditor3 = new DefaultCellEditor(this.getComboBoxFor(this.dataModel.getEtherModeAttrsFeTwoVals()));
        final DefaultCellEditor defaultCellEditor4 = new DefaultCellEditor(this.getComboBoxFor(this.dataModel.getFeMediaTypeAttrs()));
        final DefaultCellEditor defaultCellEditor5 = new DefaultCellEditor(this.getComboBoxFor(this.dataModel.getGeMediaAttrs()));
        this.table = new UTable(this.dataModel){

            public TableCellEditor getCellEditor(int n, int n2) {
                if (this.convertColumnIndexToModel(n2) == 2) {
                    if (xPL2ModuleModel.getEqType() == 272 && !XPL2MapEtherPortProvPane.this.lineModels[n].isTrunk()) {
                        if (XPL2MapEtherPortProvPane.this.lineModels[n].supportsFESpeed()) {
                            return defaultCellEditor3;
                        }
                        return defaultCellEditor2;
                    }
                    return defaultCellEditor;
                }
                if (this.convertColumnIndexToModel(n2) == 5) {
                    if (XPL2MapEtherPortProvPane.this.lineModels[n].isMiTopLine() || XPL2MapEtherPortProvPane.this.lineModels[n].isMiRicLine()) {
                        return new XPL2LineCellEditor(XPL2MapEtherPortProvPane.this.lineModels, (XPL2MapEtherPortTableModel)this.dataModel, XPL2MapEtherPortProvPane.this.getComboBoxFor(((XPL2MapEtherPortTableModel)this.dataModel).getRadFlowCntrlAttrs()), 5);
                    }
                    return new XPL2LineCellEditor(XPL2MapEtherPortProvPane.this.lineModels, (XPL2MapEtherPortTableModel)this.dataModel, XPL2MapEtherPortProvPane.this.getComboBoxFor(((XPL2MapEtherPortTableModel)this.dataModel).getFlowAttrs()), 5);
                }
                if (this.convertColumnIndexToModel(n2) == 18) {
                    if (XPL2MapEtherPortProvPane.this.lineModels[n].isMiTopLine() || XPL2MapEtherPortProvPane.this.lineModels[n].isMiRicLine()) {
                        return new XPL2LineCellEditor(XPL2MapEtherPortProvPane.this.lineModels, (XPL2MapEtherPortTableModel)this.dataModel, XPL2MapEtherPortProvPane.this.getComboBoxFor(((XPL2MapEtherPortTableModel)this.dataModel).getRadSquelchAttrs()), 18);
                    }
                    return new XPL2LineCellEditor(XPL2MapEtherPortProvPane.this.lineModels, (XPL2MapEtherPortTableModel)this.dataModel, XPL2MapEtherPortProvPane.this.getComboBoxFor(((XPL2MapEtherPortTableModel)this.dataModel).getProtActionAttrs()), 18);
                }
                if (this.convertColumnIndexToModel(n2) == 6) {
                    if (xPL2ModuleModel.getEqType() == 272 && !XPL2MapEtherPortProvPane.this.lineModels[n].isTrunk() && XPL2MapEtherPortProvPane.this.lineModels[n].supportsFESpeed()) {
                        return defaultCellEditor4;
                    }
                    return defaultCellEditor5;
                }
                return super.getCellEditor(n, n2);
            }
        };
        this.table.setCellSelectionEnabled(true);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.customizedProvPane();
        this.add((Component)uScrollPane);
        this.registerWithModel();
    }

    protected void removeColumn(int n) {
        TableColumn tableColumn = this.table.getColumn(this.dataModel.getColumnName(n));
        this.table.removeColumn(tableColumn);
    }

    protected void addColumn(int n) {
        TableColumn tableColumn = new TableColumn(n);
        this.table.addColumn(tableColumn);
    }

    public void refreshMyLines(Object object) {
        if (!(object instanceof DwdmLineUpdate)) {
            return;
        }
        DwdmLineUpdate dwdmLineUpdate = (DwdmLineUpdate)object;
        EtherLineModel[] etherLineModelArray = dwdmLineUpdate.getEtherLineModel();
        this.lineModels = new XPL2LineModel[etherLineModelArray.length];
        System.arraycopy(etherLineModelArray, 0, this.lineModels, 0, this.lineModels.length);
        this.dataModel.refreshMyLines(this.lineModels);
    }

    public void enteringPage() throws Exception {
        if (db.on()) {
            db.println("calling enteringPage");
        }
        if (this.notInited) {
            this.init();
        }
        super.enteringPage();
        this.getObsMgr().setPassing(true);
        this.registerWithModel();
    }

    public void leavingPage() throws Exception {
        this.getObsMgr().setPassing(false);
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        if (db.on()) {
            db.println("calling leavingPage");
        }
        super.leavingPage();
        this.unRegisterWithModel();
    }

    protected void deleteMessage(Observable observable, Object object) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                XPL2MapEtherPortProvPane.this.unRegisterWithModel();
                XPL2MapEtherPortProvPane.this.refreshMyLines(null);
            }
        });
    }

    private void init() {
        boolean bl;
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        boolean bl2 = bl = this.table.getColumnModel().getColumnCount() > 7;
        if (this.eqpmtModel.isInTxpMode() && bl) {
            this.removeColumn(7);
            this.removeColumn(8);
            this.removeColumn(9);
        } else if (!this.eqpmtModel.isInTxpMode() && !bl) {
            this.addColumn(7);
            this.addColumn(8);
            this.addColumn(9);
            this.customizedProvPane();
        }
        boolean bl3 = this.table.getColumnModel().getColumnCount() > 10;
        this.isL2Mode = this.eqpmtModel.isInL2Mode();
        if (!this.eqpmtModel.isInL2Mode() && bl3) {
            this.removeColumn(10);
            this.removeColumn(11);
            this.removeColumn(12);
            this.removeColumn(13);
            this.removeColumn(14);
            this.removeColumn(15);
            this.removeColumn(16);
            this.removeColumn(17);
            this.removeColumn(18);
        } else if (this.eqpmtModel.isInL2Mode() && !bl3) {
            this.addColumn(10);
            this.addColumn(11);
            this.addColumn(12);
            this.addColumn(13);
            this.addColumn(14);
            this.addColumn(15);
            this.addColumn(16);
            this.addColumn(17);
            this.addColumn(18);
            this.customizedProvPane();
        }
        if (this.notInited && this.eqpmtModel.getEqType() != 272) {
            this.removeColumn(3);
            this.removeColumn(4);
            this.removeColumn(6);
        }
        this.notInited = false;
    }

    protected void registerWithModel() {
        int n;
        super.registerWithModel();
        for (n = 0; n < this.portModels.length; ++n) {
            this.getObsMgr().addObservable((Observable)((Object)this.portModels[n]));
        }
        for (n = 0; n < this.lineModels.length; ++n) {
            this.getObsMgr().addObservable((Observable)((Object)this.lineModels[n]));
        }
        for (n = 0; n < this.lineModels.length; ++n) {
            this.getObsMgr().addObservable((Observable)((Object)this.lineModels[n].getLayer2LineModel()));
        }
    }

    protected void unRegisterWithModel() {
        int n;
        super.registerWithModel();
        for (n = 0; n < this.portModels.length; ++n) {
            this.getObsMgr().removeObservable((Observable)((Object)this.portModels[n]));
        }
        for (n = 0; n < this.lineModels.length; ++n) {
            this.getObsMgr().removeObservable((Observable)((Object)this.lineModels[n]));
        }
        for (n = 0; n < this.lineModels.length; ++n) {
            this.getObsMgr().removeObservable((Observable)((Object)this.lineModels[n].getLayer2LineModel()));
        }
    }

    private ObservableManager getObsMgr() {
        if (this._obsMgr == null) {
            this._obsMgr = new ObservableManager((Observer)((Object)this), true);
        }
        return this._obsMgr;
    }

    protected void customizedProvPane() {
        TableColumn tableColumn = null;
        Object[] objectArray = null;
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        NumberTextField numberTextField = new NumberTextField(4);
        NumberTextField numberTextField2 = new NumberTextField(3);
        NumberTextField numberTextField3 = new NumberTextField(3);
        try {
            tableColumn = this.table.getColumn(this.dataModel.getColumnName(1));
            tableColumn.setCellEditor(new NumberRangeCellEditor(numberTextField, 64, 9700, EMC.EID_MTU_OUT_OF_RANGE));
            tableColumn = this.table.getColumn(this.dataModel.getColumnName(6));
            objectArray = this.dataModel.getGeMediaAttrs();
            JComboBox jComboBox = this.getComboBoxFor(objectArray);
            tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
            tableColumn.setPreferredWidth(120);
            tableColumn = this.table.getColumn(this.dataModel.getColumnName(7));
            tableColumn.setCellEditor(new NumberRangeCellEditor(numberTextField3, 0, 100, EMC.EID_INFO_RATE_OUT_OF_RANGE));
            tableColumn = this.table.getColumn(this.dataModel.getColumnName(9));
            objectArray = this.dataModel.getBucketAttrs();
            tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(objectArray)));
            tableColumn.setPreferredWidth(120);
            tableColumn = this.table.getColumn(this.dataModel.getColumnName(8));
            objectArray = this.dataModel.getBucketAttrs();
            tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(objectArray)));
            tableColumn.setPreferredWidth(120);
            tableColumn = this.table.getColumn(this.dataModel.getColumnName(2));
            objectArray = this.dataModel.getEtherModeAttrsOneVal();
            tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(objectArray)));
            tableColumn.setPreferredWidth(120);
            tableColumn = this.table.getColumn(this.dataModel.getColumnName(10));
            objectArray = this.dataModel.getNimAttrs();
            tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(objectArray)));
            tableColumn.setPreferredWidth(120);
            tableColumn = this.table.getColumn(this.dataModel.getColumnName(13));
            objectArray = this.dataModel.getIngressAttrs();
            tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(objectArray)));
            tableColumn.setPreferredWidth(120);
            tableColumn = this.table.getColumn(this.dataModel.getColumnName(5));
            objectArray = this.dataModel.getFlowAttrs();
            tableColumn.setCellEditor(new XPL2LineCellEditor(this.lineModels, this.dataModel, this.getComboBoxFor(objectArray), 5));
            tableColumn.setPreferredWidth(120);
            tableColumn = this.table.getColumn(this.dataModel.getColumnName(14));
            tableColumn.setCellEditor(new DefaultCellEditor(new HexTextField(4)));
            tableColumn = this.table.getColumn(this.dataModel.getColumnName(15));
            tableColumn.setCellEditor(new DefaultCellEditor(new HexTextField(4)));
            tableColumn = this.table.getColumn(this.dataModel.getColumnName(17));
            objectArray = this.dataModel.getAisActionAttrs();
            tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(objectArray)));
            tableColumn = this.table.getColumn(this.dataModel.getColumnName(18));
            objectArray = this.dataModel.getProtActionAttrs();
            tableColumn.setCellEditor(new XPL2LineCellEditor(this.lineModels, this.dataModel, this.getComboBoxFor(objectArray), 18));
            tableColumn.setPreferredWidth(120);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.table.sizeColumnsToFit(-1);
    }

    private JComboBox getComboBoxFor(Object[] objectArray) {
        JComboBox<Object> jComboBox = new JComboBox<Object>(objectArray);
        jComboBox.setEditable(false);
        return jComboBox;
    }

    public void dispose() {
        if (this._obsMgr != null) {
            this._obsMgr.reset();
        }
        super.dispose();
    }

    public void destroy() {
        if (this.dataModel != null) {
            this.dataModel.removeTableModelListener(this);
            this.dataModel.dispose();
        }
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.dataModel.isDirty()) {
            this.setDirty();
        } else {
            this.resetDirty();
        }
    }

    protected boolean queryRemainDirty() {
        return true;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setDirty();
    }

    public void applyChangesToModel() throws Exception {
        DetailedLog detailedLog = new DetailedLog(0);
        for (int i = 0; i < this.lineModels.length; ++i) {
            try {
                this.dataModel.applyToModel(i, detailedLog);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.dataModel.resetDirty();
        this.resetDirty();
        if (detailedLog.getChildCount() > 0) {
            this.dataModel.refreshFromModel();
            DetailedLogDialog detailedLogDialog = DetailedLogDialog.getMixedDetailedLogDialog((Frame)JOptionPane.getFrameForComponent(this.getParent()), (DetailedLog)detailedLog);
            detailedLogDialog.show();
        }
    }

    public void refreshFromModel() throws Exception {
        this.dataModel.refreshFromModel();
        if (this.isL2Mode != this.eqpmtModel.isInL2Mode()) {
            this.init();
        }
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.XPL2MapEtherPortProvPane;
    }

    private class NumberRangeCellEditor
    extends DefaultCellEditor {
        private int min;
        private int max;
        private EID err;

        public NumberRangeCellEditor(JTextField jTextField, int n, int n2, EID eID) {
            super(jTextField);
            this.min = n;
            this.max = n2;
            this.err = eID;
        }

        public boolean stopCellEditing() {
            JTextField jTextField = (JTextField)this.getComponent();
            boolean bl = false;
            try {
                int n = Integer.parseInt(jTextField.getText());
                if (n < this.min || n > this.max) {
                    bl = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                bl = true;
            }
            if (bl) {
                ErrorMsg.displayError((Component)XPL2MapEtherPortProvPane.this.getParent(), (EID)this.err);
                return false;
            }
            return super.stopCellEditing();
        }
    }
}

