/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.idl.Common.sIpAddr;
import cerent.cms.idl.EtherL2Media.sMcastReportInfo;
import cerent.cms.idl.Vlan.sVlanRangeInfo;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.EntityTableModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InterfaceModels;
import cerent.cms.model.IpAddrFactory;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.SVlanList;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.ui.EntityCellRenderer;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.SvlanRange;
import cerent.util.gui.SVlanListPropertyEditor;
import java.util.Observable;
import java.util.Observer;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;

public class XPL2MulticastTableModel
extends AbstractTableModel
implements Observer {
    static final SvlanRange[] RANGE_ARRAY_TEMPLATE = new SvlanRange[0];
    public static final int MCAST_IP_ADDRESS_INDEX = 0;
    public static final int VLAN_INDEX = 1;
    public static final int PORTLIST_INDEX = 2;
    private static int EBW = 2;
    static final String[] columnNames = new String[]{"MCAST IP Address", "SVLAN", "Port list"};
    private XPL2ModuleModel eqpmtModel = null;
    private int numLines = 0;
    private static EmptyBorder emptyBorder = new EmptyBorder(0, EBW, 0, EBW);
    private SVlanListPropertyEditor svlanList;
    private sMcastReportInfo[] mcastInfo;
    private EntityTableModel etm;
    protected EntityCellRenderer myPortRenderer;
    private InterfaceModels ifs;
    private static final SDebug db = new SDebug("XPL2MulticastTableModel");

    public XPL2MulticastTableModel(XPL2ModuleModel xPL2ModuleModel, SVlanListPropertyEditor sVlanListPropertyEditor) {
        this.eqpmtModel = xPL2ModuleModel;
        this.svlanList = sVlanListPropertyEditor;
        this.myPortRenderer = new EntityCellRenderer(false);
        this.refreshMyLines();
        this.etm = xPL2ModuleModel.getNodeModelDelegate().getEntityTableModel();
        this.ifs = xPL2ModuleModel.getNodeModelDelegate().getIfModels();
    }

    public void refreshMyLines() {
        this.fireTableDataChanged();
    }

    public boolean isCellEditable(int n, int n2) {
        return n2 == 2;
    }

    public boolean flowControlChanged() {
        return false;
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public String getColumnName(int n) {
        if (n >= 0 && n < columnNames.length) {
            return columnNames[n];
        }
        return null;
    }

    public int getRowCount() {
        return this.numLines;
    }

    public Object getValueAt(int n, int n2) {
        Object object;
        block7: {
            object = null;
            try {
                switch (n2) {
                    case 0: {
                        object = this.getIpAddress(this.mcastInfo[n].mcastIpAddr);
                        break;
                    }
                    case 1: {
                        object = Short.toString(this.mcastInfo[n].vlanId);
                        break;
                    }
                    case 2: {
                        object = this.getSubscribedPorts(this.mcastInfo[n].portList);
                    }
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block7;
                db.println("Error in getValueAt in XPL2SecurityTableModel " + exception);
                KDebug.printStackTrace((Throwable)exception);
            }
        }
        return object;
    }

    private String getIpAddress(sIpAddr sIpAddr2) {
        return IpAddrFactory.ipToString(IpAddrFactory.getIIpAddr(sIpAddr2));
    }

    private Object getSubscribedPorts(int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < nArray.length; ++i) {
            try {
                IPortModel iPortModel = this.ifs.getInterfaceModel(nArray[i]).getLowerLayerModels()[0].getPortModel();
                stringBuilder.append(this.myPortRenderer.getPortString((IEntityModel)iPortModel, false));
                stringBuilder.append("\n");
                continue;
            }
            catch (NoSuchInterface noSuchInterface) {
                SDebug.printStackTrace((Throwable)noSuchInterface);
                continue;
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return stringBuilder;
    }

    public void refreshLineFromModel(int n) {
        block2: {
            try {
                this.fireTableRowsUpdated(n, n);
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                KDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public void applyToModel(int n) throws Exception {
    }

    public void refreshFromModel() throws Exception {
    }

    public void update(Observable observable, Object object) {
    }

    public void reload() {
        SvlanRange[] svlanRangeArray = RANGE_ARRAY_TEMPLATE;
        SVlanList sVlanList = this.svlanList.getSVlanList();
        if (sVlanList != null) {
            svlanRangeArray = sVlanList.getRanges();
        }
        sVlanRangeInfo[] sVlanRangeInfoArray = new sVlanRangeInfo[svlanRangeArray.length];
        for (int i = 0; i < svlanRangeArray.length; ++i) {
            sVlanRangeInfo sVlanRangeInfo2 = new sVlanRangeInfo();
            sVlanRangeInfo2.minVlanId = svlanRangeArray[i].low;
            sVlanRangeInfo2.maxVlanId = svlanRangeArray[i].high;
            sVlanRangeInfoArray[i] = sVlanRangeInfo2;
        }
        try {
            this.mcastInfo = this.eqpmtModel.getVlanMultiCastInfoList(sVlanRangeInfoArray);
            this.numLines = this.mcastInfo.length;
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            SDebug.printStackTrace((Throwable)wrongInterfaceType);
        }
    }

    public void dispose() {
    }
}

