/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.idl.EtherL2Media.sMcastInfo;
import cerent.cms.model.ConfigError;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.IVlanInfo;
import cerent.cms.model.IpAddrFactory;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.InetUtil;
import cerent.util.SDebug;
import cerent.util.gui.NumberTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class XPL2MvrProvPane
extends NodeProvPane
implements ActionListener,
DocumentListener {
    private XPL2ModuleModel module = (XPL2ModuleModel)this.getUiModel();
    private JCheckBox mvrCB;
    private JLabel svlanL;
    private JLabel ipMcastL;
    private JLabel countL;
    private JComboBox svlanCB;
    private NumberTextField ipMcastTF;
    private NumberTextField countTF;
    private sMcastInfo mvrInfo = new sMcastInfo();

    public XPL2MvrProvPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        this.mvrCB = new JCheckBox("Enabled");
        this.mvrCB.addActionListener(this);
        this.svlanL = new JLabel("Multicast SVLAN: ");
        this.svlanCB = new JComboBox<Short>(new DefaultComboBoxModel<Short>(this.getSvlanListFromModule()));
        this.svlanCB.addActionListener(this);
        this.ipMcastL = new JLabel("Multicast Address: ");
        this.ipMcastTF = new NumberTextField(15, ".");
        this.ipMcastTF.setPreferredSize(new Dimension(100, 20));
        this.ipMcastTF.getDocument().addDocumentListener(this);
        this.ipMcastTF.setEditable(true);
        this.countL = new JLabel("Count: ");
        this.countTF = new NumberTextField(3);
        this.countTF.setPreferredSize(new Dimension(30, 20));
        this.countTF.getDocument().addDocumentListener(this);
        this.countTF.setEditable(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        JPanel jPanel2 = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("MVR Settings"));
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 20, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.mvrCB, gridBagConstraints);
        jPanel.add(this.mvrCB);
        gridBagConstraints.insets = new Insets(0, 2, 10, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.svlanL, gridBagConstraints);
        jPanel.add(this.svlanL);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.svlanCB, gridBagConstraints);
        jPanel.add(this.svlanCB);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.ipMcastL, gridBagConstraints);
        jPanel.add(this.ipMcastL);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 10);
        gridBagLayout.setConstraints(this.ipMcastTF, gridBagConstraints);
        jPanel.add(this.ipMcastTF);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        gridBagLayout.setConstraints(this.countL, gridBagConstraints);
        jPanel.add(this.countL);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.countTF, gridBagConstraints);
        jPanel.add(this.countTF);
        jPanel2.add(jPanel);
        this.add(jPanel2, "Center");
        this.enableComponent(this.mvrCB);
        this.enableComponent(this.svlanL);
        this.enableComponent(this.svlanCB);
        this.enableComponent(this.ipMcastL);
        this.enableComponent(this.ipMcastTF);
        this.enableComponent(this.countL);
        this.enableComponent(this.countTF);
        this.registerWithModel();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Short s;
        if (actionEvent.getSource() == this.mvrCB) {
            if (this.mvrInfo.mvrState != this.mvrCB.isSelected()) {
                this.mvrInfo.mvrState = this.mvrCB.isSelected();
                if (this.mvrCB.isSelected()) {
                    if (this.svlanCB.getSelectedItem() != null) {
                        this.mvrInfo.mvrSvlan = (Short)this.svlanCB.getSelectedItem();
                    }
                    this.mvrInfo.multicastRange = Short.parseShort(this.countTF.getText());
                    IIpAddr iIpAddr = InetUtil.makeIpAddr(this.ipMcastTF.getText());
                    this.mvrInfo.startMulticastAddr = IpAddrFactory.getIpAddr(iIpAddr);
                }
                this.setDirty();
            }
        } else if (actionEvent.getSource() == this.svlanCB && !(s = (Short)this.svlanCB.getSelectedItem()).equals(this.mvrInfo.mvrSvlan)) {
            this.mvrInfo.mvrSvlan = (Short)this.svlanCB.getSelectedItem();
            this.setDirty();
        }
    }

    public void applyChangesToModel() throws Exception {
        try {
            this.module.setMvrInfo(this.mvrInfo);
        }
        catch (Exception exception) {
            this.refreshFromModel();
            throw new ConfigError(exception.getMessage());
        }
        if (db.on()) {
            db.println("applyChangesToModel resetDirty()");
        }
        this.resetDirty();
    }

    private Short[] getSvlanListFromModule() {
        IVlanInfo[] iVlanInfoArray = this.module.getVlanDb();
        Short[] shortArray = new Short[iVlanInfoArray.length];
        for (int i = 0; i < iVlanInfoArray.length; ++i) {
            shortArray[i] = iVlanInfoArray[i].getVlanId();
        }
        return shortArray;
    }

    public void refreshFromModel() throws Exception {
        if (this.module.isPreProvisioned()) {
            return;
        }
        this.svlanCB.setModel(new DefaultComboBoxModel<Short>(this.getSvlanListFromModule()));
        this.mvrInfo = this.module.getMvrInfo();
        this.mvrCB.setSelected(this.mvrInfo.mvrState);
        IIpAddr iIpAddr = IpAddrFactory.getIIpAddr(this.mvrInfo.startMulticastAddr);
        this.ipMcastTF.setText(IpAddrFactory.ipToString(iIpAddr));
        this.svlanCB.setSelectedItem(new Short(this.mvrInfo.mvrSvlan));
        this.countTF.setText(new Short(this.mvrInfo.multicastRange).toString());
        this.resetDirty();
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.XPL2MvrProvPane;
    }

    public boolean onValidate() {
        Short s = Short.parseShort(this.countTF.getText());
        if (s < 1 || s > 256) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_MCAST_COUNT_OUT_OF_RANGE);
            this.countTF.requestFocus();
            return false;
        }
        this.mvrInfo.multicastRange = s;
        Pattern pattern = Pattern.compile(InetUtil.regEx());
        Matcher matcher = pattern.matcher(this.ipMcastTF.getText());
        if (matcher.find()) {
            try {
                IIpAddr iIpAddr = InetUtil.makeIpAddr(this.ipMcastTF.getText());
                if ((iIpAddr.getAddr()[12] & 0xF0) != 224) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_MCAST_IP_OUT_OF_RANGE);
                    this.ipMcastTF.requestFocus();
                    return false;
                }
                pattern = Pattern.compile("[0-9]{1,3}\\.[1][2][8]\\.[0]\\.[0-9]{1,3}");
                matcher = pattern.matcher(this.ipMcastTF.getText());
                if (matcher.find()) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_MCAST_IP_OUT_OF_RANGE);
                    this.ipMcastTF.requestFocus();
                    return false;
                }
                pattern = Pattern.compile("[0-9]{1,3}\\.[0]\\.[0]\\.[0-9]{1,3}");
                matcher = pattern.matcher(this.ipMcastTF.getText());
                if (matcher.find()) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_MCAST_IP_OUT_OF_RANGE);
                    this.ipMcastTF.requestFocus();
                    return false;
                }
                this.mvrInfo.startMulticastAddr = IpAddrFactory.getIpAddr(iIpAddr);
            }
            catch (Exception exception) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_MCAST_IP_OUT_OF_RANGE);
                this.ipMcastTF.requestFocus();
                return false;
            }
        } else {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_MCAST_IP_OUT_OF_RANGE);
            this.ipMcastTF.requestFocus();
            return false;
        }
        return true;
    }

    public void update(Observable observable, Object object) {
        if (db.on()) {
            db.println("update from " + observable + "arg obj is " + object);
        }
        if (object.equals(ModelUpdateType.CHANGED)) {
            this.requestRefresh(observable, this.getRefreshThread(observable));
        }
    }

    private Runnable getRefreshThread(Observable observable) {
        return new Runnable(){

            public void run() {
                try {
                    XPL2MvrProvPane.this.refreshFromModel();
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        };
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        if (db.on()) {
            db.println("Document event changedUpdate ");
        }
        this.setDirty();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (db.on()) {
            db.println("Document event insertUpdate ");
        }
        this.setDirty();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        if (db.on()) {
            db.println("Document event removeUpdate ");
        }
        this.setDirty();
    }
}

