/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.idl.Equipment.eCardOperMode;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.DwdmLineUpdate;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.TraceMode;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.ui.AbstractSubTabbedPane;
import cerent.cms.ui.CardTabbedView;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.SubTabbedView;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.dwdm.DwdmCardDualPane;
import cerent.cms.ui.dwdm.DwdmG709LineProvPane;
import cerent.cms.ui.dwdm.DwdmLinePane;
import cerent.cms.ui.dwdm.FECThresholdPane;
import cerent.cms.ui.dwdm.OpticalThresholdPane;
import cerent.cms.ui.dwdm.OtnThresholdPane;
import cerent.cms.ui.ppm.PpmProvPane;
import cerent.cms.ui.rmon.RmonThresholdPane;
import cerent.cms.ui.trace.GenericTraceProvPane;
import cerent.cms.ui.xpl2.XPL2CardProvPane;
import cerent.cms.ui.xpl2.XPL2EtherPdhProvPane;
import cerent.cms.ui.xpl2.XPL2MapEtherPortProvPane;
import cerent.cms.ui.xpl2.XPL2MvrProvPane;
import cerent.cms.ui.xpl2.XPL2PdhTabbedProvPane;
import cerent.cms.ui.xpl2.XPL2ProtectionProvPane;
import cerent.cms.ui.xpl2.XPL2QinQProvPane;
import cerent.cms.ui.xpl2.XPL2QoSProvPane;
import cerent.cms.ui.xpl2.XPL2SecurityProvPane;
import cerent.cms.ui.xpl2.XPL2SvlanProfileMappingProvPane;
import cerent.cms.ui.xpl2.XPL2SvlanTabbedProvPane;
import java.awt.Component;
import java.util.Observable;
import java.util.Observer;

public class XPL2ProvPane
extends NodeProvPane {
    private static final String OTN_LINE_PROV_TAB = "OTN Lines";
    private XPL2ModuleModel moduleModel;

    public XPL2ProvPane(String string, TabbedView tabbedView, XPL2ModuleModel xPL2ModuleModel) {
        super(string, tabbedView);
        this.moduleModel = xPL2ModuleModel;
        this.subTabs = new SubTabbedView(xPL2ModuleModel, tabbedView);
        this.subTabs.addTab("Ether Ports", (Component)this.getEtherPortsTab(this.subTabs));
        this.subTabs.addTab("Protection", (Component)((Object)new XPL2ProtectionProvPane("Protection", this.getParentView(), xPL2ModuleModel)));
        this.subTabs.addTab("SVLAN", (Component)((Object)new XPL2SvlanTabbedProvPane("SVLAN", this.getParentView(), xPL2ModuleModel)));
        this.subTabs.addTab("Profiles Mapping", (Component)((Object)new XPL2SvlanProfileMappingProvPane("Profiles Mapping", this.getParentView(), xPL2ModuleModel)));
        this.subTabs.addTab("QoS", (Component)((Object)new XPL2QoSProvPane("QoS", this.getParentView(), xPL2ModuleModel)));
        this.subTabs.addTab("QinQ", (Component)((Object)new XPL2QinQProvPane("QinQ", this.getParentView(), xPL2ModuleModel, 0, 0, null)));
        this.subTabs.addTab("MVR", (Component)((Object)new XPL2MvrProvPane("MVR", this.subTabs)));
        this.subTabs.addTab("Security", (Component)this.getSecurityProvTab(this.subTabs));
        this.subTabs.addTab("Optics Thresholds", (Component)((Object)new OpticalThresholdPane("Optics Thresholds", this.getParentView(), xPL2ModuleModel)));
        this.subTabs.addTab("RMON Thresholds", (Component)((Object)new RmonThresholdPane("RMON Thresholds", this.getParentView(), xPL2ModuleModel.getRmonModels())));
        this.subTabs.addTab("OTN", (Component)this.getOTNProvTab(this.subTabs));
        this.subTabs.addTab("Pluggable Port Modules", (Component)((Object)new PpmProvPane("Pluggable Port Modules", this.subTabs, false)));
        this.subTabs.addTab("Card", (Component)((Object)new XPL2CardProvPane("Card", this.subTabs)));
        this.subTabs.addTab("Alarm Profiles", (Component)CardTabbedView.getCardProvAlarmsPane(this.subTabs, false));
        this.subTabs.setTabPlacement(2);
        this.add((Component)this.subTabs);
    }

    public void enteringPage() throws Exception {
        this.moduleModel.addObserver((Observer)((Object)this));
        this.disableL2Tabs();
    }

    public void leavingPage() throws Exception {
        this.moduleModel.deleteObserver((Observer)((Object)this));
    }

    private Pane getOTNProvTab(TabbedView tabbedView) {
        return new AbstractSubTabbedPane("OTN", tabbedView){
            private boolean panesBuilt;
            private Pane otnLineTab;
            private Pane g709ThrTab;
            private Pane fecThrTab;
            private Pane ttiPane;
            private DwdmTrkLineModel[] _trunkModels;
            private DwdmModuleModel mm;
            {
                this.panesBuilt = false;
            }

            public void createSubTabs() {
                this.mm = (DwdmModuleModel)this.getUiModel();
                this._trunkModels = this.mm.getDwdmTrkLineModels();
                if (!this.panesBuilt) {
                    if (((EntityModel)this.getUiModel()).getDescendantsOfEqType(279).isEmpty()) {
                        this.otnLineTab = this.getOTNLineTab(this._trunkModels);
                    } else {
                        AbstractDwdmLineModel[] abstractDwdmLineModelArray = this.mm.getDwdmLineModels();
                        this.otnLineTab = this.getOTNLineTab(abstractDwdmLineModelArray);
                    }
                    this.g709ThrTab = this.getOtnThresholdsTab(this._trunkModels);
                    this.fecThrTab = this.getFECThresholdsTab(this._trunkModels);
                    this.ttiPane = this.getTTITab(this._trunkModels);
                    this.panesBuilt = true;
                }
                this.setupTabs();
                if (this.mm.hasPluggableTrunk()) {
                    if (db.on()) {
                        db.println("Registering for pluggable trunk line update");
                    }
                    this.registerWithModel();
                }
            }

            private void setupTabs() {
                this.subTabs.addTab(XPL2ProvPane.OTN_LINE_PROV_TAB, (Component)this.otnLineTab);
                this.subTabs.addTab("ITU-T G.709 Thresholds", (Component)this.g709ThrTab);
                this.subTabs.addTab("FEC Thresholds", (Component)this.fecThrTab);
                if (this._trunkModels.length > 0) {
                    this.subTabs.addTab("Trail Trace Identifier", (Component)this.ttiPane);
                }
            }

            private Pane getOTNLineTab(AbstractDwdmLineModel[] abstractDwdmLineModelArray) {
                return new DwdmG709LineProvPane(XPL2ProvPane.OTN_LINE_PROV_TAB, this.subTabs, abstractDwdmLineModelArray);
            }

            private Pane getOtnThresholdsTab(DwdmTrkLineModel[] dwdmTrkLineModelArray) {
                return new DwdmCardDualPane(this.subTabs, dwdmTrkLineModelArray, new OtnThresholdPane("ITU-T G.709 Thresholds", this.subTabs, dwdmTrkLineModelArray), 4);
            }

            private Pane getFECThresholdsTab(DwdmTrkLineModel[] dwdmTrkLineModelArray) {
                return new DwdmCardDualPane(this.subTabs, dwdmTrkLineModelArray, new FECThresholdPane("FEC Thresholds", this.subTabs, dwdmTrkLineModelArray), 4);
            }

            private Pane getTTITab(DwdmTrkLineModel[] dwdmTrkLineModelArray) {
                return new GenericTraceProvPane("Trail Trace Identifier", this.subTabs, TraceMode.TTI, dwdmTrkLineModelArray, 1);
            }

            protected void refreshMyLines(Object object) {
                DwdmLineUpdate dwdmLineUpdate;
                DwdmTrkLineModel[] dwdmTrkLineModelArray;
                if (object instanceof DwdmLineUpdate && (dwdmTrkLineModelArray = this.mm.removeIlkTrkLineModels((dwdmLineUpdate = (DwdmLineUpdate)object).getDwdmTrkLineModels())).length != this._trunkModels.length) {
                    if (db.on()) {
                        db.println("Refreshing " + this.getFullName() + " pm subtabs for change in trunk number, from " + this._trunkModels.length + " to " + dwdmTrkLineModelArray.length);
                    }
                    this._trunkModels = dwdmTrkLineModelArray;
                    this.subTabs.removeAll();
                    this.setupTabs();
                }
            }
        };
    }

    private Pane getEtherPortsTab(TabbedView tabbedView) {
        return new AbstractSubTabbedPane("Ether Ports", tabbedView){

            public void createSubTabs() {
                XPL2ModuleModel xPL2ModuleModel = (XPL2ModuleModel)this.getUiModel();
                this.subTabs.addTab("Ports", (Component)((Object)new DwdmLinePane("Unframed", this.subTabs, xPL2ModuleModel.getDwdmLineModels(), DwdmLinePane.PaneType.PLUGGABLES)));
                this.subTabs.addTab("Ethernet", (Component)((Object)new XPL2MapEtherPortProvPane("Ethernet", this.getParentView(), xPL2ModuleModel)));
                if (xPL2ModuleModel.getEqType() == 272) {
                    this.subTabs.addTab("PDH Ethernet Parameters", (Component)((Object)new XPL2EtherPdhProvPane("PDH Ethernet Parameters", this.getParentView(), xPL2ModuleModel)));
                    this.subTabs.addTab("Electrical Lines", (Component)((Object)new XPL2PdhTabbedProvPane("Electrical Lines", this.getParentView(), xPL2ModuleModel)));
                }
            }
        };
    }

    private Pane getSecurityProvTab(TabbedView tabbedView) {
        return new AbstractSubTabbedPane("Security", tabbedView){

            public void createSubTabs() {
                this.subTabs.addTab("MAC Filter ", (Component)((Object)new XPL2SecurityProvPane("MAC Filter ", this.subTabs)));
            }
        };
    }

    public boolean hasSubTabs() {
        return true;
    }

    public void disableL2Tabs() {
        DwdmModuleModel dwdmModuleModel = (DwdmModuleModel)this.getUiModel();
        eCardOperMode eCardOperMode2 = dwdmModuleModel.getCardOperMode();
        if (eCardOperMode2 == eCardOperMode.OPER_MODE_10GEXP_TXP_L2_SWITCH || eCardOperMode2 == eCardOperMode.OPER_MODE_GEXP_MXP_L2_SWITCH) {
            this.setTabEnabled(true);
        } else {
            this.setTabEnabled(false);
            int n = this.subTabs.getSelectedIndex();
            if (n > 0 && n < 6) {
                this.subTabs.setSelectedIndex(this.subTabs.indexOfTab("Ether Ports"));
            }
        }
    }

    public void setTabEnabled(boolean bl) {
        this.subTabs.setEnabledAt(this.subTabs.indexOfTab("Protection"), bl);
        this.subTabs.setEnabledAt(this.subTabs.indexOfTab("SVLAN"), bl);
        this.subTabs.setEnabledAt(this.subTabs.indexOfTab("Profiles Mapping"), bl);
        this.subTabs.setEnabledAt(this.subTabs.indexOfTab("QoS"), bl);
        this.subTabs.setEnabledAt(this.subTabs.indexOfTab("QinQ"), bl);
        this.subTabs.setEnabledAt(this.subTabs.indexOfTab("MVR"), bl);
        this.subTabs.setEnabledAt(this.subTabs.indexOfTab("Security"), bl);
    }

    public void update(Observable observable, Object object) {
        Integer n;
        super.update(observable, object);
        if (observable instanceof XPL2ModuleModel && (n = (Integer)object).equals(ModelUpdateType.CHANGED)) {
            this.disableL2Tabs();
        }
    }
}

