/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.idl.EtherL2Media.eVlanOperator;
import cerent.cms.idl.EtherL2Media.sCVlanRange;
import cerent.cms.idl.EtherL2Media.sVlanCrossInfoData;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.IVlanInfo;
import cerent.cms.model.IXPL2QinQSvlanTableModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.XPL2Layer2LineModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.xpl2.OPERMODE;
import cerent.cms.ui.xpl2.QINQRULESTATUS;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.WID;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPL2QinQSvlanTableModel
extends AbstractTableModel
implements Observer,
IXPL2QinQSvlanTableModel {
    public static final int CVLAN_INDEX = 0;
    public static final int SVLAN_INDEX = 1;
    public static final int MODE_INDEX = 2;
    public static final int ISVLAN_INDEX = 3;
    public static final int COS_INDEX = 4;
    static final String[] columnNames = new String[]{"CVLAN", "SVLAN", "Operation", "Inner SVLAN", "COS"};
    private Frame frame;
    private boolean fromNet = false;
    protected XPL2Layer2LineModel layer2LineModel = null;
    protected ArrayList<VlanCrossInfoData> vlanCrossInfoList = new ArrayList();
    protected ArrayList<VlanCrossInfoData> vlanCrossInfoDeleted = new ArrayList();
    private boolean isDirty = false;
    private static final int MAX_CVLAN_ID = 4095;
    private static final SDebug db = new SDebug("XPL2QinQModeTableModel");

    public XPL2QinQSvlanTableModel(Container container, boolean bl) {
        this.frame = JOptionPane.getFrameForComponent(container);
        this.fromNet = bl;
    }

    protected void updateModel(XPL2Layer2LineModel xPL2Layer2LineModel) {
        Object object;
        sVlanCrossInfoData[] sVlanCrossInfoDataArray;
        this.layer2LineModel = xPL2Layer2LineModel;
        if (this.fromNet) {
            sVlanCrossInfoDataArray = this.vlanCrossInfoList.iterator();
            while (sVlanCrossInfoDataArray.hasNext()) {
                object = sVlanCrossInfoDataArray.next();
                if (((VlanCrossInfoData)object).isFromNet()) continue;
                sVlanCrossInfoDataArray.remove();
            }
        } else {
            this.vlanCrossInfoList.clear();
            this.vlanCrossInfoDeleted.clear();
        }
        try {
            sVlanCrossInfoDataArray = xPL2Layer2LineModel.getVlanCrossInfoList();
            object = null;
            sVlanCrossInfoData sVlanCrossInfoData2 = null;
            for (int i = 0; i < sVlanCrossInfoDataArray.length; ++i) {
                object = sVlanCrossInfoDataArray[i];
                sVlanCrossInfoData2 = new sVlanCrossInfoData(new sCVlanRange(((sVlanCrossInfoData)object).cVlan.first, ((sVlanCrossInfoData)object).cVlan.last), ((sVlanCrossInfoData)object).sVlan, eVlanOperator.from_int(((sVlanCrossInfoData)object).rule.value()), ((sVlanCrossInfoData)object).multiPurposeVlan, ((sVlanCrossInfoData)object).ingressCOS, ((sVlanCrossInfoData)object).policyId);
                this.vlanCrossInfoList.add(i, new VlanCrossInfoData(sVlanCrossInfoData2, QINQRULESTATUS.FROM_MODEL));
            }
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            SDebug.printStackTrace((Throwable)abstractCmsIOException);
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            SDebug.printStackTrace((Throwable)wrongInterfaceType);
        }
        this.resetDirty();
        this.fireTableDataChanged();
    }

    protected void clearSvlanCrossInfoList() {
        this.vlanCrossInfoList.clear();
        this.vlanCrossInfoDeleted.clear();
    }

    public boolean hasSvlanEntryFromNet() {
        for (int i = 0; i < this.vlanCrossInfoList.size(); ++i) {
            if (!this.vlanCrossInfoList.get(i).isFromNet()) continue;
            return true;
        }
        return false;
    }

    public boolean hasSvlanEntryOnlyFromNet() {
        for (VlanCrossInfoData vlanCrossInfoData : this.vlanCrossInfoList) {
            if (vlanCrossInfoData.isFromNet()) continue;
            return false;
        }
        return true;
    }

    public boolean isVlanCrossInfoListUpdated() {
        if (this.vlanCrossInfoDeleted.size() > 0) {
            return true;
        }
        for (VlanCrossInfoData vlanCrossInfoData : this.vlanCrossInfoList) {
            if (!QINQRULESTATUS.UPDATED.equals(vlanCrossInfoData.status)) continue;
            return true;
        }
        return false;
    }

    public sVlanCrossInfoData[] getVlanCrossInfoList() {
        sVlanCrossInfoData[] sVlanCrossInfoDataArray = new sVlanCrossInfoData[this.vlanCrossInfoList.size()];
        for (int i = 0; i < this.vlanCrossInfoList.size(); ++i) {
            sVlanCrossInfoDataArray[i] = this.vlanCrossInfoList.get(i).getVlanCrossInfoData();
        }
        return sVlanCrossInfoDataArray;
    }

    public void addRow(short s) {
        sCVlanRange sCVlanRange2 = new sCVlanRange(0, 0);
        sVlanCrossInfoData sVlanCrossInfoData2 = new sVlanCrossInfoData(sCVlanRange2, s, eVlanOperator.VLAN_ADD, s, 0, 0);
        if (this.fromNet) {
            this.vlanCrossInfoList.add(new VlanCrossInfoData(sVlanCrossInfoData2, QINQRULESTATUS.FROM_NET));
        } else {
            this.vlanCrossInfoList.add(new VlanCrossInfoData(sVlanCrossInfoData2, QINQRULESTATUS.NEW));
        }
        this.setDirty();
        this.fireTableDataChanged();
    }

    public void addRows(short s, short s2, short s3) {
        sCVlanRange sCVlanRange2 = new sCVlanRange(0, 0);
        for (short s4 = s2; s4 <= s3; s4 = (short)(s4 + 1)) {
            sCVlanRange2 = new sCVlanRange(s4, s4);
            sVlanCrossInfoData sVlanCrossInfoData2 = new sVlanCrossInfoData(sCVlanRange2, s, eVlanOperator.VLAN_ADD, s, 0, 0);
            if (this.fromNet) {
                this.vlanCrossInfoList.add(new VlanCrossInfoData(sVlanCrossInfoData2, QINQRULESTATUS.FROM_NET));
                continue;
            }
            this.vlanCrossInfoList.add(new VlanCrossInfoData(sVlanCrossInfoData2, QINQRULESTATUS.NEW));
        }
        this.setDirty();
        this.fireTableDataChanged();
    }

    public void removeRows(int[] nArray) {
        boolean bl = false;
        ArrayList<VlanCrossInfoData> arrayList = new ArrayList<VlanCrossInfoData>();
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(this.vlanCrossInfoList.get(nArray[i]));
        }
        for (VlanCrossInfoData vlanCrossInfoData : arrayList) {
            if (this.fromNet) {
                if (vlanCrossInfoData.isFromNet()) {
                    this.vlanCrossInfoList.remove(vlanCrossInfoData);
                    continue;
                }
                bl = true;
                continue;
            }
            this.vlanCrossInfoList.remove(vlanCrossInfoData);
            if (!vlanCrossInfoData.status.equals(QINQRULESTATUS.FROM_MODEL)) continue;
            vlanCrossInfoData.setStatus(QINQRULESTATUS.DELETED);
            this.vlanCrossInfoDeleted.add(vlanCrossInfoData);
        }
        arrayList.clear();
        arrayList = null;
        this.setDirty();
        this.fireTableDataChanged();
        if (bl) {
            ErrorMsg.displayWarning((Component)this.frame, (WID)EMC.WID_QINQ_REMOVE_DENY_FROM_NET);
        }
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (AbstractPane.isUserAuthorized(this.layer2LineModel, SecurityLevel.PROVISIONING)) {
            if (this.fromNet && !this.vlanCrossInfoList.get(n).isFromNet()) {
                return false;
            }
            if (n2 == 1 && this.fromNet) {
                return false;
            }
            return !(n2 == 3 ? this.getValueAt(n, 2).equals(OPERMODE.ADD.getName()) || this.getValueAt(n, 2).equals(OPERMODE.TRANSLATE.getName()) : n2 == 0 && this.getValueAt(n, 2).equals(OPERMODE.DOUBLE_ADD.getName()));
        }
        return false;
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        if (n >= 0 && n < columnNames.length) {
            return columnNames[n];
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this.vlanCrossInfoList.size();
    }

    @Override
    public Class<?> getColumnClass(int n) {
        switch (n) {
            case 0: {
                return String.class;
            }
            case 1: 
            case 3: {
                return Short.class;
            }
        }
        return String.class;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        block11: {
            try {
                sVlanCrossInfoData sVlanCrossInfoData2 = this.vlanCrossInfoList.get(n).getVlanCrossInfoData();
                switch (n2) {
                    case 0: {
                        if (sVlanCrossInfoData2.cVlan.first == sVlanCrossInfoData2.cVlan.last) {
                            return new String("" + sVlanCrossInfoData2.cVlan.first);
                        }
                        return new String(sVlanCrossInfoData2.cVlan.first + "-" + sVlanCrossInfoData2.cVlan.last);
                    }
                    case 1: {
                        return new Short(sVlanCrossInfoData2.sVlan);
                    }
                    case 2: {
                        return this.getRuleInString(sVlanCrossInfoData2.rule.value());
                    }
                    case 3: {
                        if (this.getValueAt(n, 2).equals(OPERMODE.ADD.getName()) || this.getValueAt(n, 2).equals(OPERMODE.TRANSLATE.getName())) {
                            return new Short(0);
                        }
                        return new Short(sVlanCrossInfoData2.multiPurposeVlan);
                    }
                    case 4: {
                        return new Short(sVlanCrossInfoData2.ingressCOS);
                    }
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block11;
                db.println("Error in getValueAt in XPL2QinQModeTableModel " + exception);
                KDebug.printStackTrace((Throwable)exception);
            }
        }
        return null;
    }

    private String getRuleInString(int n) {
        if (n == 0) {
            return OPERMODE.ADD.getName();
        }
        if (n == 1) {
            return OPERMODE.TRANSLATE.getName();
        }
        if (n == 3) {
            return OPERMODE.DOUBLE_ADD.getName();
        }
        return OPERMODE.TRANSLATE_ADD.getName();
    }

    private eVlanOperator getRuleStringInVlanOperator(String string) {
        if (string.equals(OPERMODE.ADD.getName())) {
            return eVlanOperator.VLAN_ADD;
        }
        if (string.equals(OPERMODE.TRANSLATE.getName())) {
            return eVlanOperator.VLAN_XLTE;
        }
        if (string.equals(OPERMODE.DOUBLE_ADD.getName())) {
            return eVlanOperator.VLAN_DOUBLE_ADD;
        }
        return eVlanOperator.VLAN_XLTE_AND_ADD;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        block11: {
            try {
                VlanCrossInfoData vlanCrossInfoData = this.vlanCrossInfoList.get(n);
                if (vlanCrossInfoData.status.equals(QINQRULESTATUS.FROM_MODEL)) {
                    vlanCrossInfoData.setStatus(QINQRULESTATUS.UPDATED);
                }
                sVlanCrossInfoData sVlanCrossInfoData2 = this.vlanCrossInfoList.get(n).getVlanCrossInfoData();
                switch (n2) {
                    case 0: {
                        String string = (String)object;
                        this.checkCVlanValue(string, sVlanCrossInfoData2.cVlan);
                        break;
                    }
                    case 1: {
                        sVlanCrossInfoData2.sVlan = ((IVlanInfo)object).getVlanId();
                        break;
                    }
                    case 2: {
                        sVlanCrossInfoData2.rule = this.getRuleStringInVlanOperator((String)object);
                        if (sVlanCrossInfoData2.rule == eVlanOperator.VLAN_DOUBLE_ADD) {
                            this.checkCVlanValue("0", sVlanCrossInfoData2.cVlan);
                        }
                        this.fireTableCellUpdated(n, 3);
                        this.fireTableCellUpdated(n, 0);
                        break;
                    }
                    case 3: {
                        sVlanCrossInfoData2.multiPurposeVlan = ((IVlanInfo)object).getVlanId();
                        break;
                    }
                    case 4: {
                        sVlanCrossInfoData2.ingressCOS = (Short)object;
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block11;
                db.println("Error in setValueAt in XPL2QinQModeTableModel " + exception);
                KDebug.printStackTrace((Throwable)exception);
            }
        }
        this.setDirty();
        this.fireTableCellUpdated(n, n2);
    }

    private void checkCVlanValue(String string, sCVlanRange sCVlanRange2) {
        block6: {
            if (string.matches("[0-9]{1,4}")) {
                try {
                    short s = Short.valueOf(string);
                    if (this.checkCVlanValue(s)) {
                        sCVlanRange2.first = s;
                        sCVlanRange2.last = s;
                        break block6;
                    }
                    ErrorMsg.displayError((Component)this.frame, (EID)EMC.EID_ERROR_PROVISIONING_CVLAN_ID);
                }
                catch (Exception exception) {
                    KDebug.printStackTrace((Throwable)exception);
                }
            } else if (this.checkCVlanRange(string, sCVlanRange2)) {
                // empty if block
            }
        }
    }

    protected boolean checkCVlanRange(String string, sCVlanRange sCVlanRange2) {
        block6: {
            if (string.matches("[0-9]{1,4}-[0-9]{1,4}")) {
                String[] stringArray = string.split("-");
                try {
                    short s = Short.valueOf(stringArray[0]);
                    short s2 = Short.valueOf(stringArray[1]);
                    if (this.checkCVlanValue(s) && this.checkCVlanValue(s2)) {
                        if (s < s2) {
                            sCVlanRange2.first = s;
                            sCVlanRange2.last = s2;
                            return true;
                        }
                        ErrorMsg.displayError((Component)this.frame, (EID)EMC.EID_ERROR_PROVISIONING_CVLAN_ID);
                        break block6;
                    }
                    ErrorMsg.displayError((Component)this.frame, (EID)EMC.EID_ERROR_PROVISIONING_CVLAN_ID);
                }
                catch (Exception exception) {
                    KDebug.printStackTrace((Throwable)exception);
                }
            } else {
                ErrorMsg.displayError((Component)this.frame, (EID)EMC.EID_ERROR_PROVISIONING_CVLAN_ID);
            }
        }
        return false;
    }

    private boolean checkCVlanValue(short s) {
        return s >= 0 && s < 4095;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void resetDirty() {
        this.isDirty = false;
    }

    public void setDirty() {
        this.isDirty = true;
    }

    protected Frame getFrame() {
        return this.layer2LineModel.getNodeModel().getUiToolkit().getApplicationFrame();
    }

    public void dispose() {
        this.vlanCrossInfoList.clear();
        this.vlanCrossInfoDeleted.clear();
    }

    @Override
    public void update(Observable observable, Object object) {
    }

    class VlanCrossInfoData {
        private sVlanCrossInfoData data;
        private QINQRULESTATUS status;

        public VlanCrossInfoData(sVlanCrossInfoData sVlanCrossInfoData2, QINQRULESTATUS qINQRULESTATUS) {
            this.data = sVlanCrossInfoData2;
            this.status = qINQRULESTATUS;
        }

        public sVlanCrossInfoData getVlanCrossInfoData() {
            return this.data;
        }

        public boolean isFromNet() {
            return this.status.equals(QINQRULESTATUS.FROM_NET);
        }

        public void setStatus(QINQRULESTATUS qINQRULESTATUS) {
            this.status = qINQRULESTATUS;
        }
    }
}

