/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.idl.EtherL2Media.sEgressInfo;
import cerent.cms.idl.EtherL2Media.sEgressQOSInfo;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.ui.AbstractPane;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.util.Observable;
import java.util.Observer;
import javax.swing.table.AbstractTableModel;

public class XPL2QoSTableModel
extends AbstractTableModel
implements Observer {
    public static final int COS_INDEX = 0;
    public static final int WEIGHT_INDEX = 1;
    public static final int BANDWIDTH_INDEX = 2;
    static final String[] columnNames = new String[]{"COS", "WRR weight", "Bandwidth"};
    public static final int NUMBER_OF_LINE = 8;
    private sEgressInfo egressInfoList = null;
    private boolean[][] isDirty = null;
    private int numLines = 0;
    private String[] portNames;
    private XPL2ModuleModel eqpmtModel;
    private static final SDebug db = new SDebug("XPL2QoSTableModel");

    public XPL2QoSTableModel(XPL2ModuleModel xPL2ModuleModel, sEgressInfo sEgressInfo2) {
        this.eqpmtModel = xPL2ModuleModel;
        this.updateEgressInfo(sEgressInfo2);
    }

    public sEgressInfo getEgressInfo() {
        return this.egressInfoList;
    }

    public void updateEgressInfo(sEgressInfo sEgressInfo2) {
        this.numLines = 8;
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
        this.egressInfoList = new sEgressInfo();
        if (sEgressInfo2 != null) {
            this.egressInfoList.egressQOSState = sEgressInfo2.egressQOSState;
            this.egressInfoList.egressQOSInfoTable = new sEgressQOSInfo[sEgressInfo2.egressQOSInfoTable.length];
            for (int i = 0; i < sEgressInfo2.egressQOSInfoTable.length; ++i) {
                this.egressInfoList.egressQOSInfoTable[i] = new sEgressQOSInfo(sEgressInfo2.egressQOSInfoTable[i].bandwidth, sEgressInfo2.egressQOSInfoTable[i].weight);
            }
        }
        this.resetDirty();
        this.fireTableDataChanged();
    }

    public boolean isCellEditable(int n, int n2) {
        if (AbstractPane.isUserAuthorized(this.eqpmtModel, SecurityLevel.PROVISIONING)) {
            return n2 != 0 && this.egressInfoList.egressQOSInfoTable != null;
        }
        return false;
    }

    public boolean flowControlChanged() {
        return false;
    }

    public boolean isCellDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public String getColumnName(int n) {
        if (n >= 0 && n < columnNames.length) {
            return columnNames[n];
        }
        return null;
    }

    public int getRowCount() {
        return this.numLines;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            default: 
        }
        return Object.class;
    }

    public Object getValueAt(int n, int n2) {
        block7: {
            try {
                switch (n2) {
                    case 0: {
                        return n;
                    }
                    case 1: {
                        return new Short(this.egressInfoList.egressQOSInfoTable[n].weight);
                    }
                    case 2: {
                        return new Short(this.egressInfoList.egressQOSInfoTable[n].bandwidth);
                    }
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block7;
                db.println("Error in getValueAt in XPL2QoSTableModel " + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return null;
    }

    public void setValueAt(Object object, int n, int n2) {
        block7: {
            try {
                switch (n2) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        short s = Short.parseShort(object.toString());
                        if (s < 0 || s > 15) break;
                        this.egressInfoList.egressQOSInfoTable[n].weight = s;
                        break;
                    }
                    case 2: {
                        short s = Short.parseShort(object.toString());
                        if (s < 0 || s > 100) break;
                        this.egressInfoList.egressQOSInfoTable[n].bandwidth = s;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                this.isDirty[n][n2] = true;
                this.fireTableCellUpdated(n, n2);
            }
            catch (Exception exception) {
                if (!db.on()) break block7;
                db.println("Error in setValueAt in XPL2QoSTableModel " + exception);
                KDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public boolean isDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                if (!this.isDirty[i][j]) continue;
                return true;
            }
        }
        return false;
    }

    public void resetDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    public void refreshLineFromModel(int n) {
        block2: {
            try {
                this.resetLineCache(n);
                this.fireTableRowsUpdated(n, n);
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public void refreshFromModel() throws Exception {
        for (int i = 0; i < this.numLines; ++i) {
            this.resetLineCache(i);
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    protected void resetLineCache(int n) throws Exception {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.isDirty[n][i] = false;
        }
    }

    public void update(Observable observable, Object object) {
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED) && db.on()) {
            db.println("Got an Update Message for " + observable);
        }
    }
}

