/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.model.XPL2LineModel;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.xpl2.XPL2MacFilterTableModel;
import cerent.cms.ui.xpl2.XPL2SecurityMacAdrressFilterDialog;
import cerent.cms.ui.xpl2.XPL2SecurityTableModel;
import cerent.util.ObservableManager;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class XPL2SecurityProvPane
extends NodeProvPane
implements ITabName,
ActionListener,
TableModelListener {
    protected XPL2SecurityTableModel dataModel = null;
    protected XPL2MacFilterTableModel tabModel = null;
    protected XPL2ModuleModel eqpmtModel = (XPL2ModuleModel)this.getUiModel();
    protected XPL2LineModel[] lineModels = this.eqpmtModel.getXPL2EtherLines();
    private JButton retrieveButton = null;
    private ObservableManager _obsMgr;

    public XPL2SecurityProvPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.dataModel = new XPL2SecurityTableModel(this.eqpmtModel, this.lineModels);
        this.table = new UTable((TableModel)this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.dataModel.addTableModelListener(this);
        this.customizedProvPane();
        this.add((Component)uScrollPane);
        JPanel jPanel = XPL2SecurityProvPane.createVerticalPanel(null);
        jPanel.add(this.makeControlPanel());
        this.add(jPanel, "South");
        this.add((Component)uScrollPane, "Center");
    }

    public void enteringPage() throws Exception {
        super.enteringPage();
        if (db.on()) {
            db.println("calling enteringPage");
        }
        this.getObsMgr().setPassing(true);
        this.registerWithModel();
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        if (db.on()) {
            db.println("calling leavingPage");
        }
        super.leavingPage();
        this.getObsMgr().setPassing(false);
        this.unRegisterWithModel();
    }

    public void refreshMyLines(Object object) {
        this.lineModels = this.eqpmtModel.getXPL2EtherLines();
        this.dataModel.refreshMyLines(this.lineModels);
    }

    private JPanel makeControlPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = XPL2SecurityProvPane.createHorizontalPanel(null);
        this.retrieveButton = new JButton("Edit");
        this.retrieveButton.addActionListener(this);
        jPanel2.add(Box.createHorizontalStrut(10));
        jPanel2.add(this.retrieveButton);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        jPanel.add((Component)jPanel2, "West");
        return jPanel;
    }

    protected void customizedProvPane() {
        TableColumn tableColumn = null;
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(0));
        tableColumn.setPreferredWidth(100);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(1));
        tableColumn.setPreferredWidth(200);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(2));
        tableColumn.setPreferredWidth(100);
    }

    public void applyChangesToModel() throws Exception {
        for (int i = 0; i < this.lineModels.length; ++i) {
            this.dataModel.applyToModel(i);
        }
        this.resetDirty();
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.dataModel.isDirty()) {
            this.setDirty();
        } else {
            this.resetDirty();
        }
    }

    public void refreshFromModel() throws Exception {
        this.dataModel.refreshFromModel();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.retrieveButton) {
            XPL2SecurityMacAdrressFilterDialog xPL2SecurityMacAdrressFilterDialog = new XPL2SecurityMacAdrressFilterDialog(JOptionPane.getFrameForComponent((Component)((Object)this)), this.eqpmtModel, this.dataModel.getMacTable(this.table.getSelectedRow()));
            this.dataModel.updateMacTable(xPL2SecurityMacAdrressFilterDialog.getMacTable(), this.table.getSelectedRow());
        }
    }

    protected void registerWithModel() {
        int n;
        super.registerWithModel();
        this.getObsMgr().addObservable((Observable)((Object)this.eqpmtModel));
        for (n = 0; n < this.lineModels.length; ++n) {
            this.getObsMgr().addObservable((Observable)((Object)this.lineModels[n]));
        }
        for (n = 0; n < this.lineModels.length; ++n) {
            this.getObsMgr().addObservable((Observable)((Object)this.lineModels[n].getLayer2LineModel()));
        }
    }

    protected void unRegisterWithModel() {
        int n;
        super.registerWithModel();
        this.getObsMgr().removeObservable((Observable)((Object)this.eqpmtModel));
        for (n = 0; n < this.lineModels.length; ++n) {
            this.getObsMgr().removeObservable((Observable)((Object)this.lineModels[n]));
        }
        for (n = 0; n < this.lineModels.length; ++n) {
            this.getObsMgr().removeObservable((Observable)((Object)this.lineModels[n].getLayer2LineModel()));
        }
    }

    private ObservableManager getObsMgr() {
        if (this._obsMgr == null) {
            this._obsMgr = new ObservableManager((Observer)((Object)this), true);
        }
        return this._obsMgr;
    }

    public void dispose() {
        if (this._obsMgr != null) {
            this._obsMgr.reset();
        }
        super.dispose();
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.XPL2SecurityProvPane;
    }
}

