/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.xpl2;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IVlanInfo;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.PortModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.XPL2LineModel;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.EntityCellRenderer;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPL2SvlanTableModel
extends AbstractTableModel
implements Observer {
    public static final int SVLAN_INDEX = 0;
    private String[] columnNames;
    private XPL2ModuleModel eqpmtModel = null;
    private XPL2LineModel[] lineModels = null;
    private boolean[][] isDirty = null;
    private boolean[][] isRemoved = null;
    private int numRows = 0;
    private ArrayList<IVlanInfo> vlanDB;
    private ArrayList<short[]> vlanListCols;
    private static final SDebug db = new SDebug("XPL2SvlantableModel");

    public XPL2SvlanTableModel(XPL2ModuleModel xPL2ModuleModel, PortModel[] portModelArray, XPL2LineModel[] xPL2LineModelArray) {
        if (xPL2ModuleModel == null || portModelArray == null || xPL2LineModelArray == null) {
            if (db.on()) {
                db.println("Error during initialization");
                db.println("eqpmtModel=" + xPL2ModuleModel + " portModels=" + portModelArray + " lineModels=" + this.lineModels);
            }
            return;
        }
        this.eqpmtModel = xPL2ModuleModel;
        this.lineModels = xPL2LineModelArray;
        this.initVlanDB();
        this.registerWithLineModels();
    }

    private void initVlanDB() {
        this.vlanDB = new ArrayList<IVlanInfo>(Arrays.asList(this.eqpmtModel.getVlanDb()));
        this.numRows = this.vlanDB.size();
        this.calculateNumColumns();
    }

    private void calculateNumColumns() {
        EntityCellRenderer entityCellRenderer = new EntityCellRenderer(false);
        this.lineModels = this.eqpmtModel.getXPL2NNILines();
        this.columnNames = new String[this.lineModels.length + 1];
        this.columnNames[0] = "SVLAN";
        for (int i = 0; i < this.lineModels.length; ++i) {
            try {
                IPortModel iPortModel = this.lineModels[i].getPortModel();
                this.columnNames[i + 1] = "Port " + entityCellRenderer.getPortString((IEntityModel)iPortModel, false);
                continue;
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                KDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        this.isDirty = new boolean[this.numRows][this.getColumnCount()];
        this.isRemoved = new boolean[this.numRows][this.getColumnCount()];
        this.resetDirty();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (this.lineModels != null && this.lineModels.length != 0 && this.numRows > 0 && AbstractPane.isUserAuthorized(this.lineModels[0], SecurityLevel.PROVISIONING)) {
            return n2 != 0;
        }
        return false;
    }

    public boolean isCellDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        if (n >= 0 && n < this.columnNames.length) {
            return this.columnNames[n];
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this.numRows;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        switch (n) {
            case 0: {
                return Object.class;
            }
        }
        return Boolean.class;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        try {
            short[] sArray;
            IVlanInfo iVlanInfo = this.vlanDB.get(n);
            switch (n2) {
                case 0: {
                    String string = "";
                    if (!iVlanInfo.getVlanName().equals("")) {
                        string = " (" + iVlanInfo.getVlanName() + ")";
                    }
                    return iVlanInfo.getVlanId() + string;
                }
            }
            for (short s : sArray = this.vlanListCols.get(n2 - 1)) {
                if (s != iVlanInfo.getVlanId()) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Error in getValueAt in ML2MapEtherPortTableModel " + exception);
                KDebug.printStackTrace((Throwable)exception);
            }
            return null;
        }
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        short[] sArray;
        IVlanInfo iVlanInfo = this.vlanDB.get(n);
        short[] sArray2 = this.vlanListCols.get(n2 - 1);
        boolean bl = false;
        for (short n3 : sArray2) {
            if (n3 != iVlanInfo.getVlanId()) continue;
            bl = true;
            break;
        }
        if (!bl && object.equals(Boolean.TRUE)) {
            sArray = new short[sArray2.length + 1];
            System.arraycopy(sArray2, 0, sArray, 0, sArray2.length);
            sArray[sArray2.length] = iVlanInfo.getVlanId();
            this.vlanListCols.set(n2 - 1, sArray);
            this.isDirty[n][n2] = true;
            if (this.isRemoved[n][n2]) {
                this.isRemoved[n][n2] = false;
            }
            this.fireTableCellUpdated(n, n2);
        } else if (bl && object.equals(Boolean.FALSE)) {
            sArray = new short[sArray2.length - 1];
            int n4 = 0;
            for (short s : sArray2) {
                if (s == iVlanInfo.getVlanId()) continue;
                sArray[n4++] = s;
            }
            this.vlanListCols.set(n2 - 1, sArray);
            this.isDirty[n][n2] = true;
            this.isRemoved[n][n2] = true;
            this.fireTableCellUpdated(n, n2);
        }
    }

    public boolean isDirty() {
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                if (!this.isDirty[i][j]) continue;
                return true;
            }
        }
        return false;
    }

    public void resetDirty() {
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
                this.isRemoved[i][j] = false;
            }
        }
    }

    public void refreshLineFromModel(int n) {
        block2: {
            try {
                this.resetLineCache(n);
                this.fireTableRowsUpdated(n, n);
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                KDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public boolean isSVLANRemoved() throws NoSuchInterface {
        for (int i = 0; i < this.getRowCount(); ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                if (!this.isRemoved[i][j] || this.lineModels[j - 1].getAdminState() == 1) continue;
                return true;
            }
        }
        return false;
    }

    public void applyToModel(int n) throws Exception {
        boolean bl = false;
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!this.isDirty[i][n]) continue;
            bl = true;
            break;
        }
        if (bl) {
            this.lineModels[n - 1].setVlanList(this.vlanListCols.get(n - 1));
        }
    }

    public void refreshFromModel() throws Exception {
        int n;
        this.initVlanDB();
        this.vlanListCols = new ArrayList();
        for (n = 0; n < this.lineModels.length; ++n) {
            this.vlanListCols.add(n, this.lineModels[n].getVlanList());
        }
        for (n = 0; n < this.numRows; ++n) {
            this.resetLineCache(n);
        }
        this.fireTableDataChanged();
    }

    protected void resetLineCache(int n) throws Exception {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.isDirty[n][i] = false;
            this.isRemoved[n][i] = false;
        }
    }

    private void registerWithLineModels() {
        for (XPL2LineModel xPL2LineModel : this.lineModels) {
            xPL2LineModel.addObserver(this);
        }
    }

    private void unRegisterWithLineModels() {
        for (XPL2LineModel xPL2LineModel : this.lineModels) {
            xPL2LineModel.deleteObserver(this);
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            int n;
            if (db.on()) {
                db.println("Got an Update Message for " + observable);
            }
            if ((n = Arrays.asList(this.lineModels).indexOf(observable)) != -1) {
                this.refreshLineFromModel(n);
            }
        }
    }

    public void dispose() {
        this.unRegisterWithLineModels();
    }
}

