/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.xml;

import cerent.cms.xml.helper.ByteArrayHelper;
import cerent.util.InetUtil;
import cerent.util.MacAddrFormat;
import cerent.util.SubnetAddrFormat;

public class SchemaTagFactory {
    public static String COMPLEX_TAG = "complexType";
    public static String ELEMENT_TAG = "element";
    public static String CHOICE_TAG = "choice";
    public static String ALL_TAG = "all";
    public static String SEQUENCE_TAG = "sequence";
    private static final String NAMESPACE = "xsd:";
    private static final String OPEN_BRACKET = "<";
    private static final String SLASH = "/";
    private static final String CLOSE_BRACKET = ">";
    private static final String ATTRIBUTE_TAG = "attribute";
    private static final String SCHEMA_TAG = "schema";
    private static final String FAULT = "fault";
    private static final String NAME_TAG = " name=";
    private static final String REF_TAG = " ref=";
    private static final String TYPE_TAG = " type=";
    private static final String UNBOUNDED = " minOccurs=\"0\" maxOccurs=\"unbounded\"";
    private static final String ARRAY = " minOccurs=\"0\" maxOccurs=\"unbounded\"";
    private static final String OPTIONAL = " minOccurs=\"0\"";
    private static final String REQUIRED = " use=\"required\"";
    private static final String DEFAULT = " default=";
    private static final String NEWLINE = "\n";
    private static final String CTC_QUALIFIER = "ctc";
    private static final String NON_XS_QUALIFIER = "ctc:";
    private static final String SHOW_TAG_XS_ATTR = "ctc:showAsTag";
    private static final String SHOW_TAG_XS_ATTR_SETTING = "ctc:showAsTag=\"true\"";
    public static final String ENUM_TYPE = "string";
    public static final String SUBNETADDR = "SubnetAddr";
    public static final String MACADDR = "MACAddr";
    public static final String BYTEARRAY = "ByteArray";
    public static final String IPADDR = "IPAddr";
    public static final String MODEL_INDEXES = "ModelIndexes";

    private SchemaTagFactory() {
    }

    public static String createOpenSchemaTag() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        stringBuilder.append("<xsd:schema xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:ctc=\"http://www.cisco.com/otbu/ctc\" elementFormDefault=\"qualified\">");
        stringBuilder.append(NEWLINE);
        return stringBuilder.toString();
    }

    public static String createCloseSchemaTag() {
        return "</xsd:schema>\n";
    }

    public static String createOpenTag(String string) {
        return "<xsd:" + string + CLOSE_BRACKET + NEWLINE;
    }

    public static String createSimpleCharType() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<xsd:simpleType name=\"char\">\n");
        stringBuilder.append("<xsd:restriction base=\"xsd:string\">\n");
        stringBuilder.append("<xsd:maxLength value=\"1\"/>\n");
        stringBuilder.append(SchemaTagFactory.createCloseTag("restriction"));
        stringBuilder.append(SchemaTagFactory.createCloseTag("simpleType"));
        return stringBuilder.toString();
    }

    public static String createMacAddrType() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<xsd:simpleType name=\"MACAddr\">\n");
        stringBuilder.append("<xsd:restriction base=\"xsd:string\">\n");
        stringBuilder.append("<xsd:pattern value=\"" + MacAddrFormat.regEx() + "\"" + SLASH + CLOSE_BRACKET + NEWLINE);
        stringBuilder.append(SchemaTagFactory.createCloseTag("restriction"));
        stringBuilder.append(SchemaTagFactory.createCloseTag("simpleType"));
        return stringBuilder.toString();
    }

    public static String createSubnetAddrType() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<xsd:simpleType name=\"SubnetAddr\">\n");
        stringBuilder.append("<xsd:restriction base=\"xsd:string\">\n");
        stringBuilder.append("<xsd:pattern value=\"" + SubnetAddrFormat.regEx() + "\"" + SLASH + CLOSE_BRACKET + NEWLINE);
        stringBuilder.append(SchemaTagFactory.createCloseTag("restriction"));
        stringBuilder.append(SchemaTagFactory.createCloseTag("simpleType"));
        return stringBuilder.toString();
    }

    public static String createByteArrayType() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<xsd:simpleType name=\"ByteArray\">\n");
        stringBuilder.append("<xsd:restriction base=\"xsd:string\">\n");
        stringBuilder.append("<xsd:pattern value=\"" + ByteArrayHelper.regEx() + "\"" + SLASH + CLOSE_BRACKET + NEWLINE);
        stringBuilder.append(SchemaTagFactory.createCloseTag("restriction"));
        stringBuilder.append(SchemaTagFactory.createCloseTag("simpleType"));
        return stringBuilder.toString();
    }

    public static String createIpAddrType() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(SchemaTagFactory.createComplexTypeTag(IPADDR));
        stringBuilder.append(SchemaTagFactory.createOpenTag(CHOICE_TAG + OPTIONAL));
        stringBuilder.append(SchemaTagFactory.createClosedElementUserTypeTag("addr", "ipAddr"));
        stringBuilder.append(SchemaTagFactory.createCloseTag(CHOICE_TAG));
        stringBuilder.append(SchemaTagFactory.createCloseTag(COMPLEX_TAG));
        stringBuilder.append("<xsd:simpleType name=\"ipAddr\">\n");
        stringBuilder.append("<xsd:restriction base=\"xsd:string\">\n");
        stringBuilder.append("<xsd:pattern value=\"" + InetUtil.regEx() + "\"" + SLASH + CLOSE_BRACKET + NEWLINE);
        stringBuilder.append(SchemaTagFactory.createCloseTag("restriction"));
        stringBuilder.append(SchemaTagFactory.createCloseTag("simpleType"));
        return stringBuilder.toString();
    }

    public static String createEnumType(String string, String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<xsd:simpleType name=\"" + string + "\"" + CLOSE_BRACKET + NEWLINE);
        stringBuilder.append("<xsd:restriction base=\"xsd:string\">\n");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append("<xsd:enumeration value=\"" + stringArray[i] + "\"" + SLASH + CLOSE_BRACKET + NEWLINE);
        }
        stringBuilder.append(SchemaTagFactory.createCloseTag("restriction"));
        stringBuilder.append(SchemaTagFactory.createCloseTag("simpleType"));
        return stringBuilder.toString();
    }

    public static String createUnionType(String string, String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<xsd:simpleType name=\"" + string + "\"" + CLOSE_BRACKET + NEWLINE);
        stringBuilder.append("<xsd:union memberTypes=\"");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(stringArray[i] + " ");
        }
        stringBuilder.append("\"/>\n");
        stringBuilder.append(SchemaTagFactory.createCloseTag("simpleType"));
        return stringBuilder.toString();
    }

    public static String createBaseModelsType(Object[] objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(SchemaTagFactory.createComplexTypeTag(MODEL_INDEXES));
        SchemaTagFactory.createModelIndexChoices(stringBuilder, objectArray);
        stringBuilder.append(SchemaTagFactory.createCloseTag(COMPLEX_TAG));
        stringBuilder.append(SchemaTagFactory.createComplexTypeTag("ModelIndexType"));
        stringBuilder.append(SchemaTagFactory.createIndexRefTag(true));
        stringBuilder.append(SchemaTagFactory.createCloseTag(COMPLEX_TAG));
        return stringBuilder.toString();
    }

    public static void createModelIndexChoices(StringBuilder stringBuilder, Object[] objectArray) {
        stringBuilder.append(SchemaTagFactory.createUnboundedChoiceTag(SHOW_TAG_XS_ATTR_SETTING));
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuilder.append(SchemaTagFactory.createClosedElementUserTypeTag((String)objectArray[i], "ModelIndexType"));
        }
        stringBuilder.append(SchemaTagFactory.createCloseTag(CHOICE_TAG));
    }

    public static String createCloseTag(String string) {
        return "</xsd:" + string + CLOSE_BRACKET + NEWLINE;
    }

    public static String createEmptyTag(String string) {
        return "<xsd:" + string + SLASH + CLOSE_BRACKET + NEWLINE;
    }

    public static String createClosedElementTag(String string, String string2) {
        return SchemaTagFactory.elementTag(string) + TYPE_TAG + "\"" + NAMESPACE + string2 + "\"" + SLASH + CLOSE_BRACKET + NEWLINE;
    }

    public static String createClosedElementUserTypeTag(String string, String string2) {
        return SchemaTagFactory.elementTag(string) + TYPE_TAG + "\"" + string2 + "\"" + SLASH + CLOSE_BRACKET + NEWLINE;
    }

    public static String createElementTag(String string, String string2) {
        return SchemaTagFactory.elementTag(string) + TYPE_TAG + "\"" + NAMESPACE + string2 + "\"" + CLOSE_BRACKET + NEWLINE;
    }

    public static String createElementTag(String string) {
        return SchemaTagFactory.elementTag(string) + CLOSE_BRACKET + NEWLINE;
    }

    public static String createUnboundedElementTag(String string) {
        return SchemaTagFactory.elementTag(string) + " minOccurs=\"0\" maxOccurs=\"unbounded\"" + CLOSE_BRACKET + NEWLINE;
    }

    public static String createUnboundedChoiceTag(String string) {
        if (string != null && string.length() > 0) {
            string = " " + string;
        }
        return "<xsd:" + CHOICE_TAG + " minOccurs=\"0\" maxOccurs=\"unbounded\"" + string + CLOSE_BRACKET + NEWLINE;
    }

    public static String createUnboundedChoiceTag() {
        return SchemaTagFactory.createUnboundedChoiceTag("");
    }

    public static String createZeroChoiceTag() {
        return "<xsd:" + CHOICE_TAG + OPTIONAL + CLOSE_BRACKET + NEWLINE;
    }

    public static String createSingleChoiceTag() {
        return "<xsd:" + CHOICE_TAG + CLOSE_BRACKET + NEWLINE;
    }

    public static String createArrayElementTag(String string, String string2) {
        return SchemaTagFactory.elementTag(string) + TYPE_TAG + "\"" + NAMESPACE + string2 + "\"" + " minOccurs=\"0\" maxOccurs=\"unbounded\"" + SLASH + CLOSE_BRACKET + NEWLINE;
    }

    private static String elementTag(String string) {
        return "<xsd:" + ELEMENT_TAG + NAME_TAG + "\"" + string + "\"";
    }

    public static String createAttributeTag(String string, String string2) {
        return "<xsd:attribute name=\"" + string + "\"" + TYPE_TAG + "\"" + NAMESPACE + string2 + "\"" + SLASH + CLOSE_BRACKET + NEWLINE;
    }

    public static String createAttributeTag(String string, String string2, String string3) {
        return "<xsd:attribute name=\"" + string + "\"" + TYPE_TAG + "\"" + NAMESPACE + string2 + "\"" + DEFAULT + "\"" + string3 + "\"" + SLASH + CLOSE_BRACKET + NEWLINE;
    }

    public static String createElementRefTag(String string) {
        return "<xsd:" + ELEMENT_TAG + REF_TAG + "\"" + string + "\"" + SLASH + CLOSE_BRACKET + NEWLINE;
    }

    public static String createElementRefArrayTag(String string) {
        return "<xsd:" + ELEMENT_TAG + REF_TAG + "\"" + string + "\"" + " minOccurs=\"0\" maxOccurs=\"unbounded\"" + SLASH + CLOSE_BRACKET + NEWLINE;
    }

    public static String createComplexTypeTag(String string) {
        return "<xsd:" + COMPLEX_TAG + NAME_TAG + "\"" + string + "\"" + CLOSE_BRACKET + NEWLINE;
    }

    public static String createComment(String string) {
        return "<!-- " + string + " --" + CLOSE_BRACKET + NEWLINE;
    }

    public static String createFaultSchema() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(SchemaTagFactory.createElementTag(FAULT));
        stringBuilder.append(SchemaTagFactory.createOpenTag(COMPLEX_TAG));
        stringBuilder.append(SchemaTagFactory.createOpenTag(CHOICE_TAG));
        stringBuilder.append(SchemaTagFactory.createClosedElementTag("faultcode", ENUM_TYPE));
        stringBuilder.append(SchemaTagFactory.createClosedElementTag("faultstring", ENUM_TYPE));
        stringBuilder.append(SchemaTagFactory.createClosedElementTag("stacktrace", ENUM_TYPE));
        stringBuilder.append(SchemaTagFactory.createClosedElementTag("xmlcommand", ENUM_TYPE));
        stringBuilder.append(SchemaTagFactory.createCloseTag(CHOICE_TAG));
        stringBuilder.append(SchemaTagFactory.createCloseTag(COMPLEX_TAG));
        stringBuilder.append(SchemaTagFactory.createCloseTag(ELEMENT_TAG));
        return stringBuilder.toString();
    }

    public static String createIndexSchema() {
        return SchemaTagFactory.createAttributeTag("index", "integer");
    }

    public static String createFaultRefTag() {
        return SchemaTagFactory.createElementRefTag(FAULT);
    }

    public static String createIndexRefTag(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<xsd:attribute ref=\"index\"");
        if (bl) {
            stringBuilder.append(REQUIRED);
        }
        stringBuilder.append("/>\n");
        return stringBuilder.toString();
    }

    public static String createArraySchema(String string) {
        return SchemaTagFactory.createArraySchema(string, "Array");
    }

    public static String createArraySchema(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(SchemaTagFactory.createElementTag(string + string2));
        stringBuilder.append(SchemaTagFactory.createOpenTag(COMPLEX_TAG));
        stringBuilder.append(SchemaTagFactory.createOpenTag(SEQUENCE_TAG));
        stringBuilder.append(SchemaTagFactory.createElementRefArrayTag(string + "Element"));
        stringBuilder.append(SchemaTagFactory.createCloseTag(SEQUENCE_TAG));
        stringBuilder.append(SchemaTagFactory.createAttributeTag("collection", "boolean"));
        stringBuilder.append(SchemaTagFactory.createCloseTag(COMPLEX_TAG));
        stringBuilder.append(SchemaTagFactory.createCloseTag(ELEMENT_TAG));
        return stringBuilder.toString();
    }
}

