/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.xml;

import cerent.cms.model.CTCUserException;
import cerent.cms.model.ExternalInitializationRequired;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.Model;
import cerent.cms.model.ModelSingletonCollection;
import cerent.cms.model.ModelSizer;
import cerent.cms.model.NodeAdapter;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.UninitializedNode;
import cerent.cms.xml.AssociationIterator;
import cerent.cms.xml.IAssociationIterator;
import cerent.cms.xml.IXmlAdapter;
import cerent.cms.xml.LocatorFactory;
import cerent.cms.xml.MetaDataRepository;
import cerent.cms.xml.ModelLocator;
import cerent.cms.xml.ModelNameCache;
import cerent.cms.xml.OutOfBandUtil;
import cerent.cms.xml.ReflectionUtil;
import cerent.cms.xml.XmlHelperFactory;
import cerent.cms.xml.XmlNodeFactory;
import cerent.cms.xml.XmlTagFactory;
import cerent.cms.xml.helper.BaseModelHelper;
import cerent.cms.xml.helper.Helper;
import cerent.launcher.CmsClassLoader;
import cerent.util.ArrayIterator;
import cerent.util.ILocator;
import cerent.util.INameValue;
import cerent.util.KDebug;
import cerent.util.MutableQualifiedNameValue;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.SingleObjectIterator;
import cerent.util.id.ModelIdentity;
import cerent.util.id.ModelIdentityFactory;
import cerent.util.xml.DOMUtil;
import cerent.util.xml.XercesDOMParser;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXParseException;

public class XmlAdapter
implements IXmlAdapter {
    static ModelNameCache nonfqNames = new ModelNameCache();
    private static final AssociationIterator nullAssociationIterator = new AssociationIterator();
    private static ThreadLocal prevRespCached = null;
    private static final String XML_DOM_REUSE_CACHE = "xml.debug.domcache";
    private static final String XML_SCHEMA_FILE_PREF = "xml.schemafile";
    private static final String XML_COPY_WRAPPERS = "xml.copywrappers";
    private static final String XML_PARSE_RESP = "xml.parseresp";
    private static final String XML_MEMORY_TEST = "xml.memtest";
    private static ModelSingletonCollection xmlAdapterSingletons;
    private NodeModelDelegate nmd;
    private boolean canonical = true;
    private static boolean domCache;
    private static final String INDEX = "index";
    private static final String GETALL_MODEL_COMMAND = "getAll";
    public static final String GET_MODEL_COMMAND = "get";
    private static final String GETCHILDREN_MODEL_COMMAND = "getChildren";
    private static final String ATTRIBUTE_METHOD = "attributeMethod";
    private static final String BASE_MODEL_HELPER = "BaseModel";
    public static final String MODEL_PKG_PREFIX = "cerent.cms.model.";
    public static final String EXCEPTION = "EXCEPTION";
    private static final String PREFS_XML = "ctc.xml";
    private static final String PREF_XML_OOB = "oob";
    private static final String PREF_XML_LOG_OOB = "logoob";
    private Debug db;
    private String neVersion;
    private XercesDOMParser parser;
    private boolean doParseTiming;
    private LocatorFactory locFac;

    public static synchronized XmlAdapter getInstance(INodeModel iNodeModel) throws CTCUserException {
        XmlAdapter xmlAdapter;
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)iNodeModel;
        if (xmlAdapterSingletons == null) {
            xmlAdapterSingletons = ModelSingletonCollection.getMSCInstanceByName((String)"XmlAdapter");
        }
        if ((xmlAdapter = (XmlAdapter)xmlAdapterSingletons.get((Object)nodeModelDelegate)) == null && !nodeModelDelegate.isDestroyed()) {
            xmlAdapter = new XmlAdapter(nodeModelDelegate);
            xmlAdapterSingletons.add((Object)nodeModelDelegate, (Object)xmlAdapter);
        }
        return xmlAdapter;
    }

    public static URL getSchemaUrl() {
        return XmlAdapter.getSchemaUrl(null);
    }

    public static URL getSchemaUrl(SDebug sDebug) {
        URL uRL;
        block2: {
            String string = Preferences.instance().getProperty("ctc", XML_SCHEMA_FILE_PREF, "");
            uRL = null;
            try {
                uRL = string == null || string.length() == 0 ? XmlAdapter.class.getResource("/schema/CTCSchema.xsd") : (!string.startsWith("file:") && !string.startsWith("http:") ? new URL("file", "", string.replace('\\', '/')) : new URL(string));
            }
            catch (MalformedURLException malformedURLException) {
                if (sDebug == null) break block2;
                sDebug.println("malformed schema file: " + string);
            }
        }
        return uRL;
    }

    private XmlAdapter(NodeModelDelegate nodeModelDelegate) throws CTCUserException {
        if (nodeModelDelegate == null) {
            throw new CTCUserException("INodeModel is NULL");
        }
        this.nmd = nodeModelDelegate;
        this.db = new Debug(nodeModelDelegate.getDebug(), "XmlAdapter");
        this.neVersion = ((CmsClassLoader)XmlAdapter.class.getClassLoader()).getSwVersion();
        URL uRL = XmlAdapter.getSchemaUrl(this.db);
        this.parser = XercesDOMParser.instance((URL)uRL, (KDebug)XercesDOMParser.getDebug());
        this.doParseTiming = Preferences.instance().getBoolean("ctc", XML_PARSE_RESP, false);
        this.locFac = new LocatorFactory();
        this.locFac.createModelLocator(nodeModelDelegate);
        this.locFac.createPresDataLocator(nodeModelDelegate);
        domCache = Preferences.instance().getBoolean("ctc", XML_DOM_REUSE_CACHE, false);
        if (domCache) {
            prevRespCached = new ThreadLocal();
        }
    }

    public boolean doParseTiming() {
        return this.doParseTiming;
    }

    public List domGetAssociation(String string, int n, String string2) throws ExternalInitializationRequired {
        LinkedList<Document> linkedList = new LinkedList<Document>();
        try {
            Iterator iterator = this.performAssocMethod(string, n, string2);
            return this.domPerformClassGets(iterator);
        }
        catch (CTCUserException cTCUserException) {
            String string3 = "getAssociation " + string + " " + n + " " + string2;
            linkedList.add(XmlNodeFactory.makeFaultDocument(EXCEPTION, string3, (Exception)((Object)cTCUserException)));
            return linkedList;
        }
    }

    public List getAssociation(String string, int n, String string2) throws ExternalInitializationRequired {
        List<String> list = new LinkedList<String>();
        try {
            Iterator iterator = this.performAssocMethod(string, n, string2);
            String string3 = string + " " + n + " " + string2;
            list = this.performClassGets(iterator, string3);
            return list;
        }
        catch (CTCUserException cTCUserException) {
            list.add(XmlTagFactory.printHeader() + XmlTagFactory.makeFaultElement(EXCEPTION, "getAssociation", (Exception)((Object)cTCUserException)));
            return list;
        }
    }

    public Iterator getAssociationUseFile(String string, int n, String string2, String string3) throws ExternalInitializationRequired {
        IAssociationIterator iAssociationIterator = null;
        try {
            Document document = null;
            if (string3 != null) {
                document = this.parseData(true, string3, "prev resp decode");
                OutOfBandUtil.reconstructParkingLot(document);
            }
            iAssociationIterator = this.getAssociation(string, n, string2, document);
        }
        catch (CTCUserException cTCUserException) {
            return null;
        }
        return iAssociationIterator;
    }

    public IAssociationIterator getAssociation(String string, int n, String string2, Document document) throws CTCUserException, ExternalInitializationRequired, UninitializedNode {
        AssociationIterator associationIterator = null;
        if (this.db.on() && this.db.doCmdCount()) {
            ++this.db.numXmlCmds;
            if (document == null) {
                ++this.db.numXmlCmds;
            }
        }
        try {
            Iterator iterator = this.performAssocMethod(string, n, string2);
            if (iterator != null) {
                associationIterator = new AssociationIterator(iterator, document, this);
                if (domCache && document != null) {
                    prevRespCached.set(document);
                }
            }
        }
        catch (Exception exception) {
            Element element = document.getDocumentElement();
            OutOfBandUtil.makeParkingLot(element);
            String string3 = this.makeAssocString(string, n);
            this.handleFault(document, exception, string3);
            associationIterator = new AssociationIterator(document);
        }
        if (associationIterator == null) {
            associationIterator = nullAssociationIterator;
        }
        return associationIterator;
    }

    Document performModelGet(Model model, Document document) {
        String string = model.getClass().getName();
        string = nonfqNames.getTransformedString(string);
        int n = model.getIndex();
        try {
            Node node = null;
            if (document == null && domCache) {
                document = (Document)prevRespCached.get();
            }
            if (document == null) {
                document = DOMUtil.createDocument();
                node = document.appendChild(XmlNodeFactory.makeElement((Node)document, string, n));
            } else {
                Element element = document.getDocumentElement();
                OutOfBandUtil.makeParkingLot(element);
                if (this.db.on()) {
                    try {
                        this.db.println("After makeParkingLot()");
                        this.db.println(NodeAdapter.prettyXmlString(DOMUtil.nodeToString((Node)document)));
                    }
                    catch (CTCUserException cTCUserException) {
                        // empty catch block
                    }
                }
                XmlNodeFactory.reuseRootElement(document, string, n);
                node = element;
            }
            if (node != null) {
                node.insertBefore(this.domInvokeCommandOnModel(model, GET_MODEL_COMMAND, node), node.getFirstChild());
                document = this.handleOobResponse(document);
                if (domCache && document != null) {
                    prevRespCached.set(document);
                }
            }
        }
        catch (Exception exception) {
            String string2 = this.makeAssocString(string, n);
            document = this.handleFault(document, exception, string2);
        }
        return document;
    }

    private Iterator performAssocMethod(String string, int n, String string2) throws CTCUserException {
        if (this.db.on() && this.db.doMem()) {
            this.db.println(this.getMemReport());
        }
        if (this.db.on()) {
            if (this.db.doTiming()) {
                this.db.logThreadTiming("start performAssocMethod(" + string + ", " + n + ", " + string2 + ")");
            } else {
                this.db.println("start performAssocMethod(" + string + ", " + n + ", " + string2 + ")");
            }
        }
        Object object = null;
        Method method = null;
        Object object2 = null;
        try {
            INameValue iNameValue = this.getNameValue(string, Integer.toString(n));
            ILocator iLocator = this.locFac.lookup(iNameValue);
            if (iLocator == null) {
                throw new CTCUserException("Architecture cannot handle " + iNameValue.toString());
            }
            Model model = this.getModel(iLocator, iNameValue);
            method = model.getClass().getMethod(string2, new Class[0]);
            method.setAccessible(true);
            object = method.invoke((Object)model, new Object[0]);
        }
        catch (ExternalInitializationRequired externalInitializationRequired) {
            throw externalInitializationRequired;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (this.db.doTiming()) {
                this.db.logThreadTiming("end (error) assoc cmd");
            }
            throw new CTCUserException("NoSuchMethodException on " + string + " " + string2 + " -- check the association name");
        }
        catch (InvocationTargetException invocationTargetException) {
            if (this.db.doTiming()) {
                this.db.logThreadTiming("end (error) assoc cmd");
            }
            Helper.handleInvokeException(invocationTargetException);
        }
        catch (Exception exception) {
            if (this.db.on()) {
                this.db.print(exception.toString());
            }
            throw new CTCUserException("[XmlAdapter] invoke on method " + string + "." + string2 + " failed: " + exception.toString(), (Throwable)exception);
        }
        if (object != null) {
            if (object instanceof Collection) {
                object2 = ((Collection)object).iterator();
            } else if (object.getClass().isArray()) {
                object2 = ArrayIterator.getInstance((Object)object);
            } else if (object instanceof IModel) {
                object2 = SingleObjectIterator.getInstance((Object)object);
            } else if (object instanceof Iterator) {
                object2 = (Iterator)object;
            } else {
                throw new CTCUserException("[XmlAdapter] Association command for " + string + "." + string2 + " failed. Return type not valid" + " for an association command." + " Consider removing the" + " <property name=association-name>" + " from the typeinfo file.");
            }
        }
        if (this.db.doTiming()) {
            this.db.logThreadTiming("end performAssocMethod");
        }
        return object2;
    }

    Document parseStringData(String string, String string2) throws CTCUserException {
        return this.parseData(false, string, string2);
    }

    Document parseFileData(String string) throws CTCUserException {
        return this.parseData(true, string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Document parseData(boolean bl, String string, String string2) throws CTCUserException {
        Document document = null;
        boolean bl2 = this.db.doParseTiming() && string2 != null;
        try {
            if (bl2) {
                this.db.logThreadTiming("start parsing " + string2);
            }
            XercesDOMParser xercesDOMParser = this.parser;
            synchronized (xercesDOMParser) {
                document = bl ? this.parser.parse(string) : this.parser.parseString(string);
            }
        }
        catch (Exception exception) {
            String string3 = exception.toString();
            if (exception instanceof SAXParseException) {
                SAXParseException sAXParseException = (SAXParseException)exception;
                string3 = "(" + sAXParseException.getLineNumber() + "/" + sAXParseException.getColumnNumber() + ") " + string3;
            }
            throw new CTCUserException("Exception while parsing: " + string3);
        }
        if (bl2) {
            this.db.logThreadTiming("stop parsing " + string2);
        }
        return document;
    }

    public Document domXmlCommand(Document document) throws ExternalInitializationRequired {
        Document document2 = null;
        if (document == null) {
            CTCUserException cTCUserException = new CTCUserException("Error: Document is null");
            document2 = XmlNodeFactory.makeFaultDocument(EXCEPTION, "", (Exception)((Object)cTCUserException));
            return document2;
        }
        try {
            document2 = XmlNodeFactory.makeDocument();
            document2 = (Document)this._domXmlCommand(document, document2);
            if (this.db.doTiming()) {
                this.db.logThreadTiming("cmd done");
            }
        }
        catch (CTCUserException cTCUserException) {
            document2 = XmlNodeFactory.makeFaultDocument(EXCEPTION, document, (Exception)((Object)cTCUserException));
            return document2;
        }
        return document2;
    }

    public String xmlCommandFromFile(String string, String string2, String string3) throws ExternalInitializationRequired {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this._xmlCommand(string, string2, true));
        stringBuilder.append(XmlTagFactory.createCommentElement(this.getXMLCommand(string3)));
        return stringBuilder.toString();
    }

    public String xmlCommand(String string) throws ExternalInitializationRequired {
        return this._xmlCommand(string, null, false);
    }

    public String xmlCommand(String string, String string2) throws ExternalInitializationRequired {
        return this._xmlCommand(string, string2, false);
    }

    private String _xmlCommand(String string, String string2, boolean bl) {
        Document document;
        Object object;
        String string3 = null;
        Document document2 = null;
        try {
            object = this.parseData(bl, string, "cmd decode");
            if (object == null) {
                throw new CTCUserException("Error: Document is null");
            }
            if (string2 == null) {
                document2 = domCache ? this.xmlCommand((Document)object, (Document)prevRespCached.get()) : this.domXmlCommand((Document)object);
                if (domCache && document2 != null) {
                    prevRespCached.set(document2);
                }
                string3 = DOMUtil.nodeToString((Node)document2);
            } else {
                document = this.parseData(bl, string2, "prev resp decode");
                OutOfBandUtil.reconstructParkingLot(document);
                document = this.xmlCommand((Document)object, document);
                if (domCache && document != null) {
                    prevRespCached.set(document);
                }
                string3 = DOMUtil.nodeToString((Node)document);
            }
        }
        catch (CTCUserException cTCUserException) {
            return XmlTagFactory.printHeader() + XmlTagFactory.makeFaultElement(EXCEPTION, string, (Exception)((Object)cTCUserException));
        }
        if (this.db.doParseTiming() || this.doParseTiming()) {
            try {
                object = this.db.doParseTiming() ? "xmlCommand resp" : null;
                document = this.parseStringData(string3, (String)object);
            }
            catch (CTCUserException cTCUserException) {
                Debug.printStackTrace((Throwable)cTCUserException);
            }
        }
        return string3;
    }

    public Document xmlCommand(Document document, Document document2) throws CTCUserException, ExternalInitializationRequired, UninitializedNode {
        block8: {
            try {
                if (document2 == null) {
                    document2 = this.domXmlCommand(document);
                    if (this.db.on() && this.db.doCmdCount()) {
                        ++this.db.numXmlCmds;
                        ++this.db.numNullPrevResp;
                    }
                    break block8;
                }
                OutOfBandUtil.makeParkingLot(document2.getDocumentElement());
                if (this.db.on()) {
                    try {
                        this.db.println("After makeParkingLot()");
                        this.db.println(NodeAdapter.prettyXmlString(DOMUtil.nodeToString((Node)document2)));
                    }
                    catch (CTCUserException cTCUserException) {
                        // empty catch block
                    }
                    if (this.db.doCmdCount()) {
                        ++this.db.numXmlCmds;
                    }
                }
                document2 = (Document)this._domXmlCommand(document, document2);
            }
            catch (CTCUserException cTCUserException) {
                String string = DOMUtil.nodeToString((Node)document);
                this.handleFault(document2, (Exception)((Object)cTCUserException), string);
            }
        }
        return document2;
    }

    String getMemReport() {
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.totalMemory();
        long l2 = runtime.freeMemory();
        StringBuilder stringBuilder = new StringBuilder("Used= " + (l - l2));
        stringBuilder.append(". Free= " + l2);
        stringBuilder.append(". Total= " + l);
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    INameValue getNameValue(Node node) throws CTCUserException {
        INameValue iNameValue = null;
        if (node == null) throw new CTCUserException("node must be non-null");
        if (node.getNodeType() != 1) throw new CTCUserException("node must be an DOM ELEMENT node");
        Element element = (Element)node;
        String string = element.getTagName();
        String string2 = element.getAttribute(INDEX);
        if (string2 == null) throw new CTCUserException("node must have a non-empty valued 'index' attribute");
        if (string2.length() != 0) return this.getNameValue(string, string2);
        throw new CTCUserException("node must have a non-empty valued 'index' attribute");
    }

    INameValue getNameValue(String string, String string2) {
        return new MutableQualifiedNameValue(string, string2, (Object)this.nmd);
    }

    private Node _domXmlCommand(Node node, Node node2) throws CTCUserException {
        Object object;
        if (node == null) {
            if (this.db.on()) {
                this.db.println("Node is NULL");
            }
            return null;
        }
        if (this.db.on()) {
            if (this.db.doMem()) {
                this.db.println(this.getMemReport());
                this.db.println("*** XML CMD");
            }
            object = DOMUtil.nodeToString((Node)node, (int)2, (boolean)false);
            this.db.println((String)object);
        }
        boolean bl = Preferences.instance().getBoolean("ctc", XML_COPY_WRAPPERS, false);
        short s = node.getNodeType();
        switch (s) {
            case 9: {
                Object object2;
                Object object3;
                if (this.db.on() && !this.db.doMem()) {
                    this.db.print("In DOCUMENT_NODE ");
                }
                if ((object3 = ((Document)node).getDoctype()) != null) {
                    object2 = object3.getSystemId();
                    if (this.db.on()) {
                        this.db.print("Name: " + object3.getName());
                        this.db.print("System ID: " + (String)object2);
                        this.db.println("Public ID: " + object3.getPublicId());
                    }
                } else if (this.db.on() && !this.db.doMem()) {
                    this.db.println("DocumentType is NULL");
                }
                node = ((Document)node).getDocumentElement();
            }
            case 1: {
                Object object4;
                Node node3;
                if (this.db.on() && this.db.doMem()) {
                    this.db.println("In ELEMENT_NODE Name:" + node.getNodeName());
                }
                Object object3 = new LinkedList();
                Object object2 = this.getIdentityNode(node);
                INameValue iNameValue = this.getNameValue((Node)object2);
                ILocator iLocator = this.locFac.lookup(iNameValue);
                if (iLocator == null) {
                    String string = DOMUtil.nodeToString((Node)object2);
                    throw new CTCUserException("Architecture cannot handle identity node: " + string);
                }
                Object object5 = iLocator.locate((Object)iNameValue);
                if (object5 == null && iLocator instanceof ModelLocator) {
                    object5 = this.getLazyInitModel(ModelIdentityFactory.instance().createModelIdentity(iNameValue));
                }
                if ((node3 = this.getCommand(node, node2, (LinkedList)object3, bl)) == null) {
                    throw new CTCUserException("No get or set command found.");
                }
                String string = node3.getNodeName();
                Node node4 = node3.getAttributes().getNamedItem(INDEX);
                String string2 = "";
                String string3 = "";
                if (node4 != null) {
                    string2 = this.getModelCommand(node3);
                    string3 = node3.getNodeName().substring(string2.length());
                    int n = this.getIndex(node3);
                    Model model = (Model)object5;
                    if (!bl) {
                        string3 = model.getClass().getName();
                        string3 = nonfqNames.getTransformedString(string3);
                        if (OutOfBandUtil.hasParkingLot(node2)) {
                            Element element = ((Document)node2).getDocumentElement();
                            XmlNodeFactory.reuseRootElement((Document)node2, string3, n);
                            object = element;
                        } else {
                            object = node2.appendChild(XmlNodeFactory.makeElement(node2, string3, n));
                        }
                    } else {
                        object = node2;
                    }
                    object.insertBefore(this.domInvokeCommandOnModel(model, node3, string2, (Node)object), object.getFirstChild());
                    break;
                }
                node3 = node3.getParentNode();
                string2 = ATTRIBUTE_METHOD;
                string3 = node3.getNodeName();
                int n = this.getIndex(node3);
                Model model = (Model)object5;
                if (!bl) {
                    string3 = model.getClass().getName();
                    string3 = nonfqNames.getTransformedString(string3);
                    if (OutOfBandUtil.hasParkingLot(node2)) {
                        object4 = ((Document)node2).getDocumentElement();
                        XmlNodeFactory.reuseRootElement((Document)node2, string3, n);
                        object = object4;
                    } else {
                        object = node2.appendChild(XmlNodeFactory.makeElement(node2, string3, n));
                    }
                } else {
                    object = node2;
                }
                object4 = this.domInvokeCommandOnAttribute(model, node3, (Node)object);
                DOMUtil.appendChildren((Node)object, (Node[])object4, (Node)OutOfBandUtil.getOOB((Node)object));
                break;
            }
            case 5: {
                if (!this.db.on()) break;
                this.db.print("In ENTITY_REFERENCE_NODE ");
                break;
            }
            case 4: {
                if (!this.db.on()) break;
                this.db.print("In CDATA_SECTION_NODE ");
                break;
            }
            case 3: {
                if (!this.db.on()) break;
                this.db.print("In TEXT_NODE ");
                break;
            }
            case 7: {
                if (!this.db.on()) break;
                this.db.print("In PROCESSING_INSTRUCTION_NODE ");
            }
        }
        if (this.db.on() && this.db.doMem()) {
            this.db.println(this.getMemReport());
        }
        return node2;
    }

    private Model getModel(ILocator iLocator, INameValue iNameValue) throws CTCUserException {
        Model model = (Model)iLocator.locate((Object)iNameValue);
        if (model == null) {
            model = this.getLazyInitModel(iNameValue);
        }
        return model;
    }

    private Model getLazyInitModel(ModelIdentity modelIdentity) throws CTCUserException {
        Object var2_2 = null;
        Object var3_3 = null;
        boolean bl = false;
        String string = modelIdentity.getModelType();
        int n = modelIdentity.getIndex();
        return this.getLazyInitModel(string, n);
    }

    private Model getLazyInitModel(INameValue iNameValue) throws CTCUserException {
        Integer n;
        String string = iNameValue.getName();
        String string2 = iNameValue.getValue();
        try {
            n = Integer.decode(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new CTCUserException("bad index: " + string2, (Throwable)numberFormatException);
        }
        return this.getLazyInitModel(string, n);
    }

    private Model getLazyInitModel(String string, int n) throws CTCUserException {
        Model model;
        block6: {
            model = null;
            try {
                Class clazz = XmlAdapter.getModelClass(string);
                this.xmlInitModelClassIfRequired(this.nmd, clazz, n);
                if (this.db.on() && !this.db.doMem()) {
                    this.db.println("Try to instance the model: " + string);
                }
                model = Model.getInstance((INodeModel)this.nmd, Model.createInstanceName(string, n));
            }
            catch (ExternalInitializationRequired externalInitializationRequired) {
                throw externalInitializationRequired;
            }
            catch (NullPointerException nullPointerException) {
                if (!this.db.on()) break block6;
                this.db.println("NullPointerException occurred while trying to instatiate: " + string);
            }
        }
        if (model == null) {
            if (this.db.on()) {
                this.db.println("The model " + string + " was not found");
            }
            throw new CTCUserException("Model could not be found for modelName = " + string + " index = " + n);
        }
        return model;
    }

    static Class getModelClass(String string) {
        Class clazz = null;
        try {
            clazz = ReflectionUtil.forName(MODEL_PKG_PREFIX + string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            KDebug.printStackTrace((Throwable)classNotFoundException);
        }
        return clazz;
    }

    public Node domInvokeCommandOnModel(Model model, String string, Node node) throws CTCUserException {
        return this.domInvokeCommandOnModel(model, null, string, node);
    }

    private Node domInvokeCommandOnModel(Model model, Node node, String string, Node node2) throws CTCUserException {
        if (this.db.on() && !this.db.doMem()) {
            this.db.println("Performing invokeCommandOnModel(" + model.getClass().getName() + " ," + string);
        }
        Node node3 = null;
        Object[] objectArray = new Object[]{model, node, node2};
        Class[] classArray = new Class[]{Model.class, Node.class, Node.class};
        Method method = null;
        Class clazz = null;
        try {
            clazz = XmlHelperFactory.getXmlHelperBasedOnClassName(BASE_MODEL_HELPER);
            if (this.db.on() && !this.db.doMem()) {
                this.db.print("invoking " + string + "(");
                for (int i = 0; i < objectArray.length; ++i) {
                    if (i > 0) {
                        this.db.print(", ");
                    }
                    this.db.print(classArray[i].getName());
                }
                this.db.println(") on " + clazz);
            }
            method = clazz.getMethod(string, classArray);
            method.setAccessible(true);
            Object object = method.invoke(null, objectArray);
            node3 = (Node)object;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new CTCUserException("ClassNotFoundException for BaseModelHelper", (Throwable)classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new CTCUserException("NoSuchMethodException on " + clazz.getName() + " " + string, (Throwable)noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Helper.handleInvokeException(invocationTargetException);
        }
        catch (Exception exception) {
            if (this.db.on()) {
                this.db.print(exception.toString());
            }
            throw new CTCUserException("[XmlAdapter] invoke on method " + clazz.getName() + "." + method.getName() + " failed: " + exception.toString(), (Throwable)exception);
        }
        return node3;
    }

    private Node[] domInvokeCommandOnAttribute(Model model, Node node, Node node2) throws CTCUserException {
        return BaseModelHelper.attributeMethod(model, node, node2);
    }

    private Node getIdentityNode(Node node) {
        Node node2 = null;
        String string = node.getNodeName();
        int n = this.getIndex(node);
        if (n >= 0 && string.startsWith(GET_MODEL_COMMAND)) {
            Document document = DOMUtil.createDocument();
            node2 = XmlNodeFactory.makeElement((Node)document, string.substring(3), n);
        } else if (n < 0) {
            node2 = node.getParentNode();
        } else {
            Node node3;
            Iterator iterator = DOMUtil.getChildElementsIterator((Node)node);
            while (iterator.hasNext() && (node2 = this.getIdentityNode(node3 = (Node)iterator.next())) == null) {
            }
        }
        return node2;
    }

    private Node getCommand(Node node, Node node2, LinkedList linkedList, boolean bl) {
        Node node3 = null;
        String string = node.getNodeName();
        int n = this.getIndex(node);
        if (n >= 0 && !string.startsWith(GET_MODEL_COMMAND)) {
            Node node4;
            Node node5;
            if (bl) {
                linkedList.add(string);
                node5 = node2.appendChild(XmlNodeFactory.makeElement(node2, string, n));
            } else {
                node5 = node2;
            }
            Iterator iterator = DOMUtil.getChildElementsIterator((Node)node);
            while (iterator.hasNext() && (node3 = this.getCommand(node4 = (Node)iterator.next(), node5, linkedList, bl)) == null) {
            }
        } else {
            node3 = node;
        }
        return node3;
    }

    private int getIndex(Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem(INDEX);
        if (node2 == null) {
            return -1;
        }
        Integer n = new Integer(node2.getNodeValue());
        return n;
    }

    private String getModelCommand(Node node) throws CTCUserException {
        String string = node.getNodeName();
        if (this.db.doTiming()) {
            this.db.logThreadDateAndTiming("XML cmd: " + string);
        }
        if (string.startsWith(GETCHILDREN_MODEL_COMMAND)) {
            throw new CTCUserException("getChildren commands are no longer supported, as of 11/21/02.  Use getAssociation interface instead.");
        }
        if (string.startsWith(GETALL_MODEL_COMMAND)) {
            throw new CTCUserException("getAll commands are no longer supported, as of 11/21/02.  Use getAssociation interface instead.");
        }
        if (string.startsWith(GET_MODEL_COMMAND)) {
            return GET_MODEL_COMMAND;
        }
        return null;
    }

    private boolean xmlInitModelClassIfRequired(NodeModelDelegate nodeModelDelegate, Class clazz, int n) throws CTCUserException {
        boolean bl = false;
        Class[] classArray = new Class[]{NodeModelDelegate.class, Class.class, Integer.TYPE};
        Method method = null;
        try {
            if (this.db.on()) {
                this.db.println("attempting late init on model: " + clazz.getName() + "/" + n + " for node: " + nodeModelDelegate.getName());
            }
            method = clazz.getMethod("xmlInit", classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (bl = method != null) {
            this.db.println("lazy init method found on model: " + clazz.getName() + "/" + n + " for node: " + nodeModelDelegate.getName());
            try {
                method.invoke(null, nodeModelDelegate, clazz, new Integer(n));
            }
            catch (InvocationTargetException invocationTargetException) {
                Helper.handleInvokeException(invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new CTCUserException(illegalAccessException.getClass().getName() + ": " + illegalAccessException.getMessage(), (Throwable)illegalAccessException);
            }
        }
        return bl;
    }

    private List domPerformClassGets(Iterator iterator) {
        Document document;
        if (this.db.doTiming()) {
            this.db.logThreadTiming("start performModelGets");
        }
        ArrayList<Document> arrayList = new ArrayList<Document>();
        int n = -1;
        while (iterator != null && iterator.hasNext()) {
            Model model;
            ++n;
            if (this.db.doTiming()) {
                this.db.logThreadTiming("start performModelGets[" + n + "]");
            }
            if ((model = (Model)iterator.next()) == null) continue;
            String string = model.getClass().getName();
            string = nonfqNames.getTransformedString(string);
            int n2 = model.getIndex();
            document = XmlNodeFactory.makeDocument();
            try {
                Node node = document.appendChild(XmlNodeFactory.makeElement((Node)document, string, n2));
                node.appendChild(this.domInvokeCommandOnModel(model, GET_MODEL_COMMAND, node));
                document = this.handleOobResponse(document);
            }
            catch (Exception exception) {
                String string2 = this.makeAssocString(string, n2);
                document = XmlNodeFactory.makeFaultDocument(EXCEPTION, string2, exception);
            }
            arrayList.add(document);
        }
        if (this.db.doTiming()) {
            this.db.logThreadTiming("end performModelGets");
        }
        if (this.db.doParseTiming() || this.doParseTiming()) {
            int n3 = arrayList.size();
            if (this.db.doParseTiming()) {
                this.db.logThreadTiming("start parsing " + n3 + " assoc items");
            }
            for (int i = 0; i < n3; ++i) {
                String string = (String)arrayList.get(i);
                try {
                    document = this.parseStringData(string, null);
                    continue;
                }
                catch (CTCUserException cTCUserException) {
                    // empty catch block
                }
            }
            if (this.db.doParseTiming()) {
                this.db.logThreadTiming("end parsing");
            }
        } else if (this.db.doItemParseTiming() || this.doParseTiming()) {
            int n4 = arrayList.size();
            for (int i = 0; i < n4; ++i) {
                String string = (String)arrayList.get(i);
                try {
                    document = this.parseStringData(string, "assoc item " + i);
                    continue;
                }
                catch (CTCUserException cTCUserException) {
                    // empty catch block
                }
            }
        }
        if (this.db.on() && this.db.doMem()) {
            this.db.println(this.getMemReport());
        }
        return arrayList;
    }

    private List performClassGets(Iterator iterator, String string) {
        Object object;
        Object object2;
        int n;
        List list = this.domPerformClassGets(iterator);
        int n2 = list == null ? 0 : list.size();
        ArrayList<String> arrayList = new ArrayList<String>(n2);
        for (n = 0; n < n2; ++n) {
            object2 = (Document)list.get(n);
            try {
                object = new StringBuilder(DOMUtil.nodeToString((Node)object2));
                if (n == n2 - 1) {
                    ((StringBuilder)object).append(XmlTagFactory.createCommentElement(this.getAssociationCommand(string)));
                }
                arrayList.add(((StringBuilder)object).toString());
                continue;
            }
            catch (CTCUserException cTCUserException) {
                arrayList.add(XmlTagFactory.makeFaultElement(EXCEPTION, "nodeToString failed", (Exception)((Object)cTCUserException)));
            }
        }
        if (this.db.doParseTiming()) {
            n2 = arrayList.size();
            this.db.logThreadTiming("start parsing " + n2 + " assoc items");
            for (n = 0; n < n2; ++n) {
                object2 = (String)arrayList.get(n);
                try {
                    object = this.parseStringData((String)object2, null);
                    continue;
                }
                catch (CTCUserException cTCUserException) {
                    // empty catch block
                }
            }
            this.db.logThreadTiming("end parsing");
        } else if (this.db.doItemParseTiming()) {
            n2 = arrayList.size();
            for (n = 0; n < n2; ++n) {
                object2 = (String)arrayList.get(n);
                try {
                    object = this.parseStringData((String)object2, "assoc item " + n);
                    continue;
                }
                catch (CTCUserException cTCUserException) {
                    // empty catch block
                }
            }
        }
        return arrayList;
    }

    private Document handleFault(Document document, Exception exception, String string) {
        if (document == null) {
            document = XmlNodeFactory.makeFaultDocument(EXCEPTION, string, exception);
        } else {
            Element element = document.getDocumentElement();
            if (element == null) {
                document = XmlNodeFactory.makeFaultDocument(EXCEPTION, string, exception);
            } else {
                XmlNodeFactory.reuseRootElement(document, "fault");
                element = XmlNodeFactory.makeFaultElements(element, EXCEPTION, string, exception);
            }
        }
        return document;
    }

    private String makeAssocString(String string, int n) {
        return XmlTagFactory.makeIndexElement(GET_MODEL_COMMAND + string, 0, n);
    }

    private String getXMLCommand(String string) {
        return "node" + this.getDebugName() + " nmd feature xmlCommand " + string;
    }

    private String getAssociationCommand(String string) {
        return "node" + this.getDebugName() + " nmd feature getAssociation " + string;
    }

    private String getDebugName() {
        InetAddress inetAddress = null;
        String string = this.nmd.getHostName();
        try {
            inetAddress = InetAddress.getByName(string);
            if (inetAddress != null) {
                byte[] byArray = inetAddress.getAddress();
                return "" + (byArray[3] & 0xFF) + "-" + (byArray[2] & 0xFF) + "-" + (byArray[1] & 0xFF) + "-" + (byArray[0] & 0xFF);
            }
            return string;
        }
        catch (UnknownHostException unknownHostException) {
            return string;
        }
    }

    public static boolean doReturnOob() {
        return Preferences.instance().getBoolean(PREFS_XML, PREF_XML_OOB, true);
    }

    public static boolean doLogOob() {
        return Preferences.instance().getBoolean(PREFS_XML, PREF_XML_LOG_OOB, false);
    }

    public boolean doDomCache() {
        return domCache;
    }

    public Document handleOobResponse(Document document) {
        Node node;
        Node node2;
        Document document2 = document;
        Element element = OutOfBandUtil.getAttrFaults(document);
        if (XmlAdapter.doLogOob()) {
            this.logOob(element.getParentNode());
        }
        if (element != null && !XmlAdapter.doReturnOob() && (node2 = element.getFirstChild()) != null && (node = node2.getFirstChild()) != null) {
            document2 = XmlNodeFactory.makeFaultDocument(node);
        }
        return document2;
    }

    private void logOob(Node node) {
        String string;
        try {
            string = DOMUtil.nodeToString((Node)node, (int)2, (boolean)false);
        }
        catch (CTCUserException cTCUserException) {
            string = cTCUserException.getMessage();
        }
        if (this.db == null) {
            System.out.println(string);
        } else {
            this.db.display(string);
        }
    }

    static {
        domCache = false;
    }

    public class Debug
    extends SDebug {
        private String ENCODING;
        boolean doTiming;
        boolean doParseTiming;
        boolean doItemParseTiming;
        boolean doMem;
        boolean doCmdCount;
        int numXmlCmds;
        int numNullPrevResp;

        public Debug(SDebug sDebug, String string) {
            super((KDebug)sDebug, string);
            this.ENCODING = "UTF8";
            this.doMem = Preferences.instance().getBoolean("ctc", XmlAdapter.XML_MEMORY_TEST, false);
        }

        public final void setLogTiming(boolean bl) {
            this.doTiming = bl;
        }

        public final void mem(boolean bl) {
            this.doMem = bl;
        }

        public final void setLogParseTiming(boolean bl) {
            this.doParseTiming = bl;
        }

        public final void setLogItemParseTiming(boolean bl) {
            this.doItemParseTiming = bl;
        }

        public boolean doTiming() {
            return this.doTiming;
        }

        public boolean doMem() {
            return this.doMem;
        }

        public boolean doParseTiming() {
            return this.doParseTiming;
        }

        public boolean doItemParseTiming() {
            return this.doItemParseTiming;
        }

        public void logThreadTiming(String string) {
            this.println(Thread.currentThread() + " " + string + " " + System.currentTimeMillis() + " msecs");
        }

        public void logThreadDateAndTiming(String string) {
            Date date = new Date();
            this.println(Thread.currentThread() + " " + string + " " + date + "(" + date.getTime() + ")");
        }

        public final void loadClass(String string) {
            try {
                Class.forName(string);
            }
            catch (Exception exception) {
                this.println(exception.getMessage());
            }
        }

        public final void metadata() {
            try {
                MetaDataRepository.getInstance(true);
            }
            catch (CTCUserException cTCUserException) {
                this.println(cTCUserException.getMessage());
            }
            this.display("metadata loading complete");
        }

        public final void parseFile(String string) {
            try {
                XmlAdapter.this.parseFileData(string);
            }
            catch (CTCUserException cTCUserException) {
                this.println(cTCUserException.getMessage());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void rewrite(String string) {
            FileOutputStream fileOutputStream = null;
            try {
                Document document = XmlAdapter.this.parseFileData(string);
                String string2 = DOMUtil.nodeToString((Node)document);
                File file = new File(string);
                fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(string2.getBytes(this.ENCODING));
                fileOutputStream.flush();
            }
            catch (Exception exception) {
                this.println(exception.getMessage());
            }
            finally {
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (Exception exception) {
                    XmlAdapter.this.db;
                    Debug.printStackTrace((Throwable)exception);
                }
            }
        }

        public final void sizeof(String string, int n) {
            Model model = Model.getInstance((INodeModel)XmlAdapter.this.nmd, Model.createInstanceName(string, n));
            model.getAttributeNames();
            ModelSizer modelSizer = new ModelSizer(this);
            int n2 = modelSizer.sizeOf(model);
            this.display("model " + string + " " + n + ": size - " + n2 + " bytes");
        }

        public final void dumpAttrs(String string) {
            try {
                Class<?> clazz = Class.forName(string);
                Model.dumpModelAttributes(clazz, this);
            }
            catch (ClassNotFoundException classNotFoundException) {
                XmlAdapter.this.db.display("could not load class: " + string);
            }
        }

        public final void getNeType() {
            String string = ReflectionUtil.getNeType();
            boolean bl = ReflectionUtil.isNeTypeUnspecified((String)string);
            XmlAdapter.this.db.println("getNeType(): " + (bl ? " is unspecified" : "" + string));
        }

        public final void countNullPrevResp(boolean bl) {
            this.doCmdCount = bl;
            if (!this.doCmdCount) {
                this.dumpNullPrevResp();
                this.numXmlCmds = 0;
                this.numNullPrevResp = 0;
            }
        }

        public boolean doCmdCount() {
            return this.doCmdCount;
        }

        public final void dumpNullPrevResp() {
            XmlAdapter.this.db.println("Number of XML commands processed: " + this.numXmlCmds);
            XmlAdapter.this.db.println("Number of null previous responses:  " + this.numNullPrevResp);
        }
    }
}

