/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.xml;

import cerent.cms.model.CTCUserException;
import cerent.cms.xml.MetaDataRepository;
import cerent.cms.xml.OutOfBandUtil;
import cerent.cms.xml.XmlTagFactory;
import cerent.cms.xml.helper.BaseObjectHelper;
import cerent.util.xml.DOMUtil;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XmlNodeFactory {
    static final String INDEX_ATTR = " index=";
    private static final String INDEX_NAME = "index";
    public static final String FAULT = "fault";

    public static Document makeDocument() {
        return DOMUtil.createDocument();
    }

    public static Document makeFaultDocument(String string, Node node, Exception exception) {
        try {
            String string2 = DOMUtil.nodeToString((Node)node);
            return XmlNodeFactory.makeFaultDocument(string, string2, exception);
        }
        catch (CTCUserException cTCUserException) {
            return XmlNodeFactory.makeFaultDocument(string, "", exception);
        }
    }

    public static Document makeFaultDocument(String string, String string2, Exception exception) {
        Document document = XmlNodeFactory.makeDocument();
        return XmlNodeFactory.makeFaultDocument(document, document, string, string2, exception);
    }

    public static Document makeFaultDocument(Document document, Node node, String string, String string2, Exception exception) {
        node = node.appendChild(XmlNodeFactory.makeElement(node, FAULT));
        node = XmlNodeFactory.makeFaultElements(node, string, string2, exception);
        return document;
    }

    public static Element makeFaultElements(Node node, String string, String string2, Exception exception) {
        Element element = OutOfBandUtil.getOOB(node);
        DOMUtil.appendChild((Node)node, (Node)XmlNodeFactory.makeElement(node, "faultcode", string), (Node)element);
        DOMUtil.appendChild((Node)node, (Node)XmlNodeFactory.makeComment(node, "faultstring", exception.getMessage()), (Node)element);
        DOMUtil.appendChild((Node)node, (Node)XmlNodeFactory.makeComment(node, "ele-version", XmlNodeFactory.getEleBuildInfoVersionAndDate()), (Node)element);
        DOMUtil.appendChild((Node)node, (Node)XmlNodeFactory.makeComment(node, "core-version", XmlNodeFactory.getCoreBuildInfoVersionAndDate()), (Node)element);
        DOMUtil.appendChild((Node)node, (Node)XmlNodeFactory.makeComment(node, "thread", Thread.currentThread().toString()), (Node)element);
        DOMUtil.appendChild((Node)node, (Node)XmlNodeFactory.makeComment(node, "metadata", MetaDataRepository.getMetaDataUrl().toString()), (Node)element);
        DOMUtil.appendChild((Node)node, (Node)XmlNodeFactory.makeComment(node, "typeinfo", MetaDataRepository.getTypeInfoUrl().toString()), (Node)element);
        DOMUtil.appendChild((Node)node, (Node)XmlNodeFactory.makeComment(node, "xmlCommand", XmlNodeFactory.decomment(string2)), (Node)element);
        DOMUtil.appendChild((Node)node, (Node)XmlNodeFactory.makeComment(node, "stacktrace", XmlNodeFactory.getStackTrace(exception)), (Node)element);
        return (Element)node;
    }

    public static Document makeFaultDocument(Node node) {
        Document document = XmlNodeFactory.makeDocument();
        Node node2 = document.importNode(node, true);
        document.appendChild(node2);
        return document;
    }

    static Element _makeElement(Node node, String string, String string2) {
        Document document = DOMUtil.getOwnerDocument((Node)node);
        String string3 = string2 == null ? XmlNodeFactory.rules(string) : string2 + XmlNodeFactory.rules(string);
        Element element = (Element)OutOfBandUtil.getNodeByType((short)1, document);
        if (element != null) {
            XmlNodeFactory.renameNode(document, element, string3);
        } else {
            element = document.createElement(string3);
        }
        return element;
    }

    public static Element makeElement(Node node, String string) {
        return XmlNodeFactory._makeElement(node, string, null);
    }

    public static Element makeCDATAElement(Node node, String string, String string2) {
        Document document = node.getOwnerDocument();
        Element element = XmlNodeFactory.makeElement(node, string);
        element.appendChild(XmlNodeFactory.makeCDATASection(document, string2));
        return element;
    }

    public static Element makeElement(Node node, String string, String string2) {
        Document document = node.getOwnerDocument();
        Element element = XmlNodeFactory.makeElement(node, string);
        element.appendChild(XmlNodeFactory.makeTextNode(document, string2));
        return element;
    }

    public static Element makeComment(Node node, String string, String string2) {
        Document document = node.getOwnerDocument();
        Element element = XmlNodeFactory.makeElement(node, string);
        element.appendChild(XmlNodeFactory.makeComment(document, string2));
        return element;
    }

    public static Element makeElement(Node node, String string, int n) {
        return XmlNodeFactory.makeElement(node, string, n, null);
    }

    public static Element makeElement(Node node, String string, int n, String string2) {
        Element element = XmlNodeFactory._makeElement(node, string, string2);
        String string3 = BaseObjectHelper.integerToString(n, INDEX_ATTR);
        element.setAttribute(INDEX_NAME, string3);
        return element;
    }

    private static Node makeTextNode(Document document, String string) {
        Node node = OutOfBandUtil.getNodeByType((short)3, document);
        if (node != null) {
            ((Text)node).setData(string);
        } else {
            node = document.createTextNode(string);
        }
        return node;
    }

    private static Node makeCDATASection(Document document, String string) {
        Node node = OutOfBandUtil.getNodeByType((short)4, document);
        if (node != null) {
            ((CDATASection)node).setData(string);
        } else {
            node = document.createCDATASection(string);
        }
        return node;
    }

    private static Node makeComment(Document document, String string) {
        Node node = OutOfBandUtil.getNodeByType((short)8, document);
        if (node != null) {
            ((Comment)node).setData(string);
        } else {
            node = document.createComment(string);
        }
        return node;
    }

    public static void reuseRootElement(Document document, String string, int n) {
        Element element = document.getDocumentElement();
        XmlNodeFactory.renameNode(document, element, string);
        String string2 = BaseObjectHelper.integerToString(n, INDEX_ATTR);
        element.setAttribute(INDEX_NAME, string2);
    }

    public static void reuseRootElement(Document document, String string) {
        Element element = document.getDocumentElement();
        DOMUtil.removeAttributeNodes((Element)element);
        XmlNodeFactory.renameNode(document, element, string);
    }

    private static void renameNode(Document document, Node node, String string) {
        ((CoreDocumentImpl)document).renameNode(node, null, string);
    }

    static String getEleBuildInfoVersionAndDate() {
        return XmlTagFactory.getEleBuildInfoVersionAndDate();
    }

    static String getCoreBuildInfoVersionAndDate() {
        return XmlTagFactory.getCoreBuildInfoVersionAndDate();
    }

    static String decomment(String string) {
        return XmlTagFactory.decomment(string);
    }

    static String getStackTrace(Exception exception) {
        return XmlTagFactory.getStackTrace(exception);
    }

    static String rules(String string) {
        return XmlTagFactory.rules(string);
    }

    private XmlNodeFactory() {
    }
}

