/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.xml.helper;

import cerent.cms.model.CTCUserException;
import cerent.cms.xml.SchemaTagFactory;
import cerent.cms.xml.helper.BaseObjectHelper;
import cerent.cms.xml.helper.SchemaHelper;
import cerent.util.xml.DOMUtil;
import org.w3c.dom.Node;

public class ByteArrayHelper
extends BaseObjectHelper {
    public static Node objectToXml(Object object, String string, Node node) throws CTCUserException {
        if (db.on()) {
            db.println("[ByteArrayHelper] objectToXml(" + object + ", " + string + ") ");
        }
        byte[] byArray = (byte[])object;
        String string2 = new String(byArray);
        String string3 = ByteArrayHelper.encodeBytes(byArray);
        if (db.on()) {
            db.print(" Byte Array = " + string2);
            db.println(" Byte Array Format " + string3);
        }
        return BaseObjectHelper.objectToXml(string3, string, node);
    }

    public static Object nodeToObject(Node node, String string) throws CTCUserException {
        if (db.on()) {
            db.print("[ByteArrayHelper] nodeToObject(" + node.getNodeName() + ", " + string + ") ");
            db.print("[StringHelper] node is " + DOMUtil.nodeToString((Node)node));
        }
        String string2 = "";
        if (node.getFirstChild() != null) {
            string2 = node.getFirstChild().getNodeValue();
        } else if (db.on()) {
            db.println("[WARNING] with return value NULL");
        }
        return ByteArrayHelper.decodeBytes(string2);
    }

    public static Object toSchema(String string, String string2) throws CTCUserException {
        SchemaHelper.createByteArrayType();
        return SchemaTagFactory.createClosedElementUserTypeTag(string, "ByteArray");
    }

    private static String encodeBytes(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray.length; ++i) {
            int n;
            if (i > 0) {
                stringBuilder.append("-");
            }
            if ((n = byArray[i] & 0xFF) < 16) {
                stringBuilder.append("0");
            }
            stringBuilder.append(Integer.toHexString(n));
        }
        return stringBuilder.toString();
    }

    private static byte[] decodeBytes(String string) throws CTCUserException {
        int n = string != null && string.length() > 0 ? string.length() / 3 + 1 : 0;
        byte[] byArray = new byte[n];
        if (string == null) {
            return byArray;
        }
        int n2 = 0;
        int n3 = 0;
        while (n2 < string.length() && n3 < byArray.length) {
            char c = string.charAt(n2);
            if (c == '-') {
                ++n2;
                continue;
            }
            String string2 = string.substring(n2, n2 + 2);
            try {
                int n4 = Integer.parseInt(string2, 16);
                byArray[n3++] = (byte)(n4 & 0xFF);
            }
            catch (NumberFormatException numberFormatException) {
                throw new CTCUserException("Input is not well formed: " + string);
            }
            n2 += 2;
        }
        if (n3 != byArray.length) {
            throw new CTCUserException("Parsing error occurred.  Possibly the input is not well formed: " + string);
        }
        return byArray;
    }

    public static String regEx() {
        return "([0-9a-fA-F]{2}-)*[0-9a-fA-F]{2}";
    }
}

