/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.xml.helper;

import cerent.cms.model.CTCUserException;
import cerent.cms.xml.ISimpleMetaData;
import cerent.cms.xml.MetaData;
import cerent.cms.xml.MetaDataRepository;
import cerent.cms.xml.MethodTypeInfo;
import cerent.cms.xml.SchemaTagFactory;
import cerent.cms.xml.TypeInfoRepository;
import cerent.cms.xml.XmlHelperFactory;
import cerent.cms.xml.helper.Helper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;

public class SchemaHelper {
    private static String CHILDREN_TYPE = "ChildrenType";
    private static String FAULT = "fault";
    private static boolean CHAR_ADDED = false;
    private static boolean MAC_ADDED = false;
    private static boolean SUBNET_ADDED = false;
    private static boolean BYTE_ARRAY_ADDED = false;
    private static boolean INDEX_ADDED = false;
    private static boolean IP_ADDED = false;
    private static boolean BASE_MODELS_ADDED = false;
    private static final int SUCCESS = 0;
    private static final int FAILURE = 1;
    public static final String METHOD = "toSchema";
    private static ArrayList baseModels = new ArrayList();
    private static MetaDataRepository metadata = null;
    private static HashSet allModels = null;
    private static TreeMap overloadedMetaData = new TreeMap();
    private static TreeMap schemaGlobals = new TreeMap();
    private static TreeMap schemaRefs = new TreeMap();
    private static TreeMap schemaLocals = new TreeMap();
    private static TreeMap modelSchema = new TreeMap();
    public static final String NO_PERMISSION = "NO_PERMISSION";
    public static final String NO_ARGUMENTS = "NO_ARGUMENTS";
    public static final String CUSTOM = "CUSTOM";
    private static final String SEQUENCE = "Sequence";
    private static final String STRING_TAG_HELPER = "StringTag";
    public static final String ACTION = "action";
    private static final String BASE_OBJECT_HELPER = "cerent.cms.xml.helper.BaseObject";
    public static String currentModel = "";
    public static String currentAttrMeth = "";

    public static int addToSchemaGlobals(String string, String string2) {
        int n = 0;
        if (allModels == null) {
            try {
                SchemaHelper.getMetaData();
                allModels = (HashSet)MetaDataRepository.getModelClassnamesSet();
            }
            catch (CTCUserException cTCUserException) {
                allModels = new HashSet();
            }
        }
        if (!allModels.contains(string)) {
            if (!schemaGlobals.containsKey(string)) {
                schemaGlobals.put(string, string2);
            } else {
                try {
                    String string3 = (String)schemaGlobals.get(string);
                    if (!string3.equals(string2)) {
                        throw new CTCUserException("Encountered two different schema definitions for " + string);
                    }
                }
                catch (Exception exception) {
                    n = 1;
                }
            }
        } else {
            n = 1;
        }
        return n;
    }

    public static void addToBaseModels(String string) {
        baseModels.add(string);
    }

    public static TreeMap getModelSchema() {
        return modelSchema;
    }

    public static String getSchemaGlobals() {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator iterator = schemaGlobals.values().iterator();
        while (iterator.hasNext()) {
            stringBuilder.append((String)iterator.next());
        }
        if (BASE_MODELS_ADDED) {
            stringBuilder.append(SchemaTagFactory.createBaseModelsType(baseModels.toArray()));
        }
        return stringBuilder.toString();
    }

    public static String finishAndGetModelSchema() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : modelSchema.keySet()) {
            StringBuilder stringBuilder2 = (StringBuilder)modelSchema.get(string);
            stringBuilder.append((CharSequence)stringBuilder2);
        }
        return stringBuilder.toString();
    }

    public static void addModel(String string) {
        SchemaHelper.addModel(string, null);
    }

    public static void addModel(String string, String[] stringArray) {
        currentModel = string;
        if (!SchemaHelper.getTypeInfo().isProductExcluded(string)) {
            Object object;
            Object object2;
            Object object3;
            int n = string.lastIndexOf(46);
            String string2 = string.substring(n + 1);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(SchemaTagFactory.createElementTag(string2));
            stringBuilder.append(SchemaTagFactory.createOpenTag(SchemaTagFactory.COMPLEX_TAG));
            stringBuilder.append(SchemaTagFactory.createOpenTag(SchemaTagFactory.CHOICE_TAG));
            String string3 = "get" + string2;
            stringBuilder.append(SchemaHelper.createMessageSchema(string3));
            stringBuilder.append(SchemaTagFactory.createElementTag(string3 + "Response"));
            stringBuilder.append(SchemaTagFactory.createOpenTag(SchemaTagFactory.COMPLEX_TAG));
            stringBuilder.append(SchemaTagFactory.createUnboundedChoiceTag());
            StringBuilder stringBuilder2 = new StringBuilder();
            LinkedList linkedList = new LinkedList();
            LinkedList linkedList2 = SchemaHelper.getMetaData().getAttributeNames(string);
            if (linkedList2 != null) {
                linkedList.addAll(linkedList2);
            }
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    linkedList2 = SchemaHelper.getMetaData().getAttributeNames(stringArray[i]);
                    if (linkedList2 == null) continue;
                    linkedList.addAll(linkedList2);
                }
            }
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                MetaData metaData;
                currentAttrMeth = object3 = (String)iterator.next();
                try {
                    metaData = (MetaData)SchemaHelper.getMetaData().getMetData((String)object3);
                }
                catch (Exception exception) {
                    SchemaHelper.printStackTrace(exception, "MetaData not found for " + (String)object3);
                    metaData = null;
                }
                if (metaData == null) continue;
                int n2 = ((String)object3).indexOf(36);
                object2 = ((String)object3).substring(n2 + 1);
                object = SchemaHelper.getAttributeTag((String)object2, (String)object3, metaData);
                if (!metaData.getIsAction()) {
                    stringBuilder.append((String)object);
                }
                stringBuilder2.append(SchemaHelper.buildGetAttribute((String)object2, (String)object3, metaData));
                stringBuilder2.append(SchemaHelper.buildSetAttribute((String)object2, (String)object3, metaData));
            }
            object3 = SchemaHelper.getTypeInfo().getFullyQualifiedMethodNames(string);
            for (int i = 0; i < ((LinkedList)object3).size(); ++i) {
                String string4;
                currentAttrMeth = string4 = (String)((LinkedList)object3).get(i);
                object2 = SchemaHelper.getTypeInfo().getOverloadedMethods(string4);
                object = (MetaData)overloadedMetaData.get(string4);
                if (object2 != null && object2.size() <= 1 && object == null) {
                    MethodTypeInfo methodTypeInfo = (MethodTypeInfo)object2.get(0);
                    String string5 = methodTypeInfo.getMethodName();
                    if (!methodTypeInfo.hasVoidReturnType()) {
                        if (!methodTypeInfo.hasProblemReturnType()) {
                            String string6 = SchemaHelper.getAttributeTag(string5, string4, methodTypeInfo);
                            if (!methodTypeInfo.getIsAction()) {
                                stringBuilder.append(string6);
                            }
                        } else {
                            System.out.println("Warning:  cannot generate schema for " + string4 + " due to problem return type.");
                        }
                    }
                    if (!methodTypeInfo.hasProblemArgType()) {
                        stringBuilder2.append(SchemaHelper.buildPublicMethod(methodTypeInfo, string5));
                        continue;
                    }
                    System.out.println("Warning:  cannot generate schema for " + string4 + " due to argument type problem.");
                    continue;
                }
                if ((object2 == null || object2.size() <= 1) && object == null) continue;
                stringBuilder2.append(SchemaHelper.buildPublicMethod((List)object2, (MetaData)object, string4));
            }
            stringBuilder.append(SchemaTagFactory.createCloseTag(SchemaTagFactory.CHOICE_TAG));
            stringBuilder.append(SchemaTagFactory.createIndexRefTag(false));
            stringBuilder.append(SchemaTagFactory.createCloseTag(SchemaTagFactory.COMPLEX_TAG));
            stringBuilder.append(SchemaTagFactory.createCloseTag(SchemaTagFactory.ELEMENT_TAG));
            stringBuilder2.append(SchemaTagFactory.createCloseTag(SchemaTagFactory.CHOICE_TAG));
            stringBuilder2.append(SchemaTagFactory.createIndexRefTag(true));
            stringBuilder2.append(SchemaTagFactory.createCloseTag(SchemaTagFactory.COMPLEX_TAG));
            stringBuilder2.append(SchemaTagFactory.createCloseTag(SchemaTagFactory.ELEMENT_TAG));
            stringBuilder.append((CharSequence)stringBuilder2);
            modelSchema.put(string, stringBuilder);
            baseModels.add(string2);
        }
    }

    public static void createCharType() {
        if (!CHAR_ADDED) {
            SchemaHelper.addToSchemaGlobals("char", SchemaTagFactory.createSimpleCharType());
            CHAR_ADDED = true;
        }
    }

    public static void createMacAddrType() {
        if (!MAC_ADDED) {
            SchemaHelper.addToSchemaGlobals("MACAddr", SchemaTagFactory.createMacAddrType());
            MAC_ADDED = true;
        }
    }

    public static void createSubnetAddrType() {
        if (!SUBNET_ADDED) {
            SchemaHelper.addToSchemaGlobals("SubnetAddr", SchemaTagFactory.createSubnetAddrType());
            SUBNET_ADDED = true;
        }
    }

    public static void createByteArrayType() {
        if (!BYTE_ARRAY_ADDED) {
            SchemaHelper.addToSchemaGlobals("ByteArray", SchemaTagFactory.createByteArrayType());
            BYTE_ARRAY_ADDED = true;
        }
    }

    public static void createIpAddrType() {
        if (!IP_ADDED) {
            SchemaHelper.addToSchemaGlobals("IPAddr", SchemaTagFactory.createIpAddrType());
            IP_ADDED = true;
        }
    }

    public static void createEnumType(String string, String[] stringArray) {
        if (!schemaGlobals.containsKey(string)) {
            SchemaHelper.addToSchemaGlobals(string, SchemaTagFactory.createEnumType(string, stringArray));
        }
    }

    public static void createUnionType(String string, String[] stringArray) {
        if (!schemaGlobals.containsKey(string)) {
            SchemaHelper.addToSchemaGlobals(string, SchemaTagFactory.createUnionType(string, stringArray));
        }
    }

    public static void createBaseModelsType() {
        if (!BASE_MODELS_ADDED) {
            BASE_MODELS_ADDED = true;
        }
    }

    public static String createMessageSchema(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(SchemaTagFactory.createElementTag(string));
        stringBuilder.append(SchemaTagFactory.createOpenTag(SchemaTagFactory.COMPLEX_TAG));
        stringBuilder.append(SchemaTagFactory.createIndexRefTag(true));
        stringBuilder.append(SchemaTagFactory.createCloseTag(SchemaTagFactory.COMPLEX_TAG));
        stringBuilder.append(SchemaTagFactory.createCloseTag(SchemaTagFactory.ELEMENT_TAG));
        return stringBuilder.toString();
    }

    public static String getAttributeTag(String string, String string2, ISimpleMetaData iSimpleMetaData) {
        String string3 = "";
        StringBuilder stringBuilder = new StringBuilder();
        String string4 = iSimpleMetaData.getReturnHelper();
        String string5 = iSimpleMetaData.getReturnType();
        if (!string4.equals(NO_PERMISSION)) {
            if (!string4.equals(CUSTOM) && SchemaHelper.helperRequiresMetadata(string4)) {
                stringBuilder.append(SchemaHelper.handleHelperWithMetadata(string, iSimpleMetaData));
            } else {
                stringBuilder.append(SchemaHelper.handleHelperPrep(string2, string4, string, string5, 0));
            }
        }
        if (stringBuilder.length() > 0) {
            int n = SchemaHelper.addToSchemaGlobals(string, stringBuilder.toString());
            if (n != 0) {
                schemaLocals.put(string2, stringBuilder.toString());
                string3 = stringBuilder.toString();
            } else {
                string3 = SchemaHelper.getRefTag(stringBuilder.toString(), string);
                schemaRefs.put(string2, string3);
            }
        }
        return string3;
    }

    public static String buildGetAttribute(String string, String string2, MetaData metaData) {
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = metaData.getGETArgNames();
        String string3 = "get" + string;
        String string4 = string2.substring(0, string2.lastIndexOf(36));
        String string5 = MethodTypeInfo.createFullyQualifiedMethodName(string4, string3);
        List list = SchemaHelper.getTypeInfo().getOverloadedMethods(string5);
        if (list != null && list.size() > 0) {
            overloadedMetaData.put(string5, metaData);
        } else if (!stringArray[0].equals(NO_PERMISSION)) {
            String[] stringArray2;
            String[] stringArray3;
            stringBuilder.append(SchemaTagFactory.createElementTag(string3));
            stringBuilder.append(SchemaTagFactory.createOpenTag(SchemaTagFactory.COMPLEX_TAG));
            if (!stringArray[0].equals(NO_ARGUMENTS)) {
                stringBuilder.append(SchemaTagFactory.createOpenTag(SchemaTagFactory.ALL_TAG));
                stringArray3 = metaData.getGETArgHelpers();
                stringArray2 = metaData.getGETArgTypes();
                for (int i = 0; i < stringArray3.length; ++i) {
                    String string6 = stringArray3[i];
                    String string7 = stringArray2[i];
                    stringBuilder.append(SchemaHelper.handleHelperPrep(string2, string6, stringArray[i], string7, 1));
                }
                stringBuilder.append(SchemaTagFactory.createCloseTag(SchemaTagFactory.ALL_TAG));
            }
            stringArray3 = new Boolean(metaData.getIsAction());
            stringArray2 = stringArray3.toString();
            stringBuilder.append(SchemaTagFactory.createAttributeTag(ACTION, "boolean", (String)stringArray2));
            stringBuilder.append(SchemaTagFactory.createCloseTag(SchemaTagFactory.COMPLEX_TAG));
            stringBuilder.append(SchemaTagFactory.createCloseTag(SchemaTagFactory.ELEMENT_TAG));
            string3 = string3 + "Response";
            stringBuilder.append(SchemaTagFactory.createElementTag(string3));
            stringBuilder.append(SchemaTagFactory.createOpenTag(SchemaTagFactory.COMPLEX_TAG));
            if (schemaRefs.containsKey(string2)) {
                stringBuilder.append(SchemaTagFactory.createOpenTag(SchemaTagFactory.CHOICE_TAG));
                stringBuilder.append(schemaRefs.get(string2));
                stringBuilder.append(SchemaTagFactory.createCloseTag(SchemaTagFactory.CHOICE_TAG));
            } else if (schemaLocals.containsKey(string2)) {
                stringBuilder.append(SchemaTagFactory.createOpenTag(SchemaTagFactory.CHOICE_TAG));
                stringBuilder.append(schemaLocals.get(string2));
                stringBuilder.append(SchemaTagFactory.createCloseTag(SchemaTagFactory.CHOICE_TAG));
            }
            stringBuilder.append(SchemaTagFactory.createCloseTag(SchemaTagFactory.COMPLEX_TAG));
            stringBuilder.append(SchemaTagFactory.createCloseTag(SchemaTagFactory.ELEMENT_TAG));
        }
        return stringBuilder.toString();
    }

    public static String buildSetAttribute(String string, String string2, MetaData metaData) {
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = metaData.getSETArgNames();
        String string3 = "set" + string;
        String string4 = string2.substring(1, string2.lastIndexOf(36));
        String string5 = MethodTypeInfo.createFullyQualifiedMethodName(string4, string3);
        List list = SchemaHelper.getTypeInfo().getOverloadedMethods(string5);
        if (list != null && list.size() > 0) {
            overloadedMetaData.put(string5, metaData);
        } else if (!stringArray[0].equals(NO_PERMISSION)) {
            stringBuilder.append(SchemaTagFactory.createElementTag(string3));
            stringBuilder.append(SchemaTagFactory.createOpenTag(SchemaTagFactory.COMPLEX_TAG));
            if (!stringArray[0].equals(NO_ARGUMENTS)) {
                stringBuilder.append(SchemaTagFactory.createOpenTag(SchemaTagFactory.ALL_TAG));
                String[] stringArray2 = metaData.getSETArgHelpers();
                String[] stringArray3 = metaData.getSETArgTypes();
                for (int i = 0; i < stringArray2.length; ++i) {
                    String string6 = stringArray2[i];
                    String string7 = stringArray3[i];
                    if (stringArray[i].equals(string)) {
                        if (!schemaRefs.containsKey(string2)) {
                            String string8 = SchemaHelper.handleHelperPrep(string2, string6, string, string7, 1);
                            if (string8.length() <= 0) continue;
                            int n = SchemaHelper.addToSchemaGlobals(string, string8);
                            if (n != 0) {
                                stringBuilder.append(string8.toString());
                                continue;
                            }
                            stringBuilder.append(SchemaHelper.getRefTag(string8.toString(), string));
                            continue;
                        }
                        stringBuilder.append((String)schemaRefs.get(string2));
                        continue;
                    }
                    stringBuilder.append(SchemaHelper.handleHelperPrep(string2, string6, stringArray[i], string7, 1));
                }
                stringBuilder.append(SchemaTagFactory.createCloseTag(SchemaTagFactory.ALL_TAG));
            }
            stringBuilder.append(SchemaTagFactory.createCloseTag(SchemaTagFactory.COMPLEX_TAG));
            stringBuilder.append(SchemaTagFactory.createCloseTag(SchemaTagFactory.ELEMENT_TAG));
            string3 = string3 + "Response";
            stringBuilder.append(SchemaTagFactory.createElementTag(string3));
            stringBuilder.append(SchemaTagFactory.createEmptyTag(SchemaTagFactory.COMPLEX_TAG));
            stringBuilder.append(SchemaTagFactory.createCloseTag(SchemaTagFactory.ELEMENT_TAG));
        }
        return stringBuilder.toString();
    }

    public static String buildPublicMethod(MethodTypeInfo methodTypeInfo, String string) {
        String[] stringArray;
        String[] stringArray2;
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = methodTypeInfo.getFullyQualifiedMethodName();
        String[] stringArray3 = methodTypeInfo.getArgNames();
        String string3 = string;
        stringBuilder.append(SchemaTagFactory.createElementTag(string3));
        stringBuilder.append(SchemaTagFactory.createOpenTag(SchemaTagFactory.COMPLEX_TAG));
        if (stringArray3.length > 0) {
            stringBuilder.append(SchemaTagFactory.createOpenTag(SchemaTagFactory.SEQUENCE_TAG));
            stringArray2 = methodTypeInfo.getArgHelpers();
            stringArray = methodTypeInfo.getArgTypes();
            for (int i = 0; i < stringArray2.length; ++i) {
                String string4 = stringArray2[i];
                String string5 = stringArray[i];
                if (SchemaHelper.helperRequiresMetadata(string4)) {
                    String string6 = stringArray3[i];
                    String string7 = string2 + "." + string6;
                    stringBuilder.append(SchemaHelper.getAttributeTag(string6, string7, methodTypeInfo.getTypes()[i]));
                    continue;
                }
                stringBuilder.append(SchemaHelper.handleHelperPrep(string2, string4, stringArray3[i], string5, 1));
            }
            stringBuilder.append(SchemaTagFactory.createCloseTag(SchemaTagFactory.SEQUENCE_TAG));
        }
        stringArray2 = new Boolean(methodTypeInfo.getIsAction());
        stringArray = stringArray2.toString();
        stringBuilder.append(SchemaTagFactory.createAttributeTag(ACTION, "boolean", (String)stringArray));
        stringBuilder.append(SchemaTagFactory.createCloseTag(SchemaTagFactory.COMPLEX_TAG));
        stringBuilder.append(SchemaTagFactory.createCloseTag(SchemaTagFactory.ELEMENT_TAG));
        string3 = string3 + "Response";
        stringBuilder.append(SchemaTagFactory.createElementTag(string3));
        stringBuilder.append(SchemaTagFactory.createOpenTag(SchemaTagFactory.COMPLEX_TAG));
        if (schemaRefs.containsKey(string2)) {
            stringBuilder.append(SchemaTagFactory.createOpenTag(SchemaTagFactory.CHOICE_TAG));
            stringBuilder.append(schemaRefs.get(string2));
            stringBuilder.append(SchemaTagFactory.createCloseTag(SchemaTagFactory.CHOICE_TAG));
        } else if (schemaLocals.containsKey(string2)) {
            stringBuilder.append(SchemaTagFactory.createOpenTag(SchemaTagFactory.CHOICE_TAG));
            stringBuilder.append(schemaLocals.get(string2));
            stringBuilder.append(SchemaTagFactory.createCloseTag(SchemaTagFactory.CHOICE_TAG));
        }
        stringBuilder.append(SchemaTagFactory.createCloseTag(SchemaTagFactory.COMPLEX_TAG));
        stringBuilder.append(SchemaTagFactory.createCloseTag(SchemaTagFactory.ELEMENT_TAG));
        return stringBuilder.toString();
    }

    public static String buildPublicMethod(List list, MetaData metaData, String string) {
        String string2;
        String string3;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        HashSet<String> hashSet = new HashSet<String>();
        boolean bl = false;
        boolean bl2 = false;
        String string4 = "";
        for (n = 0; n < list.size(); ++n) {
            object4 = (String[])list.get(n);
            string4 = ((MethodTypeInfo)object4).getMethodName();
            object3 = ((MethodTypeInfo)object4).getArgNames();
            if (((String[])object3).length > 0) {
                String string5;
                if (((String[])object3).length == 1) {
                    object2 = ((MethodTypeInfo)object4).getArgHelpers();
                    object = ((MethodTypeInfo)object4).getArgTypes();
                    String string6 = object2[0];
                    string3 = object[0];
                    if (SchemaHelper.helperRequiresMetadata(string6)) {
                        string2 = object3[n];
                        string5 = string + "." + string2;
                        stringBuilder2.append(SchemaHelper.getAttributeTag(string2, string5, ((MethodTypeInfo)object4).getTypes()[n]));
                    } else {
                        stringBuilder2.append(SchemaHelper.handleHelperPrep(string, string6, object3[0], string3, 1));
                    }
                } else {
                    stringBuilder2.append(SchemaTagFactory.createOpenTag(SchemaTagFactory.SEQUENCE_TAG));
                    object2 = ((MethodTypeInfo)object4).getArgHelpers();
                    object = ((MethodTypeInfo)object4).getArgTypes();
                    for (int i = 0; i < ((String[])object2).length; ++i) {
                        string3 = object2[i];
                        string2 = object[i];
                        if (SchemaHelper.helperRequiresMetadata(string3)) {
                            string5 = object3[i];
                            String string7 = string + "." + string5;
                            stringBuilder2.append(SchemaHelper.getAttributeTag(string5, string7, ((MethodTypeInfo)object4).getTypes()[i]));
                            continue;
                        }
                        stringBuilder2.append(SchemaHelper.handleHelperPrep(string, string3, object3[i], string2, 1));
                    }
                    stringBuilder2.append(SchemaTagFactory.createCloseTag(SchemaTagFactory.SEQUENCE_TAG));
                }
            } else {
                bl = true;
            }
            if (((MethodTypeInfo)object4).hasVoidReturnType()) {
                bl2 = true;
                continue;
            }
            hashSet.add(SchemaHelper.getAttributeTag(((MethodTypeInfo)object4).getMethodName(), string, (ISimpleMetaData)object4));
        }
        if (metaData != null) {
            string4 = string.substring(string.lastIndexOf(".") + 1);
            n = 1;
            if (string4.startsWith("set")) {
                n = 0;
            }
            if ((object3 = ((String[])(object4 = n != 0 ? metaData.getGETArgNames() : metaData.getSETArgNames())).length == 1 && object4[0].equals(NO_ARGUMENTS) ? SchemaHelper.getTypeInfo().checkForMatchingArgNames(string, null) : SchemaHelper.getTypeInfo().checkForMatchingArgNames(string, (String[])object4)) != null) {
                System.out.println("ERROR:  Exact overload of " + string + " between CTCMetaData.ini and CTCTypeInfo.xml.");
                System.out.println("Remove one occurrence of the definition, then rerun schema generation.\n");
                return "";
            }
            if (((String[])object4).length > 0 && !object4[0].equals(NO_ARGUMENTS)) {
                if (((String[])object4).length > 1) {
                    stringBuilder2.append(SchemaTagFactory.createOpenTag(SchemaTagFactory.SEQUENCE_TAG));
                }
                object2 = n != 0 ? metaData.getGETArgHelpers() : metaData.getSETArgHelpers();
                object = n != 0 ? metaData.getGETArgTypes() : metaData.getSETArgTypes();
                for (int i = 0; i < ((String[])object2).length; ++i) {
                    string3 = object2[i];
                    string2 = object[i];
                    stringBuilder2.append(SchemaHelper.handleHelperPrep(string, string3, object4[i], string2, 1));
                }
                if (((String[])object4).length > 1) {
                    stringBuilder2.append(SchemaTagFactory.createCloseTag(SchemaTagFactory.SEQUENCE_TAG));
                }
            } else {
                bl = true;
            }
            if (n != 0 && metaData.getReturnHelper() == NO_ARGUMENTS || n == 0) {
                bl2 = true;
            } else {
                object2 = string4.substring(3);
                object = string.substring(0, string.lastIndexOf(".")) + "$" + (String)object2;
                hashSet.add(SchemaHelper.getAttributeTag((String)object2, (String)object, metaData));
            }
        }
        String string8 = string4;
        stringBuilder.append(SchemaTagFactory.createElementTag(string8));
        stringBuilder.append(SchemaTagFactory.createOpenTag(SchemaTagFactory.COMPLEX_TAG));
        if (bl) {
            stringBuilder.append(SchemaTagFactory.createZeroChoiceTag());
        } else {
            stringBuilder.append(SchemaTagFactory.createSingleChoiceTag());
        }
        stringBuilder.append(stringBuilder2.toString());
        stringBuilder.append(SchemaTagFactory.createCloseTag(SchemaTagFactory.CHOICE_TAG));
        stringBuilder.append(SchemaTagFactory.createAttributeTag(ACTION, "boolean", "true"));
        stringBuilder.append(SchemaTagFactory.createCloseTag(SchemaTagFactory.COMPLEX_TAG));
        stringBuilder.append(SchemaTagFactory.createCloseTag(SchemaTagFactory.ELEMENT_TAG));
        string8 = string8 + "Response";
        stringBuilder.append(SchemaTagFactory.createElementTag(string8));
        stringBuilder.append(SchemaTagFactory.createOpenTag(SchemaTagFactory.COMPLEX_TAG));
        if (bl2) {
            stringBuilder.append(SchemaTagFactory.createZeroChoiceTag());
        } else {
            stringBuilder.append(SchemaTagFactory.createSingleChoiceTag());
        }
        object4 = hashSet.iterator();
        while (object4.hasNext()) {
            stringBuilder.append((String)object4.next());
        }
        stringBuilder.append(SchemaTagFactory.createCloseTag(SchemaTagFactory.CHOICE_TAG));
        stringBuilder.append(SchemaTagFactory.createCloseTag(SchemaTagFactory.COMPLEX_TAG));
        stringBuilder.append(SchemaTagFactory.createCloseTag(SchemaTagFactory.ELEMENT_TAG));
        return stringBuilder.toString();
    }

    private static String getRefTag(String string, String string2) {
        String string3 = "";
        String string4 = string2 + "Array";
        String string5 = string2 + "Collection";
        String string6 = string2 + "Map";
        string3 = string.indexOf(string4) > 0 ? SchemaTagFactory.createElementRefTag(string4) : (string.indexOf(string5) > 0 ? SchemaTagFactory.createElementRefTag(string5) : (string.indexOf(string6) > 0 ? SchemaTagFactory.createElementRefTag(string6) : SchemaTagFactory.createElementRefTag(string2)));
        return string3;
    }

    public static MetaDataRepository getMetaData() {
        if (metadata == null) {
            try {
                metadata = MetaDataRepository.getInstance();
            }
            catch (Exception exception) {
                System.out.println("Could not get instance of MetaDataRepository.");
                exception.printStackTrace();
                System.out.println("Schema NOT generated.");
                System.exit(0);
            }
        }
        return metadata;
    }

    public static TypeInfoRepository getTypeInfo() {
        return SchemaHelper.getMetaData().getTypeInfoRepository();
    }

    public static MetaData getOverloadedMetaData(String string) {
        return (MetaData)overloadedMetaData.get(string);
    }

    public static String handleHelperPrep(String string, String string2, String string3, String string4, int n) {
        Object[] objectArray;
        Class[] classArray;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            classArray = Helper.converter.getConvertClass(string4, n);
            if (classArray != null) {
                string4 = classArray.getName();
            }
        }
        catch (Exception exception) {
            objectArray = "Warning:  schema for " + string + " will not be accurate due to " + "problem in type conversion for" + string4;
            SchemaHelper.printStackTrace(exception, (String)objectArray);
        }
        classArray = new Class[]{String.class, String.class};
        objectArray = new Object[]{string3, string4};
        if (string2.equals(CUSTOM)) {
            stringBuilder.append(SchemaHelper.callHelper(string, classArray, objectArray));
        } else {
            stringBuilder.append(SchemaHelper.callHelper(string2, classArray, objectArray));
        }
        return stringBuilder.toString();
    }

    public static String handleHelperWithMetadata(String string, ISimpleMetaData iSimpleMetaData) {
        StringBuilder stringBuilder = new StringBuilder();
        Class[] classArray = new Class[]{String.class, ISimpleMetaData.class};
        Object[] objectArray = new Object[]{string, iSimpleMetaData};
        stringBuilder.append(SchemaHelper.callHelper(iSimpleMetaData.getReturnHelper(), classArray, objectArray));
        return stringBuilder.toString();
    }

    private static Object callHelper(String string, Class[] classArray, Object[] objectArray) {
        Object object;
        Object object2 = "";
        Class clazz = null;
        Method method = null;
        boolean bl = false;
        try {
            clazz = XmlHelperFactory.getXmlHelperBasedOnClassName(string);
            method = clazz.getMethod(METHOD, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            bl = true;
        }
        catch (Exception exception) {
            object = "callHelper() failed.  The helper Class for " + string + " could not be found.";
            SchemaHelper.printStackTrace(exception, (String)object);
            clazz = null;
        }
        if (bl) {
            try {
                clazz = XmlHelperFactory.getXmlHelperBasedOnClassName(BASE_OBJECT_HELPER);
                method = clazz.getMethod(METHOD, classArray);
            }
            catch (Exception exception) {
                object = "callHelper() failed.  The method toSchema could not be found on helper Class " + string + " or on BaseObjectHelper.";
                SchemaHelper.printStackTrace(exception, (String)object);
                clazz = null;
            }
        }
        if (clazz != null) {
            try {
                method.setAccessible(true);
                object2 = method.invoke(null, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                object = invocationTargetException.getTargetException();
                String string2 = "Invoke failed for method toSchema on helper " + string;
                SchemaHelper.printStackTrace((Throwable)object, string2);
            }
            catch (Exception exception) {
                object = "Failure for method toSchema on helper " + string;
                SchemaHelper.printStackTrace(exception, (String)object);
            }
        }
        return object2;
    }

    private static boolean helperRequiresMetadata(String string) {
        Class clazz = null;
        String string2 = "requiresMetadata";
        Object object = null;
        try {
            clazz = XmlHelperFactory.getXmlHelperBasedOnClassName(string);
            Method method = clazz.getMethod(string2, new Class[0]);
            if (method != null) {
                method.setAccessible(true);
                object = method.invoke(null, new Object[0]);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            String string3 = "Invoke failed for method " + string2 + " on helper " + string;
            SchemaHelper.printStackTrace(throwable, string3);
        }
        catch (Exception exception) {
            String string4 = "Failure for method " + string2 + " on helper " + string;
            SchemaHelper.printStackTrace(exception, string4);
        }
        boolean bl = false;
        if (object != null) {
            bl = (Boolean)object;
        }
        return bl;
    }

    public static void printStackTrace(Throwable throwable, String string) {
        System.out.println("\nSchema will continue processing, but . . .");
        System.out.println(string);
        System.out.println("Current Model is " + currentModel + "\nand current Attribute/Method is " + currentAttrMeth);
        throwable.printStackTrace();
    }
}

