/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.xml.helper;

import cerent.cms.model.CTCUserException;
import cerent.cms.xml.ReflectionUtil;
import cerent.cms.xml.SchemaTagFactory;
import cerent.cms.xml.XmlHelperFactory;
import cerent.cms.xml.XmlNodeFactory;
import cerent.cms.xml.helper.BaseObjectHelper;
import cerent.cms.xml.helper.Helper;
import cerent.util.CommonReflectionUtil;
import cerent.util.SDebug;
import cerent.util.xml.DOMUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StructHelper
extends BaseObjectHelper {
    public static Node objectToXml(Object object, String string, Node node) throws CTCUserException {
        if (db.on()) {
            db.println("[StructHelper] objectToXml(" + object + ", " + string + ") ");
        }
        Element element = XmlNodeFactory.makeElement(node, string);
        if (object != null) {
            Class<?> clazz = object.getClass();
            Field[] fieldArray = CommonReflectionUtil.getIFieldAccess().getFields(clazz);
            if (db.on()) {
                db.println("[StructHelper] publicFields : " + fieldArray.length);
            }
            for (int i = 0; i < fieldArray.length; ++i) {
                String string2 = fieldArray[i].getName();
                String string3 = fieldArray[i].getType().getName();
                Object object2 = "NOT_ASSIGNED";
                try {
                    object2 = fieldArray[i].get(object);
                }
                catch (IllegalAccessException illegalAccessException) {
                    object2 = illegalAccessException.toString();
                }
                if (object2 == null) continue;
                try {
                    Class<?> clazz2 = object2.getClass();
                    String string4 = clazz2.getName();
                    Class clazz3 = XmlHelperFactory.lookupHelperClass(clazz2);
                    Node node2 = Helper.objectToXmlUsingReflection(object2, string2, clazz3, object, node);
                    DOMUtil.appendChild((Node)element, (Node)node2);
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new CTCUserException("Unknown data type " + object2.getClass().getName() + " in struct " + string, (Throwable)classNotFoundException);
                }
            }
        }
        return element;
    }

    public static Object nodeToObject(Node node, String string, Object object) throws CTCUserException {
        if (db.on()) {
            db.print("[StructHelper] nodeToObject(" + node.getNodeName() + ", " + string + ") ");
        }
        Object var3_3 = null;
        try {
            Class clazz = ReflectionUtil.forName(string);
            var3_3 = clazz.newInstance();
            Field[] fieldArray = clazz.getFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                String string2 = fieldArray[i].getName();
                Class<?> clazz2 = fieldArray[i].getType();
                boolean bl = false;
                if (clazz2.isArray() && !string2.endsWith("Array")) {
                    if (clazz2.getName().equals("[I")) {
                        bl = true;
                    }
                    if (bl || !clazz2.getComponentType().isPrimitive()) {
                        string2 = string2 + "Array";
                    }
                }
                NodeList nodeList = ((Element)node).getElementsByTagName(string2);
                if (bl) {
                    int n = string2.indexOf("Array");
                    string2 = string2.substring(0, n);
                }
                if (nodeList.getLength() != 1) {
                    throw new CTCUserException("[StructHelper] One Element Expected! \nNumber of Elements by " + string2 + " = " + nodeList.getLength());
                }
                Node node2 = nodeList.item(0);
                String string3 = fieldArray[i].getType().getName();
                Object object2 = Helper.nodeToObjectUsingReflection(node2, string3, object);
                if (db.isFinerEnabled()) {
                    db.finer("about to set field: " + fieldArray[i] + " to: " + object2);
                }
                fieldArray[i].set(var3_3, object2);
            }
        }
        catch (CTCUserException cTCUserException) {
            if (StructHelper.db.on) {
                SDebug.printStackTrace((Throwable)cTCUserException);
            }
            throw cTCUserException;
        }
        catch (Exception exception) {
            if (StructHelper.db.on) {
                SDebug.printStackTrace((Throwable)exception);
            }
            throw new CTCUserException("In nodeToObject() " + exception.toString(), (Throwable)exception);
        }
        return var3_3;
    }

    public static Object toSchema(String string, String string2) throws CTCUserException {
        return StructHelper.getTag(string, string2);
    }

    private static String getTag(String string, String string2) throws CTCUserException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(SchemaTagFactory.createElementTag(string));
        stringBuilder.append(SchemaTagFactory.createOpenTag(SchemaTagFactory.COMPLEX_TAG));
        stringBuilder.append(SchemaTagFactory.createOpenTag(SchemaTagFactory.ALL_TAG));
        try {
            Class clazz = ReflectionUtil.forName(string2);
            Field[] fieldArray = clazz.getFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                String string3 = fieldArray[i].getName();
                String string4 = fieldArray[i].getType().getName();
                Class clazz2 = XmlHelperFactory.lookupHelperClass(ReflectionUtil.forName(string4));
                String string5 = "toSchema";
                Class[] classArray = new Class[]{String.class, String.class};
                Object[] objectArray = new Object[]{string3, string4};
                if (clazz2 == null) continue;
                Method method = clazz2.getMethod(string5, classArray);
                method.setAccessible(true);
                Object object = method.invoke(null, objectArray);
                stringBuilder.append(object.toString());
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            throwable.printStackTrace();
        }
        catch (Exception exception) {
            throw new CTCUserException("Struct not found: " + string2);
        }
        stringBuilder.append(SchemaTagFactory.createCloseTag(SchemaTagFactory.ALL_TAG));
        stringBuilder.append(SchemaTagFactory.createCloseTag(SchemaTagFactory.COMPLEX_TAG));
        stringBuilder.append(SchemaTagFactory.createCloseTag(SchemaTagFactory.ELEMENT_TAG));
        return stringBuilder.toString();
    }
}

