/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.util.AbstractLoNum;
import cerent.util.HoLoFactory;
import cerent.util.ILoNum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class LoNumCache {
    protected int framingType_;
    protected int[] sizeTypeEnums_;
    protected ArrayList sizeTypes_;

    public LoNumCache(int n, LoStructure[] loStructureArray, boolean bl) {
        Arrays.sort(loStructureArray);
        this.framingType_ = n;
        this.sizeTypeEnums_ = new int[loStructureArray.length];
        this.sizeTypes_ = new ArrayList(loStructureArray.length);
        for (int i = 0; i < loStructureArray.length; ++i) {
            int n2;
            LoStructure loStructure = loStructureArray[i];
            int n3 = loStructure.cktSize;
            int n4 = loStructure.maxGroupInVc3;
            int n5 = loStructure.maxNumInGroup;
            int n6 = loStructure.maxVc3;
            this.sizeTypeEnums_[i] = n2 = loStructure.sizeType;
            ILoNum[][][] iLoNumArray = new ILoNum[n6][n5][n4];
            this.sizeTypes_.add(iLoNumArray);
            for (int j = 1; j <= n6; ++j) {
                for (int k = 1; k <= n5; ++k) {
                    for (int i2 = 1; i2 <= n4; ++i2) {
                        int n7 = (j - 1) * n4 + i2;
                        iLoNumArray[j - 1][k - 1][i2 - 1] = !AbstractLoNum.IsValidGroup((int)n2, (int)n7) ? null : HoLoFactory._idlVtStruct2LoNum(this.framingType_, bl, n3, n7, k, false);
                    }
                }
            }
        }
    }

    public int getFramingType() {
        return this.framingType_;
    }

    protected ILoNum[][][] getSizeTypeList(int n) {
        ILoNum[][][] iLoNumArray = null;
        for (int i = 0; i < this.sizeTypeEnums_.length; ++i) {
            int n2 = this.sizeTypeEnums_[i];
            if (n2 == n) {
                iLoNumArray = (ILoNum[][][])this.sizeTypes_.get(i);
                break;
            }
            if (n2 > n) break;
        }
        return iLoNumArray;
    }

    protected ILoNum[][] getGrpList(int n, int n2) {
        ILoNum[][][] iLoNumArray = this.getSizeTypeList(n2);
        return iLoNumArray == null ? (ILoNum[][])null : iLoNumArray[n - 1];
    }

    public ILoNum getNumber(int n, int n2, int n3, int n4) {
        try {
            ILoNum[][] iLoNumArray = this.getGrpList(n, n4);
            return iLoNumArray == null ? null : iLoNumArray[n3 - 1][n2 - 1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public List getAllLoNums(int n) {
        ILoNum[][][] iLoNumArray = this.getSizeTypeList(n);
        ArrayList<ILoNum> arrayList = new ArrayList<ILoNum>();
        for (int i = 0; i < iLoNumArray.length; ++i) {
            ILoNum[][] iLoNumArray2 = iLoNumArray[i];
            for (int j = 0; j < iLoNumArray2.length; ++j) {
                for (int k = 0; k < iLoNumArray2[j].length; ++k) {
                    ILoNum iLoNum = iLoNumArray2[j][k];
                    if (iLoNum == null) continue;
                    arrayList.add(iLoNum);
                }
            }
        }
        return arrayList;
    }

    public static class LoStructure
    implements Comparable {
        public final int cktSize;
        public final int sizeType;
        public final int maxVc3;
        public final int maxGroupInVc3;
        public final int maxNumInGroup;

        public LoStructure(int n, int n2, int n3, int n4, int n5) {
            this.cktSize = n;
            this.sizeType = n2;
            this.maxGroupInVc3 = n4;
            this.maxNumInGroup = n5;
            this.maxVc3 = n3;
        }

        public int compareTo(Object object) {
            int n = 0;
            if (object instanceof LoStructure) {
                n = this.sizeType - ((LoStructure)object).sizeType;
            }
            return n;
        }
    }
}

