/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;

public abstract class AbstractCellEditor
implements TableCellEditor {
    protected EventListenerList listenerList = new EventListenerList();
    protected Object value;
    protected ChangeEvent changeEvent = null;
    protected int clickCountToStart = 1;

    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    public Object getCellEditorValue() {
        return this.value;
    }

    public void setCellEditorValue(Object object) {
        this.value = object;
    }

    public void setClickCountToStart(int n) {
        this.clickCountToStart = n;
    }

    public int getClickCountToStart() {
        return this.clickCountToStart;
    }

    public boolean isCellEditable(EventObject eventObject) {
        return !(eventObject instanceof MouseEvent) || ((MouseEvent)eventObject).getClickCount() >= this.clickCountToStart;
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.add(CellEditorListener.class, cellEditorListener);
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.remove(CellEditorListener.class, cellEditorListener);
    }

    protected void fireEditingStopped() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != CellEditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((CellEditorListener)objectArray[i + 1]).editingStopped(this.changeEvent);
        }
    }

    protected void fireEditingCanceled() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != CellEditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((CellEditorListener)objectArray[i + 1]).editingCanceled(this.changeEvent);
        }
    }
}

