/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import cerent.cms.ui.CSHelpButton;
import cerent.util.SDebug;
import cerent.util.gui.AbstractPropertyEditor;
import cerent.util.gui.CerentDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;

public abstract class AbstractPropertyDialogSheet
extends JPanel {
    private static final String APPLY = "Apply";
    private static final String CANCEL = "Cancel";
    private static final String OK = "OK";
    private Window parent;
    protected JButton applyButton;
    protected JButton cancelButton;
    protected JButton okButton;
    protected CSHelpButton helpButton;
    protected boolean okPressed = false;
    protected boolean enableCSH = false;
    public AbstractPropertyEditor lastFocusEditor = null;
    protected JPanel buttonPane = null;

    public AbstractPropertyDialogSheet(Window window) {
        this(window, false);
    }

    public AbstractPropertyDialogSheet(Window window, boolean bl) {
        this.parent = window;
        this.okPressed = false;
        this.enableCSH = bl;
        this.buttonPane = this.makeButtonPane();
        this.setLayout(new BorderLayout());
        this.add((Component)this.buttonPane, "South");
    }

    public JPanel makeButtonPane() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        this.applyButton = new JButton(APPLY);
        this.cancelButton = new JButton(CANCEL);
        this.okButton = new JButton(OK);
        this.applyButton.setEnabled(false);
        jPanel2.setLayout(new GridLayout(1, 0, 5, 0));
        jPanel2.add(this.okButton);
        jPanel2.add(this.cancelButton);
        jPanel2.add(this.applyButton);
        if (this.enableCSH) {
            this.helpButton = new CSHelpButton();
            jPanel2.add(this.helpButton);
        }
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 0));
        jPanel.add((Component)jPanel2, "East");
        this.applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (AbstractPropertyDialogSheet.this.onValidate()) {
                    AbstractPropertyDialogSheet.this.onApply();
                    AbstractPropertyDialogSheet.this.resetApply();
                } else {
                    AbstractPropertyDialogSheet.this.InvalidEditorRequestFocus();
                }
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                if (AbstractPropertyDialogSheet.this.applyButton.isEnabled() && (n = CerentDialog.questionDialog((Component)AbstractPropertyDialogSheet.this.getParent(), (String)"Changes have been made. Do you want to cancel anyway?", (String)"Confirm Cancel")) == 1) {
                    return;
                }
                AbstractPropertyDialogSheet.this.parent.dispose();
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (AbstractPropertyDialogSheet.this.onValidate()) {
                    AbstractPropertyDialogSheet.this.onApply();
                    AbstractPropertyDialogSheet.this.okPressed = true;
                    AbstractPropertyDialogSheet.this.parent.dispose();
                } else {
                    AbstractPropertyDialogSheet.this.InvalidEditorRequestFocus();
                }
            }
        });
        return jPanel;
    }

    public boolean okPressed() {
        return this.okPressed;
    }

    public abstract void InvalidEditorRequestFocus();

    public abstract boolean onValidate(Component var1);

    public abstract boolean onValidate();

    public void setApply() {
        if (this.applyButton.isVisible()) {
            this.applyButton.setEnabled(true);
        }
    }

    public abstract void resetApply();

    public abstract void onApply();

    public void removeApply() {
        try {
            JPanel jPanel = (JPanel)this.buttonPane.getComponent(0);
            jPanel.remove(this.applyButton);
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }
}

