/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import cerent.util.gui.CheckableItem;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIManager;

public class CheckableList
extends JList {
    public CheckableList() {
        this.setSelectionMode(0);
        this.setCellRenderer(new CheckListRenderer());
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = CheckableList.this.locationToIndex(mouseEvent.getPoint());
                try {
                    CheckableItem checkableItem = (CheckableItem)CheckableList.this.getModel().getElementAt(n);
                    checkableItem.setSelected(!checkableItem.isSelected());
                    Rectangle rectangle = CheckableList.this.getCellBounds(n, n);
                    CheckableList.this.repaint(rectangle);
                    CheckableList.this.fireSelectionEvent(n);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public void setData(Collection collection) {
        Vector<CheckableItem> vector = new Vector<CheckableItem>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            vector.add(new CheckableItem(iterator.next()));
        }
        this.setListData(vector);
    }

    public List getSelectedObjects() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ListModel listModel = this.getModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            CheckableItem checkableItem = (CheckableItem)listModel.getElementAt(i);
            if (!checkableItem.isSelected()) continue;
            arrayList.add(checkableItem.getObject());
        }
        return arrayList;
    }

    public void setSelectedObjects(List list) {
        ListModel listModel = this.getModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            CheckableItem checkableItem = (CheckableItem)listModel.getElementAt(i);
            checkableItem.setSelected(list.contains(checkableItem.getObject()));
        }
        this.repaint();
    }

    public void enableSelectedObjects(List list) {
        ListModel listModel = this.getModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            CheckableItem checkableItem = (CheckableItem)listModel.getElementAt(i);
            checkableItem.setEnabled(list.contains(checkableItem.getObject()));
        }
        this.repaint();
    }

    public void unselectAll() {
        ListModel listModel = this.getModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            CheckableItem checkableItem = (CheckableItem)listModel.getElementAt(i);
            checkableItem.setSelected(false);
        }
        this.repaint();
    }

    public void selectAll() {
        ListModel listModel = this.getModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            CheckableItem checkableItem = (CheckableItem)listModel.getElementAt(i);
            checkableItem.setSelected(true);
        }
        this.repaint();
    }

    public void fireSelectionEvent(int n) {
        this.fireSelectionValueChanged(n, n, false);
    }

    class CheckListRenderer
    extends JCheckBox
    implements ListCellRenderer {
        public CheckListRenderer() {
            this.setBackground(UIManager.getColor("List.textBackground"));
            this.setForeground(UIManager.getColor("List.textForeground"));
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setEnabled(jList.isEnabled() && ((CheckableItem)object).isEnabled());
            this.setSelected(((CheckableItem)object).isSelected());
            this.setFont(jList.getFont());
            this.setText(object.toString());
            return this;
        }
    }
}

