/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.ior;

import cerent.util.ior.CdrReader;
import cerent.util.ior.CdrWriter;
import cerent.util.ior.IopProfile;
import cerent.util.ior.TaggedComponent;
import java.io.IOException;
import java.io.PrintStream;

public class IiopProfile
implements IopProfile {
    private int _major;
    private int _minor;
    private String _host;
    private int _port;
    private byte[] _objectKey;
    private TaggedComponent[] _components;

    public IiopProfile(CdrReader cdrReader) throws IOException {
        this._major = cdrReader.getByte();
        this._minor = cdrReader.getByte();
        this._host = cdrReader.getString();
        this._port = cdrReader.getShort();
        this._objectKey = cdrReader.getBytes();
        if (!(this._minor <= 0 && this._major <= 1 || cdrReader.eof())) {
            int n = cdrReader.getInt();
            if (n <= 0) {
                this._components = null;
            } else {
                this._components = new TaggedComponent[n];
                for (int i = 0; i < n; ++i) {
                    this._components[i] = new TaggedComponent(cdrReader);
                }
            }
        } else {
            this._components = null;
        }
    }

    public CdrWriter write(CdrWriter cdrWriter) throws IOException {
        cdrWriter.putByte(this._major);
        cdrWriter.putByte(this._minor);
        cdrWriter.putString(this._host);
        cdrWriter.putShort(this._port);
        cdrWriter.putBytes(this._objectKey);
        if (this._minor > 0 || this._major > 1) {
            if (this._components == null) {
                cdrWriter.putInt(0);
            } else {
                cdrWriter.putInt(this._components.length);
                for (int i = 0; i < this._components.length; ++i) {
                    this._components[i].write(cdrWriter);
                }
            }
        }
        return cdrWriter;
    }

    public void print(PrintStream printStream, String string) {
        int n;
        printStream.println(string + "major: " + this._major);
        printStream.println(string + "minor: " + this._minor);
        printStream.println(string + "host: " + this._host);
        printStream.println(string + "port: " + this._port);
        printStream.print(string + "key: ");
        for (n = 0; n < this._objectKey.length; ++n) {
            printStream.print(this.asChar(this._objectKey[n]));
        }
        printStream.println();
        if ((this._minor > 0 || this._major > 1) && this._components != null) {
            for (n = 0; n < this._components.length; ++n) {
                this._components[n].print(printStream, string + "  ");
            }
        } else {
            printStream.println(string + "no components");
        }
    }

    public int getVersionMajor() {
        return this._major;
    }

    public void setVersionMajor(int n) {
        this._major = n;
    }

    public int getVersionMinor() {
        return this._minor;
    }

    public void setVersionMinor(int n) {
        this._minor = n;
    }

    public String getHost() {
        return this._host;
    }

    public void setHost(String string) {
        this._host = string;
    }

    public int getPort() {
        return this._port;
    }

    public void setPort(int n) {
        this._port = n;
    }

    public byte[] getObjectKey() {
        return this._objectKey;
    }

    public void setObjectKey(byte[] byArray) {
        this._objectKey = byArray;
    }

    public int getNumComponents() {
        return this._components == null ? 0 : this._components.length;
    }

    public void setNumComponents(int n) {
        this._components = n <= 0 ? null : new TaggedComponent[n];
    }

    public TaggedComponent getComponentAt(int n) {
        return this._components[n];
    }

    public void setComponentAt(int n, TaggedComponent taggedComponent) {
        this._components[n] = taggedComponent;
    }

    private String asChar(byte by) {
        String string = by < 0 ? "\\M" + this.asChar((byte)(by + 128)) : (by < 32 ? "\\C" + (char)(by + 64) : (by == 92 ? "\\" : (by < 127 ? "" + (char)by : "\\C?")));
        return string;
    }

    public void setComponents(TaggedComponent[] taggedComponentArray) {
        this._components = taggedComponentArray;
    }
}

