/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.ior;

import cerent.util.ior.CdrReader;
import cerent.util.ior.CdrWriter;
import cerent.util.ior.Ior;
import java.io.IOException;

public class IorFactory {
    private IorFactory() {
    }

    public static Ior parse(String string) throws IOException {
        CdrReader cdrReader = new CdrReader(IorFactory.decode(string));
        return new Ior(cdrReader);
    }

    public static String stringify(Ior ior) throws IOException {
        CdrWriter cdrWriter = new CdrWriter(false);
        ior.write(cdrWriter);
        return IorFactory.encode(cdrWriter.getBytes());
    }

    private static byte[] decode(String string) throws IOException {
        if (string.startsWith("IOR:")) {
            int n = string.length();
            if (n % 2 == 0) {
                byte[] byArray = new byte[(n - 4) / 2];
                int n2 = 4;
                int n3 = 0;
                while (n2 < n) {
                    byArray[n3++] = IorFactory.decode(string.charAt(n2++), string.charAt(n2++));
                }
                return byArray;
            }
            throw new IOException("Malformed IOR, invalid length " + n);
        }
        throw new IOException("Missing IOR:");
    }

    private static String encode(byte[] byArray) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("IOR:");
        for (int i = 0; i < byArray.length; ++i) {
            IorFactory.encode(stringBuffer, byArray[i]);
        }
        return stringBuffer.toString();
    }

    private static byte decode(char c, char c2) throws IOException {
        return (byte)(IorFactory.decode(c) << 4 | IorFactory.decode(c2));
    }

    private static void encode(StringBuffer stringBuffer, byte by) throws IOException {
        stringBuffer.append(IorFactory.encode(by >> 4 & 0xF));
        stringBuffer.append(IorFactory.encode(by & 0xF));
    }

    private static int decode(char c) throws IOException {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        throw new IOException("Illegal character '" + c + "'");
    }

    private static char encode(int n) throws IOException {
        switch (n) {
            case 0: {
                return '0';
            }
            case 1: {
                return '1';
            }
            case 2: {
                return '2';
            }
            case 3: {
                return '3';
            }
            case 4: {
                return '4';
            }
            case 5: {
                return '5';
            }
            case 6: {
                return '6';
            }
            case 7: {
                return '7';
            }
            case 8: {
                return '8';
            }
            case 9: {
                return '9';
            }
            case 10: {
                return 'a';
            }
            case 11: {
                return 'b';
            }
            case 12: {
                return 'c';
            }
            case 13: {
                return 'd';
            }
            case 14: {
                return 'e';
            }
            case 15: {
                return 'f';
            }
        }
        throw new IOException("Illegal value " + n);
    }
}

