/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.ior;

import cerent.util.ior.CdrReader;
import cerent.util.ior.CdrWriter;
import cerent.util.ior.IiopProfile;
import cerent.util.ior.IopProfile;
import cerent.util.ior.MultiComponentProfile;
import java.io.IOException;
import java.io.PrintStream;

public class TaggedProfile {
    private int _tag;
    private IopProfile _profile;

    public TaggedProfile(CdrReader cdrReader) throws IOException {
        this._tag = cdrReader.getInt();
        switch (this._tag) {
            case 0: {
                this._profile = new IiopProfile(new CdrReader(cdrReader.getBytes()));
                break;
            }
            case 1: {
                this._profile = new MultiComponentProfile(new CdrReader(cdrReader.getBytes()));
                break;
            }
            default: {
                throw new IOException("Unknown IOP Profile tag " + this._tag);
            }
        }
    }

    public CdrWriter write(CdrWriter cdrWriter) throws IOException {
        cdrWriter.putInt(this._tag);
        CdrWriter cdrWriter2 = new CdrWriter(cdrWriter.endian());
        this._profile.write(cdrWriter2);
        cdrWriter.putBytes(cdrWriter2.getBytes());
        return cdrWriter;
    }

    public void print(PrintStream printStream, String string) {
        printStream.println(string + "tag: " + this._tag);
        this._profile.print(printStream, string);
    }

    public int getTag() {
        return this._tag;
    }

    public void setTag(int n) {
        this._tag = n;
    }

    public IopProfile getProfile() {
        return this._profile;
    }

    public void setProfile(IopProfile iopProfile) {
        this._profile = iopProfile;
    }

    public boolean isIiopProfile() {
        return this._tag == 0;
    }

    public void setIiopProfile() {
        this._tag = 0;
    }

    public boolean isMultipleComponentsProfile() {
        return this._tag == 1;
    }

    public void setMultipleComponentsProfile() {
        this._tag = 1;
    }
}

