/*
 * Decompiled with CFR 0.152.
 */
package cerent.version;

import cerent.launcher.CmsClassLoader;
import cerent.util.SDebug;
import cerent.version.AbstractInterfaceVersion;
import cerent.version.AbstractJarBuildInformation;
import cerent.version.Compatibility;
import cerent.version.IBuildInformation;
import cerent.version.InternalLayerVersion;
import cerent.version.InvalidScopeException;

public class EleInterfaceVersion
extends AbstractInterfaceVersion {
    private static SDebug db = new SDebug("EleInterfaceVersion");
    IBuildInformation buildInformation;
    InternalLayerVersion version;
    boolean forceIncompat = false;

    public EleInterfaceVersion() {
        try {
            ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
            Class<?> clazz = classLoader.loadClass("cerent.version.AbstractJarBuildInformation");
            this.buildInformation = new EleBuildInformation();
            this.version = new InternalLayerVersion("ele", this.buildInformation);
            this.forceIncompat = false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.buildInformation = null;
            this.version = EleInterfaceVersion.createUnavailableInternalLayerVersion("ele");
            this.forceIncompat = true;
        }
    }

    private static InternalLayerVersion createUnavailableInternalLayerVersion(String string) {
        return new InternalLayerVersion(string, -1);
    }

    protected final int compareTo(InternalLayerVersion internalLayerVersion) {
        InternalLayerVersion internalLayerVersion2 = (InternalLayerVersion)this.getVersion();
        return internalLayerVersion2.compareTo((Object)internalLayerVersion);
    }

    public Object getVersion() {
        return this.version;
    }

    public IBuildInformation getBuildInformation() {
        return this.buildInformation;
    }

    public boolean isNewerThan(AbstractInterfaceVersion abstractInterfaceVersion) throws InvalidScopeException {
        InternalLayerVersion internalLayerVersion = (InternalLayerVersion)abstractInterfaceVersion.getVersion();
        return this.compareTo(internalLayerVersion) > 0;
    }

    public boolean isSameVersionAs(AbstractInterfaceVersion abstractInterfaceVersion) throws InvalidScopeException {
        InternalLayerVersion internalLayerVersion = (InternalLayerVersion)abstractInterfaceVersion.getVersion();
        return this.compareTo(internalLayerVersion) == 0;
    }

    public Compatibility getCompatibilityWith(AbstractInterfaceVersion abstractInterfaceVersion) {
        if (this.forceIncompat) {
            return Compatibility.FORCE_INCOMPATIBLE;
        }
        InternalLayerVersion internalLayerVersion = (InternalLayerVersion)this.getVersion();
        InternalLayerVersion internalLayerVersion2 = (InternalLayerVersion)abstractInterfaceVersion.getVersion();
        Compatibility compatibility = Compatibility.UNKNOWN;
        if (internalLayerVersion2.isCoreJarFile()) {
            if (db.on()) {
                db.println("this.version=" + internalLayerVersion + "  other.version=" + internalLayerVersion2);
            }
            if (this.compareTo(internalLayerVersion2) <= 0) {
                compatibility = Compatibility.COMPATIBLE;
            }
        } else if (internalLayerVersion2.getLayerName().equals("ne")) {
            if (this.compareTo(internalLayerVersion2) == 0) {
                compatibility = Compatibility.COMPATIBLE;
            } else if (internalLayerVersion2.compareTo((Object)InternalLayerVersion.LATEST_VER_OBJ) == 0) {
                compatibility = Compatibility.COMPATIBLE;
            }
        }
        db.fine("this -- " + internalLayerVersion.getLayerName() + ": " + internalLayerVersion);
        db.fine("other -- " + internalLayerVersion2.getLayerName() + ": " + internalLayerVersion2);
        db.fine("compat -- " + compatibility);
        return compatibility;
    }

    public String getSwVersion() {
        return ((CmsClassLoader)((Object)((Object)this)).getClass().getClassLoader()).getSwVersion();
    }

    private final class EleBuildInformation
    extends AbstractJarBuildInformation {
        public EleBuildInformation() {
            super(AbstractJarBuildInformation.ELEMENT_MANIFEST);
        }
    }
}

