/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.crs.model;

import cerent.cms.fv.IFvEntityModel;
import cerent.cms.fv.IFvNodeModel;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.InvalidUpperBound;
import cerent.cms.model.ModelUpdateType;
import cerent.util.EnumStrings;
import cerent.util.ILoNum;
import cerent.util.TDMTerminology;
import com.cisco.crs.model.AbstractModel;
import com.cisco.crs.model.EntityTableModel;
import com.cisco.crs.model.PlatformNodeModel;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EntityModel
extends AbstractModel
implements IEntityModel {
    private EntityModel parent;
    private String internalId;
    private int entityIndex;
    private int eqType;
    private List<EntityModel> children = new LinkedList<EntityModel>();
    private String description;
    private boolean markedForDeletion = false;

    public EntityModel(PlatformNodeModel platformNodeModel, EntityModel entityModel, String string, int n, int n2) {
        super(platformNodeModel, platformNodeModel.getChildDebug(EntityModel.class));
        this.parent = entityModel;
        this.internalId = string;
        this.entityIndex = n;
        this.eqType = n2;
        if (entityModel != null) {
            entityModel.add(this);
        }
        this.notifyObservers(ModelUpdateType.ADDED);
    }

    private void add(EntityModel entityModel) {
        this.children.add(entityModel);
        this.setChanged();
        this.notifyObservers(ModelUpdateType.CHANGED);
    }

    public String getInternalId() {
        return this.internalId;
    }

    public int getEntityIndex() {
        return this.entityIndex;
    }

    @Override
    public int getIndex() {
        return this.entityIndex;
    }

    public IModuleModel getModuleModel() {
        EntityModel entityModel = this;
        while (!(entityModel instanceof IModuleModel)) {
            entityModel = entityModel.getParent();
        }
        return (IModuleModel)entityModel;
    }

    public int getSlot() {
        IEntityModel iEntityModel = this.getAncestorOfClassType(2);
        if (iEntityModel != null) {
            return iEntityModel.getSlot();
        }
        return -1;
    }

    public int getPort() {
        return 0;
    }

    public String getEqLabel() {
        return this.getEqTypeName();
    }

    public void setEqLabel(String string) {
    }

    public int getEqType() {
        return this.eqType;
    }

    public String getEqTypeName() {
        return EntityModel.eqType2Name(this.getNodeModel().getTDMTerminology(), this.getEqType());
    }

    public IEntityModel getParent() {
        if (this.parent == null) {
            throw new CmsObjectNotExistException("The parent entity is null for the entity:" + Integer.toHexString(this.getIndex()) + ".");
        }
        return this.parent;
    }

    public int getPositionInParent() {
        int n = -1;
        if (this.parent != null) {
            for (EntityModel entityModel : this.parent.children) {
                ++n;
                if (entityModel != this) continue;
                break;
            }
        }
        return n;
    }

    public List getChildren() {
        return new LinkedList<EntityModel>(this.children);
    }

    public List getMfgEntities() {
        return Collections.EMPTY_LIST;
    }

    public List getDescendantsOfClassType(int n) {
        LinkedList<IEntityModel> linkedList = new LinkedList<IEntityModel>();
        this.getDescendantsOfClass(n, linkedList);
        return linkedList;
    }

    public List getDescendantsOfEqType(int n) {
        LinkedList<IEntityModel> linkedList = new LinkedList<IEntityModel>();
        this.getDescendantsOfEqType(n, linkedList);
        return linkedList;
    }

    public IEntityModel getAncestorOfClassType(int n) {
        EntityModel entityModel;
        for (entityModel = this.parent; entityModel != null && entityModel.getGenericClass() != n; entityModel = entityModel.getParent()) {
        }
        return entityModel;
    }

    public IEntityModel getAncestorOfEqType(int n) {
        EntityModel entityModel;
        for (entityModel = this.parent; entityModel != null && entityModel.getEqType() != n; entityModel = entityModel.getParent()) {
        }
        return entityModel;
    }

    public String toShortString() {
        if (this.description == null) {
            String[] stringArray = EnumStrings.getStrings(eEqType.class);
            String[] stringArray2 = EnumStrings.getStrings(eClass.class);
            this.description = this.getNodeModel().getName() + "-0x" + Integer.toHexString(this.entityIndex) + " (" + this.internalId + "), " + stringArray[this.getEqType()] + "/" + stringArray2[this.getGenericClass()] + " @" + this.getPositionInParent();
        }
        return this.description;
    }

    public abstract int getGenericClass();

    public int getMediumType() {
        return 0;
    }

    public int getPayloadType() {
        return 0;
    }

    public ILoNum getMaxLo(int n) {
        return null;
    }

    public int getMaxVt() {
        return 0;
    }

    public List getConnectionsList() {
        return Collections.EMPTY_LIST;
    }

    public String getAlarmProfileName() {
        return "";
    }

    public void setAlarmProfileName(String string) throws InvalidUpperBound {
    }

    public boolean getSuppressAlarms() {
        return false;
    }

    public void setSuppressAlarms(boolean bl) {
    }

    public boolean isCompatiblePGEntity(IEntityModel iEntityModel) {
        return false;
    }

    public boolean onPortlessPort() {
        return false;
    }

    public boolean onPairPortlessPorts(IEntityModel iEntityModel) {
        return false;
    }

    public boolean conditionExist(String string) {
        return false;
    }

    public int getShelfId() {
        IEntityModel iEntityModel = this.getAncestorOfClassType(0);
        if (iEntityModel != null) {
            return iEntityModel.getShelfId();
        }
        return -1;
    }

    public boolean inRPRMode() {
        return false;
    }

    public IEntityModel isProtected() {
        return null;
    }

    public IEntityModel isYCableProtected() {
        return null;
    }

    @Override
    public void dispose() {
        if (this.db.on()) {
            this.db.println("Dispose called");
        }
        EntityTableModel entityTableModel = (EntityTableModel)this.getNodeModel().getEntityTable();
        entityTableModel.removeEntityModel(this);
        super.dispose();
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    public boolean equals(Object object) {
        if (object instanceof EntityModel) {
            EntityModel entityModel = (EntityModel)object;
            return entityModel.getEntityIndex() == this.getEntityIndex() && entityModel.getEqType() == this.getEqType() && entityModel.getGenericClass() == this.getGenericClass();
        }
        return false;
    }

    public void init() {
        if (!this.isInited()) {
            super.init0();
        }
        for (EntityModel entityModel : this.children) {
            entityModel.init();
        }
    }

    public void markForDeletion() {
        this.markedForDeletion = true;
        for (EntityModel entityModel : this.children) {
            entityModel.markForDeletion();
        }
    }

    public void unmarkForDeletion() {
        this.markedForDeletion = false;
    }

    public boolean isMarkedForDeletion() {
        return this.markedForDeletion;
    }

    public void disposeIfMarkedForDeletion() {
        Iterator<EntityModel> iterator = this.children.iterator();
        while (iterator.hasNext()) {
            EntityModel entityModel = iterator.next();
            entityModel.disposeIfMarkedForDeletion();
            if (!entityModel.isMarkedForDeletion()) continue;
            iterator.remove();
        }
        if (this.markedForDeletion) {
            if (this.db.on()) {
                this.db.println("Marked for deletion - Disposing entity " + this);
            }
            this.dispose();
            this.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getDescendantsOfEqType(int n, List<IEntityModel> list) {
        if (this.getEqType() == n) {
            list.add(this);
        }
        List<EntityModel> list2 = this.children;
        synchronized (list2) {
            for (EntityModel entityModel : this.children) {
                entityModel.getDescendantsOfEqType(n, list);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getDescendantsOfClass(int n, List<IEntityModel> list) {
        if (this.getGenericClass() == n) {
            list.add(this);
        }
        List<EntityModel> list2 = this.children;
        synchronized (list2) {
            for (EntityModel entityModel : this.children) {
                entityModel.getDescendantsOfClass(n, list);
            }
        }
    }

    private static String eqType2Name(TDMTerminology tDMTerminology, int n) {
        switch (n) {
            case 288: {
                return "CHASSIS CRS-1";
            }
            case 289: {
                return "CRS SLOT";
            }
            case 290: {
                return "4 10GE PLIM";
            }
            case 291: {
                return "PLIM Optic Port";
            }
            case 292: {
                return "OC768 PLIM";
            }
            case 320: {
                return "OC768 DPSK PLIM";
            }
            case 329: {
                return "UNKNOWN";
            }
        }
        return "";
    }

    public List<EntityModel> getAllChildrenRecur() {
        LinkedList<EntityModel> linkedList = new LinkedList<EntityModel>();
        return EntityModel.getAllChildrenRecur(this, linkedList);
    }

    private static List<EntityModel> getAllChildrenRecur(EntityModel entityModel, List<EntityModel> list) {
        list.add(entityModel);
        List list2 = entityModel.getChildren();
        for (EntityModel entityModel2 : list2) {
            EntityModel.getAllChildrenRecur(entityModel2, list);
        }
        return list;
    }

    public String toString() {
        return "Entity[" + this.toShortString() + "]";
    }

    public IFvEntityModel getTheEntityModel() {
        return this.getModuleModel();
    }

    public IFvNodeModel getIFVNodeModel() {
        return (IFvNodeModel)this.getNodeModel();
    }
}

