/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.crs.model;

import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.AlreadyInUse;
import cerent.cms.model.CannotPerform;
import cerent.cms.model.CmsNoSuchElementException;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.INodeOpticsTopologyModel;
import cerent.cms.model.IPlimTrkLineModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IPptListener;
import cerent.cms.model.ISOchPath;
import cerent.cms.model.IYCableModel;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.WrongPathType;
import cerent.util.DetailedLog;
import cerent.util.EventBus;
import cerent.util.EventBusServices;
import cerent.util.Pair;
import cerent.util.SDebug;
import com.cisco.crs.model.AbstractModel;
import com.cisco.crs.model.ChassisModel;
import com.cisco.crs.model.EntityModel;
import com.cisco.crs.model.PlatformNodeModel;
import com.cisco.crs.model.PlimPortModel;
import com.cisco.crs.model.core.LmpIdStore;
import com.cisco.crs.model.core.TTIObject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeOpticsTopologyModel
extends AbstractModel
implements INodeOpticsTopologyModel {
    public NodeOpticsTopologyModel(PlatformNodeModel platformNodeModel) {
        super(platformNodeModel, platformNodeModel.getChildDebug(NodeOpticsTopologyModel.class));
    }

    public int[] getOchTrailTrunkPort(int n) throws NoSuchEquipment {
        return AbstractModel.emptyIntArray;
    }

    public int[] getAvailClientsForTrunk(int n) throws NoSuchEquipment {
        return AbstractModel.emptyIntArray;
    }

    public int[] getAvailEntitiesForOchnc(int n, int n2, boolean bl) throws AlreadyInUse, WrongPathType {
        return AbstractModel.emptyIntArray;
    }

    public int[] getAvailEntitiesForOchnc(int n, int n2) throws AlreadyInUse, WrongPathType {
        return AbstractModel.emptyIntArray;
    }

    public int[] getAvailEntitiesForOchcc(int n, int n2, boolean bl) throws AlreadyInUse {
        return AbstractModel.emptyIntArray;
    }

    public int[] getAvailEntitiesForOchcc(int n, int n2) throws AlreadyInUse {
        return AbstractModel.emptyIntArray;
    }

    public int[] getAvailEntitiesForOchTrail(int n, int n2) throws AlreadyInUse {
        return AbstractModel.emptyIntArray;
    }

    public int[] getAvailEntitiesForOchTrail(int n, int n2, boolean bl) throws AlreadyInUse {
        Object object;
        if (this.db.on()) {
            this.db.println("Called getAvailEntitiesForOchTrail(" + n + ", " + n2 + ")");
        }
        IEntityModel[] iEntityModelArray = this.getNodeModel().getChassisModels();
        LinkedList linkedList = new LinkedList();
        for (IEntityModel iEntityModel : iEntityModelArray) {
            object = (ChassisModel)iEntityModel;
            linkedList.addAll(((EntityModel)object).getDescendantsOfEqType(291));
        }
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            IEntityModel iEntityModel;
            PlimPortModel plimPortModel = (PlimPortModel)iterator.next();
            IInterfaceModel iInterfaceModel = plimPortModel.getInterfaceModel();
            if (iInterfaceModel == null || !(iInterfaceModel instanceof IPlimTrkLineModel)) continue;
            iEntityModel = (IPlimTrkLineModel)iInterfaceModel;
            if (this.db.isFinestEnabled()) {
                this.db.println("Found PLIM with IOpticsChannelModel: " + plimPortModel);
            }
            try {
                if (LmpIdStore.getInstance().getLmpId(this.node.getIpAddr(), plimPortModel.getIndex()) == -1) {
                    iterator.remove();
                    if (!this.db.isFinestEnabled()) continue;
                    this.db.println("Skipped for missing Lmp DataLink");
                    continue;
                }
                if (iEntityModel.getActualWaveLength() == n) {
                    if (iEntityModel.getConnectionId() == null) continue;
                    iterator.remove();
                    object = new TTIObject();
                    if (!((TTIObject)object).initialize(iEntityModel.getConnectionId())) {
                        DetailedLog detailedLog = new DetailedLog(2, "Plim [" + plimPortModel.getInternalId() + "@" + plimPortModel.getNodeModel().getName() + "] skipped during OCHTRAIL evaluation: Plim contains an invalid Circuit Connection Id string.");
                        EventBus.instance().notifyEvent((Object)EventBusServices.BG_STATUS_COLLECTOR, (Object)detailedLog);
                        if (!this.db.isFinestEnabled()) continue;
                        this.db.println("Skipped for existing invalid connection id string");
                        continue;
                    }
                    if (!this.db.isFinestEnabled()) continue;
                    this.db.println("Skipped for existing  connection");
                    continue;
                }
                iterator.remove();
                if (!this.db.isFinestEnabled()) continue;
                this.db.println("Skipped for wavelength mismatch: " + iEntityModel.getActualWaveLength());
            }
            catch (Exception exception) {
                iterator.remove();
                if (!this.db.on()) continue;
                this.db.println("Cannot get actual wavelength for " + plimPortModel + " - Port skipped");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        int[] nArray = new int[linkedList.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = ((PlimPortModel)linkedList.get(i)).getEntityIndex();
        }
        if (this.db.on()) {
            this.db.println("Called getAvailEntitiesForOchTrail(" + n + ", " + n2 + ")");
        }
        return nArray;
    }

    public int[] getAvailOchncPathEntities(int n, int n2) throws AlreadyInUse, NoSuchEquipment {
        return AbstractModel.emptyIntArray;
    }

    public int[] getOchncLineReverseEntitiesPair(int n, int n2) throws AlreadyInUse, NoSuchEquipment, WrongPathType {
        return AbstractModel.emptyIntArray;
    }

    public int[] getOchncLineReverseEntitiesPair(int n, int n2, int n3) {
        return AbstractModel.emptyIntArray;
    }

    public int[] getAvailAddEntitiesForOchnc() {
        return AbstractModel.emptyIntArray;
    }

    public int[] getAvailOchccPorts() {
        return AbstractModel.emptyIntArray;
    }

    public int getSideForOscPort(int n) throws FeatureUnsupported, CannotPerform, AbstractCmsNoSuchElementException {
        throw new CmsNoSuchElementException("OSC port " + Integer.toHexString(n) + " is not managed");
    }

    public int getSideForOtsPort(int n) throws FeatureUnsupported, CannotPerform, AbstractCmsNoSuchElementException {
        throw new CmsNoSuchElementException("OTS port " + Integer.toHexString(n) + " is not managed");
    }

    public int getSideInputEntityIdx(int n) throws NoSuchEquipment {
        throw new NoSuchEquipment("Side " + n + " is not managed");
    }

    public int getSideOutputEntityIdx(int n) throws NoSuchEquipment {
        throw new NoSuchEquipment("Side " + n + " is not managed");
    }

    public ISOchPath getAllOchListFromPort(int n) {
        return null;
    }

    public int[] getAvailEntitiesForOchnc(int n, int n2, boolean bl, boolean bl2) throws AlreadyInUse, WrongPathType {
        return null;
    }

    public int getSideInputProtectEntityIdx(int n) throws NoSuchEquipment {
        return 0;
    }

    public int getSideOutputProtectEntityIdx(int n) throws NoSuchEquipment {
        return 0;
    }

    public IPortModel getSplitterEntity(int n, int n2) throws NoSuchEquipment {
        return null;
    }

    public IYCableModel getSplitterModel(int n) throws NoSuchEquipment {
        return null;
    }

    public boolean startPpt(int n, List<Pair<IIpAddr, Integer>> list, IPptListener iPptListener) {
        return false;
    }
}

