/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.crs.model;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.InvalidLoopbackProvision;
import cerent.cms.model.InvalidState;
import cerent.cms.model.LoopbackActive;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SyncProvError;
import cerent.cms.model.UnsupportedOperation;
import cerent.util.tty.ICLIXMLTags;
import com.cisco.crs.model.EntityModel;
import com.cisco.crs.model.PlatformNodeModel;
import com.cisco.crs.model.PlimInterfaceModel;
import com.cisco.crs.model.PlimPortId;
import com.cisco.crs.model.PortModel;
import com.cisco.crs.model.core.AbstractCLIAdapter;
import com.cisco.crs.model.core.CachedValue;
import com.cisco.crs.model.core.Value;
import com.cisco.crs.model.parser.ShowControllersDwdmParser;

public class PlimPortModel
extends PortModel {
    private PlimInterfaceModel ifModel;
    private PlimPortId.PlimType plimType;
    private CachedValue showControllersDwdmCV;

    public PlimPortModel(PlatformNodeModel platformNodeModel, EntityModel entityModel, String string, int n, int n2, int n3, PlimPortId.PlimType plimType) {
        super(platformNodeModel, entityModel, string, n, n2, n3);
        this.plimType = plimType;
        this.createIValues();
        this.ifModel = new PlimInterfaceModel(platformNodeModel, this, 0);
    }

    public IInterfaceModel getInterfaceModel() {
        return this.ifModel;
    }

    public int getAdminState() throws NoSuchInterface {
        ShowControllersDwdmParser.ControllerState controllerState = this.getControllerState();
        if (controllerState != null) {
            eAdminState eAdminState2 = controllerState.getState().toAdminState();
            if (eAdminState2 != null) {
                return eAdminState2.value();
            }
            return -1;
        }
        return super.getAdminState();
    }

    public boolean maybeSetAdminState(int n, int n2, int n3) throws NoSuchInterface, LoopbackActive, InvalidLoopbackProvision, UnsupportedOperation, SyncProvError, InvalidState, ProvisionError {
        return this.setAdminState(n);
    }

    public int getServiceStateType() throws NoSuchInterface {
        ShowControllersDwdmParser.ControllerState controllerState = this.getControllerState();
        if (controllerState != null) {
            return controllerState.getState().getServiceStateType();
        }
        return super.getServiceStateType();
    }

    public PlimPortId.PlimType getPlimType() {
        return this.plimType;
    }

    public boolean setAdminState(int n) throws NoSuchInterface {
        ShowControllersDwdmParser.ControllerState controllerState = this.getControllerState();
        if (n == 0 || n == 3) {
            controllerState.setState(ShowControllersDwdmParser.StateEnum.UP);
        } else {
            controllerState.setState(ShowControllersDwdmParser.StateEnum.ADMIN_DOWN);
        }
        return true;
    }

    ShowControllersDwdmParser.TTI getTTI() {
        Value value = this.showControllersDwdmCV.get();
        if (!value.isNull()) {
            ShowControllersDwdmParser.Response response = (ShowControllersDwdmParser.Response)value.get();
            return response.getTTI();
        }
        return null;
    }

    ShowControllersDwdmParser.ControllerState getControllerState() {
        Value value = this.showControllersDwdmCV.get();
        if (!value.isNull()) {
            ShowControllersDwdmParser.Response response = (ShowControllersDwdmParser.Response)value.get();
            return response.getState();
        }
        return null;
    }

    ShowControllersDwdmParser.DwdmWavelength getDwdmWavelength() {
        Value value = this.showControllersDwdmCV.get();
        if (!value.isNull()) {
            ShowControllersDwdmParser.Response response = (ShowControllersDwdmParser.Response)value.get();
            return response.getWlen();
        }
        return null;
    }

    ShowControllersDwdmParser.G709Attr getG709Attrs() {
        Value value = this.showControllersDwdmCV.get();
        if (!value.isNull()) {
            ShowControllersDwdmParser.Response response = (ShowControllersDwdmParser.Response)value.get();
            return response.getG709Attr();
        }
        return null;
    }

    ShowControllersDwdmParser.LmpId getLmpId() {
        Value value = this.showControllersDwdmCV.get();
        if (!value.isNull()) {
            ShowControllersDwdmParser.Response response = (ShowControllersDwdmParser.Response)value.get();
            return response.getLmpId();
        }
        return null;
    }

    ShowControllersDwdmParser.ConnectionId getConnectionId() {
        Value value = this.showControllersDwdmCV.get();
        if (!value.isNull()) {
            ShowControllersDwdmParser.Response response = (ShowControllersDwdmParser.Response)value.get();
            return response.getConnectionId();
        }
        return null;
    }

    public void init() {
        super.init();
        this.showControllersDwdmCV.init();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Port[").append(this.toShortString()).append("]");
        ShowControllersDwdmParser.ControllerState controllerState = this.getControllerState();
        if (controllerState != null) {
            stringBuilder.append(", Admin State: ").append(controllerState.getState().adminStateString());
            stringBuilder.append(", Service State: ").append(controllerState.getState().serviceStateString());
        } else {
            stringBuilder.append(", States UNKNOWN");
        }
        if (this.ifModel != null) {
            stringBuilder.append("\n\t").append(this.ifModel.prettyString());
        }
        return stringBuilder.toString();
    }

    public void dispose() {
        this.ifModel.dispose();
        this.showControllersDwdmCV.dispose();
        super.dispose();
    }

    public void destroy() {
        this.ifModel.destroy();
        super.destroy();
    }

    private void createIValues() {
        this.showControllersDwdmCV = new CachedValue(new ShowControllersDwdm());
    }

    public void requireLock() {
        this.showControllersDwdmCV.lock();
    }

    private class ShowControllersDwdm
    extends AbstractCLIAdapter
    implements ICLIXMLTags {
        private static final String GET_WLEN = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Request><Get><Configuration><InterfaceConfigurationTable MajorVersion=\"3\" MinorVersion=\"1\"><InterfaceConfiguration><Naming><Active>act</Active><InterfaceName>dwdm_PARAMETER_</InterfaceName></Naming><Shutdown Match=\"*\"/><DWDM/></InterfaceConfiguration></InterfaceConfigurationTable></Configuration></Get><CLI><Exec>show mpls lmp interface _PARAMETER2_ _PARAMETER_</Exec></CLI></Request>";

        public ShowControllersDwdm() {
            super(PlimPortModel.this.getNMD(), PlimPortModel.this, GET_WLEN.replace("_PARAMETER_", PlimPortModel.this.getInternalId()).replace("_PARAMETER2_", PlimPortModel.this.getPlimType().toString()), ShowControllersDwdmParser.instance());
        }

        public String getLabel() {
            return super.getLabel() + "-" + PlimPortModel.this.toShortString();
        }
    }
}

